/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.AccessFlags;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.Method;
import org.jf.dexlib2.iface.MethodImplementation;
import org.jf.dexlib2.iface.instruction.Instruction;
import org.jf.dexlib2.iface.instruction.ReferenceInstruction;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.iface.reference.Reference;
import org.jf.dexlib2.util.ReferenceUtil;
import org.jf.dexlib2.util.SyntheticAccessorFSM;

public class SyntheticAccessorResolver {
    public static final int METHOD = 0;
    public static final int GETTER = 1;
    public static final int SETTER = 2;
    public static final int POSTFIX_INCREMENT = 3;
    public static final int PREFIX_INCREMENT = 4;
    public static final int POSTFIX_DECREMENT = 5;
    public static final int PREFIX_DECREMENT = 6;
    public static final int ADD_ASSIGNMENT = 7;
    public static final int SUB_ASSIGNMENT = 8;
    public static final int MUL_ASSIGNMENT = 9;
    public static final int DIV_ASSIGNMENT = 10;
    public static final int REM_ASSIGNMENT = 11;
    public static final int AND_ASSIGNMENT = 12;
    public static final int OR_ASSIGNMENT = 13;
    public static final int XOR_ASSIGNMENT = 14;
    public static final int SHL_ASSIGNMENT = 15;
    public static final int SHR_ASSIGNMENT = 16;
    public static final int USHR_ASSIGNMENT = 17;
    private final SyntheticAccessorFSM syntheticAccessorFSM;
    private final Map<String, ClassDef> classDefMap;
    private final Map<String, AccessedMember> resolvedAccessors;

    public SyntheticAccessorResolver(@Nonnull Opcodes opcodes, @Nonnull Iterable<? extends ClassDef> classDefs) {
        if (opcodes == null) {
            SyntheticAccessorResolver.$$$reportNull$$$0(0);
        }
        if (classDefs == null) {
            SyntheticAccessorResolver.$$$reportNull$$$0(1);
        }
        this.resolvedAccessors = Maps.newConcurrentMap();
        this.syntheticAccessorFSM = new SyntheticAccessorFSM(opcodes);
        ImmutableMap.Builder<String, ClassDef> builder = ImmutableMap.builder();
        for (ClassDef classDef : classDefs) {
            builder.put(classDef.getType(), classDef);
        }
        this.classDefMap = builder.build();
    }

    public static boolean looksLikeSyntheticAccessor(String methodName) {
        return methodName.startsWith("access$");
    }

    @Nullable
    public AccessedMember getAccessedMember(@Nonnull MethodReference methodReference) {
        String methodDescriptor;
        AccessedMember accessedMember;
        if (methodReference == null) {
            SyntheticAccessorResolver.$$$reportNull$$$0(2);
        }
        if ((accessedMember = this.resolvedAccessors.get(methodDescriptor = ReferenceUtil.getMethodDescriptor(methodReference))) != null) {
            return accessedMember;
        }
        String type = methodReference.getDefiningClass();
        ClassDef classDef = this.classDefMap.get(type);
        if (classDef == null) {
            return null;
        }
        Method matchedMethod = null;
        MethodImplementation matchedMethodImpl = null;
        for (Method method : classDef.getMethods()) {
            MethodImplementation methodImpl = method.getImplementation();
            if (methodImpl == null || !SyntheticAccessorResolver.methodReferenceEquals(method, methodReference)) continue;
            matchedMethod = method;
            matchedMethodImpl = methodImpl;
            break;
        }
        if (matchedMethod == null) {
            return null;
        }
        if (!AccessFlags.SYNTHETIC.isSet(matchedMethod.getAccessFlags())) {
            return null;
        }
        ImmutableList<? extends Instruction> instructions = ImmutableList.copyOf(matchedMethodImpl.getInstructions());
        int n = this.syntheticAccessorFSM.test(instructions);
        if (n >= 0) {
            AccessedMember member = new AccessedMember(n, ((ReferenceInstruction)instructions.get(0)).getReference());
            this.resolvedAccessors.put(methodDescriptor, member);
            return member;
        }
        return null;
    }

    private static boolean methodReferenceEquals(@Nonnull MethodReference ref1, @Nonnull MethodReference ref2) {
        if (ref1 == null) {
            SyntheticAccessorResolver.$$$reportNull$$$0(3);
        }
        if (ref2 == null) {
            SyntheticAccessorResolver.$$$reportNull$$$0(4);
        }
        return ref1.getName().equals(ref2.getName()) && ref1.getReturnType().equals(ref2.getReturnType()) && ref1.getParameterTypes().equals(ref2.getParameterTypes());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "opcodes";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDefs";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodReference";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref1";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref2";
                break;
            }
        }
        objectArray2[1] = "org/jf/dexlib2/util/SyntheticAccessorResolver";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getAccessedMember";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "methodReferenceEquals";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class AccessedMember {
        public final int accessedMemberType;
        @Nonnull
        public final Reference accessedMember;

        public AccessedMember(int accessedMemberType, @Nonnull Reference accessedMember) {
            if (accessedMember == null) {
                AccessedMember.$$$reportNull$$$0(0);
            }
            this.accessedMemberType = accessedMemberType;
            this.accessedMember = accessedMember;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", "accessedMember", "org/jf/dexlib2/util/SyntheticAccessorResolver$AccessedMember", "<init>"));
        }
    }
}

