/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.util;

import java.io.IOException;
import java.io.Writer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.iface.reference.FieldReference;
import org.jf.dexlib2.iface.reference.MethodProtoReference;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.iface.reference.Reference;
import org.jf.dexlib2.iface.reference.StringReference;
import org.jf.dexlib2.iface.reference.TypeReference;
import org.jf.util.StringUtils;

public final class ReferenceUtil {
    public static String getMethodDescriptor(MethodReference methodReference) {
        return ReferenceUtil.getMethodDescriptor(methodReference, false);
    }

    public static String getMethodDescriptor(MethodReference methodReference, boolean useImplicitReference) {
        StringBuilder sb = new StringBuilder();
        if (!useImplicitReference) {
            sb.append(methodReference.getDefiningClass());
            sb.append("->");
        }
        sb.append(methodReference.getName());
        sb.append('(');
        for (CharSequence charSequence : methodReference.getParameterTypes()) {
            sb.append(charSequence);
        }
        sb.append(')');
        sb.append(methodReference.getReturnType());
        return sb.toString();
    }

    public static String getMethodProtoDescriptor(MethodProtoReference methodProtoReference) {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        for (CharSequence charSequence : methodProtoReference.getParameterTypes()) {
            sb.append(charSequence);
        }
        sb.append(')');
        sb.append(methodProtoReference.getReturnType());
        return sb.toString();
    }

    public static void writeMethodDescriptor(Writer writer, MethodReference methodReference) throws IOException {
        ReferenceUtil.writeMethodDescriptor(writer, methodReference, false);
    }

    public static void writeMethodDescriptor(Writer writer, MethodReference methodReference, boolean useImplicitReference) throws IOException {
        if (!useImplicitReference) {
            writer.write(methodReference.getDefiningClass());
            writer.write("->");
        }
        writer.write(methodReference.getName());
        writer.write(40);
        for (CharSequence charSequence : methodReference.getParameterTypes()) {
            writer.write(charSequence.toString());
        }
        writer.write(41);
        writer.write(methodReference.getReturnType());
    }

    public static String getFieldDescriptor(FieldReference fieldReference) {
        return ReferenceUtil.getFieldDescriptor(fieldReference, false);
    }

    public static String getFieldDescriptor(FieldReference fieldReference, boolean useImplicitReference) {
        StringBuilder sb = new StringBuilder();
        if (!useImplicitReference) {
            sb.append(fieldReference.getDefiningClass());
            sb.append("->");
        }
        sb.append(fieldReference.getName());
        sb.append(':');
        sb.append(fieldReference.getType());
        return sb.toString();
    }

    public static String getShortFieldDescriptor(FieldReference fieldReference) {
        StringBuilder sb = new StringBuilder();
        sb.append(fieldReference.getName());
        sb.append(':');
        sb.append(fieldReference.getType());
        return sb.toString();
    }

    public static void writeFieldDescriptor(Writer writer, FieldReference fieldReference) throws IOException {
        ReferenceUtil.writeFieldDescriptor(writer, fieldReference, false);
    }

    public static void writeFieldDescriptor(Writer writer, FieldReference fieldReference, boolean implicitReference) throws IOException {
        if (!implicitReference) {
            writer.write(fieldReference.getDefiningClass());
            writer.write("->");
        }
        writer.write(fieldReference.getName());
        writer.write(58);
        writer.write(fieldReference.getType());
    }

    @Nullable
    public static String getReferenceString(@Nonnull Reference reference) {
        if (reference == null) {
            ReferenceUtil.$$$reportNull$$$0(0);
        }
        return ReferenceUtil.getReferenceString(reference, null);
    }

    @Nullable
    public static String getReferenceString(@Nonnull Reference reference, @Nullable String containingClass) {
        if (reference == null) {
            ReferenceUtil.$$$reportNull$$$0(1);
        }
        if (reference instanceof StringReference) {
            return String.format("\"%s\"", StringUtils.escapeString(((StringReference)reference).getString()));
        }
        if (reference instanceof TypeReference) {
            return ((TypeReference)reference).getType();
        }
        if (reference instanceof FieldReference) {
            FieldReference fieldReference = (FieldReference)reference;
            boolean useImplicitReference = fieldReference.getDefiningClass().equals(containingClass);
            return ReferenceUtil.getFieldDescriptor(fieldReference, useImplicitReference);
        }
        if (reference instanceof MethodReference) {
            MethodReference methodReference = (MethodReference)reference;
            boolean useImplicitReference = methodReference.getDefiningClass().equals(containingClass);
            return ReferenceUtil.getMethodDescriptor(methodReference, useImplicitReference);
        }
        if (reference instanceof MethodProtoReference) {
            MethodProtoReference methodProtoReference = (MethodProtoReference)reference;
            return ReferenceUtil.getMethodProtoDescriptor(methodProtoReference);
        }
        return null;
    }

    private ReferenceUtil() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", "reference", "org/jf/dexlib2/util/ReferenceUtil", "getReferenceString"));
    }
}

