/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.util;

import com.google.common.base.Predicate;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.AccessFlags;
import org.jf.dexlib2.iface.Method;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.util.CharSequenceUtils;

public final class MethodUtil {
    private static int directMask = AccessFlags.STATIC.getValue() | AccessFlags.PRIVATE.getValue() | AccessFlags.CONSTRUCTOR.getValue();
    public static Predicate<Method> METHOD_IS_DIRECT = new Predicate<Method>(){

        @Override
        public boolean apply(@Nullable Method input) {
            return input != null && MethodUtil.isDirect(input);
        }
    };
    public static Predicate<Method> METHOD_IS_VIRTUAL = new Predicate<Method>(){

        @Override
        public boolean apply(@Nullable Method input) {
            return input != null && !MethodUtil.isDirect(input);
        }
    };

    public static boolean isDirect(@Nonnull Method method) {
        if (method == null) {
            MethodUtil.$$$reportNull$$$0(0);
        }
        return (method.getAccessFlags() & directMask) != 0;
    }

    public static boolean isStatic(@Nonnull Method method) {
        if (method == null) {
            MethodUtil.$$$reportNull$$$0(1);
        }
        return AccessFlags.STATIC.isSet(method.getAccessFlags());
    }

    public static boolean isConstructor(@Nonnull MethodReference methodReference) {
        if (methodReference == null) {
            MethodUtil.$$$reportNull$$$0(2);
        }
        return methodReference.getName().equals("<init>");
    }

    public static boolean isPackagePrivate(@Nonnull Method method) {
        if (method == null) {
            MethodUtil.$$$reportNull$$$0(3);
        }
        return (method.getAccessFlags() & (AccessFlags.PRIVATE.getValue() | AccessFlags.PROTECTED.getValue() | AccessFlags.PUBLIC.getValue())) == 0;
    }

    public static int getParameterRegisterCount(@Nonnull Method method) {
        if (method == null) {
            MethodUtil.$$$reportNull$$$0(4);
        }
        return MethodUtil.getParameterRegisterCount(method, MethodUtil.isStatic(method));
    }

    public static int getParameterRegisterCount(@Nonnull MethodReference methodRef, boolean isStatic) {
        if (methodRef == null) {
            MethodUtil.$$$reportNull$$$0(5);
        }
        return MethodUtil.getParameterRegisterCount(methodRef.getParameterTypes(), isStatic);
    }

    public static int getParameterRegisterCount(@Nonnull Collection<? extends CharSequence> parameterTypes, boolean isStatic) {
        if (parameterTypes == null) {
            MethodUtil.$$$reportNull$$$0(6);
        }
        int regCount = 0;
        for (CharSequence charSequence : parameterTypes) {
            char firstChar = charSequence.charAt(0);
            if (firstChar == 'J' || firstChar == 'D') {
                regCount += 2;
                continue;
            }
            ++regCount;
        }
        if (!isStatic) {
            ++regCount;
        }
        return regCount;
    }

    private static char getShortyType(CharSequence type) {
        if (type.length() > 1) {
            return 'L';
        }
        return type.charAt(0);
    }

    public static String getShorty(Collection<? extends CharSequence> params, String returnType) {
        StringBuilder sb = new StringBuilder(params.size() + 1);
        sb.append(MethodUtil.getShortyType(returnType));
        for (CharSequence charSequence : params) {
            sb.append(MethodUtil.getShortyType(charSequence));
        }
        return sb.toString();
    }

    public static boolean methodSignaturesMatch(@Nonnull MethodReference a, @Nonnull MethodReference b) {
        if (a == null) {
            MethodUtil.$$$reportNull$$$0(7);
        }
        if (b == null) {
            MethodUtil.$$$reportNull$$$0(8);
        }
        return a.getName().equals(b.getName()) && a.getReturnType().equals(b.getReturnType()) && CharSequenceUtils.listEquals(a.getParameterTypes(), b.getParameterTypes());
    }

    private MethodUtil() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodReference";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodRef";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterTypes";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
        }
        objectArray2[1] = "org/jf/dexlib2/util/MethodUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isDirect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isStatic";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isConstructor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isPackagePrivate";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getParameterRegisterCount";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "methodSignaturesMatch";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

