/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.util;

import com.google.common.io.ByteStreams;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.DexBackedOdexFile;
import org.jf.dexlib2.dexbacked.raw.HeaderItem;
import org.jf.dexlib2.dexbacked.raw.OdexHeaderItem;

public class DexUtil {
    public static void verifyDexHeader(@Nonnull InputStream inputStream) throws IOException {
        if (inputStream == null) {
            DexUtil.$$$reportNull$$$0(0);
        }
        if (!inputStream.markSupported()) {
            throw new IllegalArgumentException("InputStream must support mark");
        }
        inputStream.mark(44);
        byte[] partialHeader = new byte[44];
        try {
            ByteStreams.readFully(inputStream, partialHeader);
        }
        catch (EOFException ex) {
            throw new DexBackedDexFile.NotADexFile("File is too short");
        }
        finally {
            inputStream.reset();
        }
        DexUtil.verifyDexHeader(partialHeader, 0);
    }

    public static void verifyDexHeader(@Nonnull byte[] buf, int offset) {
        int dexVersion;
        if (buf == null) {
            DexUtil.$$$reportNull$$$0(1);
        }
        if ((dexVersion = HeaderItem.getVersion(buf, offset)) == -1) {
            StringBuilder sb = new StringBuilder("Not a valid dex magic value:");
            for (int i = 0; i < 8; ++i) {
                sb.append(String.format(" %02x", buf[i]));
            }
            throw new DexBackedDexFile.NotADexFile(sb.toString());
        }
        if (!HeaderItem.isSupportedDexVersion(dexVersion)) {
            throw new UnsupportedFile(String.format("Dex version %03d is not supported", dexVersion));
        }
        int endian = HeaderItem.getEndian(buf, offset);
        if (endian == 2018915346) {
            throw new UnsupportedFile("Big endian dex files are not supported");
        }
        if (endian != 305419896) {
            throw new InvalidFile(String.format("Invalid endian tag: 0x%x", endian));
        }
    }

    public static void verifyOdexHeader(@Nonnull InputStream inputStream) throws IOException {
        if (inputStream == null) {
            DexUtil.$$$reportNull$$$0(2);
        }
        if (!inputStream.markSupported()) {
            throw new IllegalArgumentException("InputStream must support mark");
        }
        inputStream.mark(8);
        byte[] partialHeader = new byte[8];
        try {
            ByteStreams.readFully(inputStream, partialHeader);
        }
        catch (EOFException ex) {
            throw new DexBackedOdexFile.NotAnOdexFile("File is too short");
        }
        finally {
            inputStream.reset();
        }
        DexUtil.verifyOdexHeader(partialHeader, 0);
    }

    public static void verifyOdexHeader(@Nonnull byte[] buf, int offset) {
        int odexVersion;
        if (buf == null) {
            DexUtil.$$$reportNull$$$0(3);
        }
        if ((odexVersion = OdexHeaderItem.getVersion(buf, offset)) == -1) {
            StringBuilder sb = new StringBuilder("Not a valid odex magic value:");
            for (int i = 0; i < 8; ++i) {
                sb.append(String.format(" %02x", buf[i]));
            }
            throw new DexBackedOdexFile.NotAnOdexFile(sb.toString());
        }
        if (!OdexHeaderItem.isSupportedOdexVersion(odexVersion)) {
            throw new UnsupportedFile(String.format("Odex version %03d is not supported", odexVersion));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buf";
                break;
            }
        }
        objectArray2[1] = "org/jf/dexlib2/util/DexUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "verifyDexHeader";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "verifyOdexHeader";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class UnsupportedFile
    extends RuntimeException {
        public UnsupportedFile() {
        }

        public UnsupportedFile(String message) {
            super(message);
        }

        public UnsupportedFile(String message, Throwable cause) {
            super(message, cause);
        }

        public UnsupportedFile(Throwable cause) {
            super(cause);
        }
    }

    public static class InvalidFile
    extends RuntimeException {
        public InvalidFile() {
        }

        public InvalidFile(String message) {
            super(message);
        }

        public InvalidFile(String message, Throwable cause) {
            super(message, cause);
        }

        public InvalidFile(Throwable cause) {
            super(cause);
        }
    }
}

