/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.jf.dexlib2.dexbacked.DexBackedAnnotation;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.util.FixedSizeList;
import org.jf.dexlib2.dexbacked.util.FixedSizeSet;

public abstract class AnnotationsDirectory {
    public static final AnnotationsDirectory EMPTY = new AnnotationsDirectory(){

        @Override
        public int getFieldAnnotationCount() {
            return 0;
        }

        @Override
        @Nonnull
        public Set<? extends DexBackedAnnotation> getClassAnnotations() {
            ImmutableSet immutableSet = ImmutableSet.of();
            if (immutableSet == null) {
                1.$$$reportNull$$$0(0);
            }
            return immutableSet;
        }

        @Override
        @Nonnull
        public AnnotationIterator getFieldAnnotationIterator() {
            AnnotationIterator annotationIterator = AnnotationIterator.EMPTY;
            if (annotationIterator == null) {
                1.$$$reportNull$$$0(1);
            }
            return annotationIterator;
        }

        @Override
        @Nonnull
        public AnnotationIterator getMethodAnnotationIterator() {
            AnnotationIterator annotationIterator = AnnotationIterator.EMPTY;
            if (annotationIterator == null) {
                1.$$$reportNull$$$0(2);
            }
            return annotationIterator;
        }

        @Override
        @Nonnull
        public AnnotationIterator getParameterAnnotationIterator() {
            AnnotationIterator annotationIterator = AnnotationIterator.EMPTY;
            if (annotationIterator == null) {
                1.$$$reportNull$$$0(3);
            }
            return annotationIterator;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "org/jf/dexlib2/dexbacked/util/AnnotationsDirectory$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getClassAnnotations";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFieldAnnotationIterator";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMethodAnnotationIterator";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParameterAnnotationIterator";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@Nonnull method %s.%s must not return null", objectArray));
        }
    };

    public abstract int getFieldAnnotationCount();

    @Nonnull
    public abstract Set<? extends DexBackedAnnotation> getClassAnnotations();

    @Nonnull
    public abstract AnnotationIterator getFieldAnnotationIterator();

    @Nonnull
    public abstract AnnotationIterator getMethodAnnotationIterator();

    @Nonnull
    public abstract AnnotationIterator getParameterAnnotationIterator();

    @Nonnull
    public static AnnotationsDirectory newOrEmpty(@Nonnull DexBackedDexFile dexFile, int directoryAnnotationsOffset) {
        if (dexFile == null) {
            AnnotationsDirectory.$$$reportNull$$$0(0);
        }
        if (directoryAnnotationsOffset == 0) {
            AnnotationsDirectory annotationsDirectory = EMPTY;
            if (annotationsDirectory == null) {
                AnnotationsDirectory.$$$reportNull$$$0(1);
            }
            return annotationsDirectory;
        }
        AnnotationsDirectoryImpl annotationsDirectoryImpl = new AnnotationsDirectoryImpl(dexFile, directoryAnnotationsOffset);
        if (annotationsDirectoryImpl == null) {
            AnnotationsDirectory.$$$reportNull$$$0(2);
        }
        return annotationsDirectoryImpl;
    }

    @Nonnull
    public static Set<? extends DexBackedAnnotation> getAnnotations(final @Nonnull DexBackedDexFile dexFile, final int annotationSetOffset) {
        if (dexFile == null) {
            AnnotationsDirectory.$$$reportNull$$$0(3);
        }
        if (annotationSetOffset != 0) {
            final int size = dexFile.readSmallUint(annotationSetOffset);
            FixedSizeSet<DexBackedAnnotation> fixedSizeSet = new FixedSizeSet<DexBackedAnnotation>(){

                @Override
                @Nonnull
                public DexBackedAnnotation readItem(int index) {
                    int annotationOffset = dexFile.readSmallUint(annotationSetOffset + 4 + 4 * index);
                    DexBackedAnnotation dexBackedAnnotation = new DexBackedAnnotation(dexFile, annotationOffset);
                    if (dexBackedAnnotation == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return dexBackedAnnotation;
                }

                @Override
                public int size() {
                    return size;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@Nonnull method %s.%s must not return null", "org/jf/dexlib2/dexbacked/util/AnnotationsDirectory$2", "readItem"));
                }
            };
            if (fixedSizeSet == null) {
                AnnotationsDirectory.$$$reportNull$$$0(4);
            }
            return fixedSizeSet;
        }
        ImmutableSet immutableSet = ImmutableSet.of();
        if (immutableSet == null) {
            AnnotationsDirectory.$$$reportNull$$$0(5);
        }
        return immutableSet;
    }

    @Nonnull
    public static List<Set<? extends DexBackedAnnotation>> getParameterAnnotations(final @Nonnull DexBackedDexFile dexFile, final int annotationSetListOffset) {
        if (dexFile == null) {
            AnnotationsDirectory.$$$reportNull$$$0(6);
        }
        if (annotationSetListOffset > 0) {
            final int size = dexFile.readSmallUint(annotationSetListOffset);
            FixedSizeList<Set<? extends DexBackedAnnotation>> fixedSizeList = new FixedSizeList<Set<? extends DexBackedAnnotation>>(){

                @Override
                @Nonnull
                public Set<? extends DexBackedAnnotation> readItem(int index) {
                    int annotationSetOffset = dexFile.readSmallUint(annotationSetListOffset + 4 + index * 4);
                    Set<? extends DexBackedAnnotation> set = AnnotationsDirectory.getAnnotations(dexFile, annotationSetOffset);
                    if (set == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return set;
                }

                @Override
                public int size() {
                    return size;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@Nonnull method %s.%s must not return null", "org/jf/dexlib2/dexbacked/util/AnnotationsDirectory$3", "readItem"));
                }
            };
            if (fixedSizeList == null) {
                AnnotationsDirectory.$$$reportNull$$$0(7);
            }
            return fixedSizeList;
        }
        ImmutableList<Set<? extends DexBackedAnnotation>> immutableList = ImmutableList.of();
        if (immutableList == null) {
            AnnotationsDirectory.$$$reportNull$$$0(8);
        }
        return immutableList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dexFile";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jf/dexlib2/dexbacked/util/AnnotationsDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jf/dexlib2/dexbacked/util/AnnotationsDirectory";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "newOrEmpty";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotations";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "newOrEmpty";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotations";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getParameterAnnotations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AnnotationsDirectoryImpl
    extends AnnotationsDirectory {
        @Nonnull
        public final DexBackedDexFile dexFile;
        private final int directoryOffset;
        private static final int FIELD_COUNT_OFFSET = 4;
        private static final int METHOD_COUNT_OFFSET = 8;
        private static final int PARAMETER_COUNT_OFFSET = 12;
        private static final int ANNOTATIONS_START_OFFSET = 16;
        private static final int FIELD_ANNOTATION_SIZE = 8;
        private static final int METHOD_ANNOTATION_SIZE = 8;

        public AnnotationsDirectoryImpl(@Nonnull DexBackedDexFile dexFile, int directoryOffset) {
            if (dexFile == null) {
                AnnotationsDirectoryImpl.$$$reportNull$$$0(0);
            }
            this.dexFile = dexFile;
            this.directoryOffset = directoryOffset;
        }

        @Override
        public int getFieldAnnotationCount() {
            return this.dexFile.readSmallUint(this.directoryOffset + 4);
        }

        public int getMethodAnnotationCount() {
            return this.dexFile.readSmallUint(this.directoryOffset + 8);
        }

        public int getParameterAnnotationCount() {
            return this.dexFile.readSmallUint(this.directoryOffset + 12);
        }

        @Override
        @Nonnull
        public Set<? extends DexBackedAnnotation> getClassAnnotations() {
            Set<? extends DexBackedAnnotation> set = AnnotationsDirectoryImpl.getAnnotations(this.dexFile, this.dexFile.readSmallUint(this.directoryOffset));
            if (set == null) {
                AnnotationsDirectoryImpl.$$$reportNull$$$0(1);
            }
            return set;
        }

        @Override
        @Nonnull
        public AnnotationIterator getFieldAnnotationIterator() {
            int fieldAnnotationCount = this.getFieldAnnotationCount();
            if (fieldAnnotationCount == 0) {
                AnnotationIterator annotationIterator = AnnotationIterator.EMPTY;
                if (annotationIterator == null) {
                    AnnotationsDirectoryImpl.$$$reportNull$$$0(2);
                }
                return annotationIterator;
            }
            AnnotationIteratorImpl annotationIteratorImpl = new AnnotationIteratorImpl(this.directoryOffset + 16, fieldAnnotationCount);
            if (annotationIteratorImpl == null) {
                AnnotationsDirectoryImpl.$$$reportNull$$$0(3);
            }
            return annotationIteratorImpl;
        }

        @Override
        @Nonnull
        public AnnotationIterator getMethodAnnotationIterator() {
            int methodCount = this.getMethodAnnotationCount();
            if (methodCount == 0) {
                AnnotationIterator annotationIterator = AnnotationIterator.EMPTY;
                if (annotationIterator == null) {
                    AnnotationsDirectoryImpl.$$$reportNull$$$0(4);
                }
                return annotationIterator;
            }
            int fieldCount = this.getFieldAnnotationCount();
            int methodAnnotationsOffset = this.directoryOffset + 16 + fieldCount * 8;
            AnnotationIteratorImpl annotationIteratorImpl = new AnnotationIteratorImpl(methodAnnotationsOffset, methodCount);
            if (annotationIteratorImpl == null) {
                AnnotationsDirectoryImpl.$$$reportNull$$$0(5);
            }
            return annotationIteratorImpl;
        }

        @Override
        @Nonnull
        public AnnotationIterator getParameterAnnotationIterator() {
            int parameterAnnotationCount = this.getParameterAnnotationCount();
            if (parameterAnnotationCount == 0) {
                AnnotationIterator annotationIterator = AnnotationIterator.EMPTY;
                if (annotationIterator == null) {
                    AnnotationsDirectoryImpl.$$$reportNull$$$0(6);
                }
                return annotationIterator;
            }
            int fieldCount = this.getFieldAnnotationCount();
            int methodCount = this.getMethodAnnotationCount();
            int parameterAnnotationsOffset = this.directoryOffset + 16 + fieldCount * 8 + methodCount * 8;
            AnnotationIteratorImpl annotationIteratorImpl = new AnnotationIteratorImpl(parameterAnnotationsOffset, parameterAnnotationCount);
            if (annotationIteratorImpl == null) {
                AnnotationsDirectoryImpl.$$$reportNull$$$0(7);
            }
            return annotationIteratorImpl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@Nonnull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dexFile";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jf/dexlib2/dexbacked/util/AnnotationsDirectory$AnnotationsDirectoryImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jf/dexlib2/dexbacked/util/AnnotationsDirectory$AnnotationsDirectoryImpl";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getClassAnnotations";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFieldAnnotationIterator";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMethodAnnotationIterator";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParameterAnnotationIterator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private class AnnotationIteratorImpl
        implements AnnotationIterator {
            private final int startOffset;
            private final int size;
            private int currentIndex;
            private int currentItemIndex;

            public AnnotationIteratorImpl(int startOffset, int size) {
                this.startOffset = startOffset;
                this.size = size;
                this.currentItemIndex = AnnotationsDirectoryImpl.this.dexFile.readSmallUint(startOffset);
                this.currentIndex = 0;
            }

            @Override
            public int seekTo(int itemIndex) {
                while (this.currentItemIndex < itemIndex && this.currentIndex + 1 < this.size) {
                    ++this.currentIndex;
                    this.currentItemIndex = AnnotationsDirectoryImpl.this.dexFile.readSmallUint(this.startOffset + this.currentIndex * 8);
                }
                if (this.currentItemIndex == itemIndex) {
                    return AnnotationsDirectoryImpl.this.dexFile.readSmallUint(this.startOffset + this.currentIndex * 8 + 4);
                }
                return 0;
            }

            @Override
            public void reset() {
                this.currentItemIndex = AnnotationsDirectoryImpl.this.dexFile.readSmallUint(this.startOffset);
                this.currentIndex = 0;
            }
        }
    }

    public static interface AnnotationIterator {
        public static final AnnotationIterator EMPTY = new AnnotationIterator(){

            @Override
            public int seekTo(int key) {
                return 0;
            }

            @Override
            public void reset() {
            }
        };

        public int seekTo(int var1);

        public void reset();
    }
}

