/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked.raw;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.raw.MapItem;
import org.jf.dexlib2.dexbacked.raw.RawDexFile;
import org.jf.dexlib2.dexbacked.raw.SectionAnnotator;
import org.jf.dexlib2.dexbacked.raw.util.DexAnnotator;
import org.jf.dexlib2.util.AnnotatedBytes;
import org.jf.util.StringUtils;

public class StringIdItem {
    public static final int ITEM_SIZE = 4;

    @Nonnull
    public static SectionAnnotator makeAnnotator(@Nonnull DexAnnotator annotator, @Nonnull MapItem mapItem) {
        if (annotator == null) {
            StringIdItem.$$$reportNull$$$0(0);
        }
        if (mapItem == null) {
            StringIdItem.$$$reportNull$$$0(1);
        }
        SectionAnnotator sectionAnnotator = new SectionAnnotator(annotator, mapItem){

            @Override
            @Nonnull
            public String getItemName() {
                if ("string_id_item" == null) {
                    1.$$$reportNull$$$0(0);
                }
                return "string_id_item";
            }

            @Override
            public void annotateItem(@Nonnull AnnotatedBytes out, int itemIndex, @Nullable String itemIdentity) {
                if (out == null) {
                    1.$$$reportNull$$$0(1);
                }
                int stringDataOffset = this.dexFile.readSmallUint(out.getCursor());
                try {
                    String stringValue = this.dexFile.getString(itemIndex);
                    out.annotate(4, "string_data_item[0x%x]: \"%s\"", stringDataOffset, StringUtils.escapeString(stringValue));
                    return;
                }
                catch (Exception ex) {
                    System.err.print("Error while resolving string value at index: ");
                    System.err.print(itemIndex);
                    ex.printStackTrace(System.err);
                    out.annotate(4, "string_id_item[0x%x]", stringDataOffset);
                    return;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@Nonnull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jf/dexlib2/dexbacked/raw/StringIdItem$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getItemName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jf/dexlib2/dexbacked/raw/StringIdItem$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "annotateItem";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (sectionAnnotator == null) {
            StringIdItem.$$$reportNull$$$0(2);
        }
        return sectionAnnotator;
    }

    @Nonnull
    public static String getReferenceAnnotation(@Nonnull DexBackedDexFile dexFile, int stringIndex) {
        if (dexFile == null) {
            StringIdItem.$$$reportNull$$$0(3);
        }
        String string = StringIdItem.getReferenceAnnotation(dexFile, stringIndex, false);
        if (string == null) {
            StringIdItem.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static String getReferenceAnnotation(@Nonnull DexBackedDexFile dexFile, int stringIndex, boolean quote) {
        if (dexFile == null) {
            StringIdItem.$$$reportNull$$$0(5);
        }
        try {
            String string = dexFile.getString(stringIndex);
            if (quote) {
                string = String.format("\"%s\"", StringUtils.escapeString(string));
            }
            return String.format("string_id_item[%d]: %s", stringIndex, string);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            return String.format("string_id_item[%d]", stringIndex);
        }
    }

    @Nonnull
    public static String getOptionalReferenceAnnotation(@Nonnull DexBackedDexFile dexFile, int stringIndex) {
        if (dexFile == null) {
            StringIdItem.$$$reportNull$$$0(6);
        }
        String string = StringIdItem.getOptionalReferenceAnnotation(dexFile, stringIndex, false);
        if (string == null) {
            StringIdItem.$$$reportNull$$$0(7);
        }
        return string;
    }

    public static String getOptionalReferenceAnnotation(@Nonnull DexBackedDexFile dexFile, int stringIndex, boolean quote) {
        if (dexFile == null) {
            StringIdItem.$$$reportNull$$$0(8);
        }
        if (stringIndex == -1) {
            return "string_id_item[NO_INDEX]";
        }
        return StringIdItem.getReferenceAnnotation(dexFile, stringIndex, quote);
    }

    public static String[] getStrings(@Nonnull RawDexFile dexFile) {
        MapItem mapItem;
        if (dexFile == null) {
            StringIdItem.$$$reportNull$$$0(9);
        }
        if ((mapItem = dexFile.getMapItemForSection(1)) == null) {
            return new String[0];
        }
        int stringCount = mapItem.getItemCount();
        String[] ret = new String[stringCount];
        for (int i = 0; i < stringCount; ++i) {
            ret[i] = dexFile.getString(i);
        }
        return ret;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapItem";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jf/dexlib2/dexbacked/raw/StringIdItem";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dexFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jf/dexlib2/dexbacked/raw/StringIdItem";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "makeAnnotator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceAnnotation";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionalReferenceAnnotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "makeAnnotator";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceAnnotation";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getOptionalReferenceAnnotation";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getStrings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

