/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked.raw;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.dexbacked.raw.MapItem;
import org.jf.dexlib2.dexbacked.raw.RawDexFile;
import org.jf.dexlib2.dexbacked.raw.util.DexAnnotator;
import org.jf.dexlib2.util.AnnotatedBytes;
import org.jf.util.AlignmentUtils;

public abstract class SectionAnnotator {
    @Nonnull
    public final DexAnnotator annotator;
    @Nonnull
    public final RawDexFile dexFile;
    public final int itemType;
    public final int sectionOffset;
    public final int itemCount;
    private Map<Integer, String> itemIdentities;

    public SectionAnnotator(@Nonnull DexAnnotator annotator, @Nonnull MapItem mapItem) {
        if (annotator == null) {
            SectionAnnotator.$$$reportNull$$$0(0);
        }
        if (mapItem == null) {
            SectionAnnotator.$$$reportNull$$$0(1);
        }
        this.itemIdentities = Maps.newHashMap();
        this.annotator = annotator;
        this.dexFile = annotator.dexFile;
        this.itemType = mapItem.getType();
        this.sectionOffset = mapItem.getOffset();
        this.itemCount = mapItem.getItemCount();
    }

    @Nonnull
    public abstract String getItemName();

    protected abstract void annotateItem(@Nonnull AnnotatedBytes var1, int var2, @Nullable String var3);

    public void annotateSection(@Nonnull AnnotatedBytes out) {
        if (out == null) {
            SectionAnnotator.$$$reportNull$$$0(2);
        }
        out.moveTo(this.sectionOffset);
        this.annotateSectionInner(out, this.itemCount);
    }

    protected void annotateSectionInner(@Nonnull AnnotatedBytes out, int itemCount) {
        if (out == null) {
            SectionAnnotator.$$$reportNull$$$0(3);
        }
        String itemName = this.getItemName();
        int itemAlignment = this.getItemAlignment();
        if (itemCount > 0) {
            out.annotate(0, "", new Object[0]);
            out.annotate(0, "-----------------------------", new Object[0]);
            out.annotate(0, "%s section", itemName);
            out.annotate(0, "-----------------------------", new Object[0]);
            out.annotate(0, "", new Object[0]);
            for (int i = 0; i < itemCount; ++i) {
                out.moveTo(AlignmentUtils.alignOffset(out.getCursor(), itemAlignment));
                String itemIdentity = this.getItemIdentity(out.getCursor());
                if (itemIdentity != null) {
                    out.annotate(0, "[%d] %s: %s", i, itemName, itemIdentity);
                } else {
                    out.annotate(0, "[%d] %s", i, itemName);
                }
                out.indent();
                this.annotateItem(out, i, itemIdentity);
                out.deindent();
            }
        }
    }

    @Nullable
    private String getItemIdentity(int itemOffset) {
        return this.itemIdentities.get(itemOffset);
    }

    public void setItemIdentity(int itemOffset, String identity) {
        this.itemIdentities.put(itemOffset, identity);
    }

    public int getItemAlignment() {
        return 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapItem";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
        }
        objectArray2[1] = "org/jf/dexlib2/dexbacked/raw/SectionAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "annotateSection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "annotateSectionInner";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

