/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked.raw;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.raw.MapItem;
import org.jf.dexlib2.dexbacked.raw.RawDexFile;
import org.jf.dexlib2.dexbacked.raw.SectionAnnotator;
import org.jf.dexlib2.dexbacked.raw.StringIdItem;
import org.jf.dexlib2.dexbacked.raw.TypeIdItem;
import org.jf.dexlib2.dexbacked.raw.TypeListItem;
import org.jf.dexlib2.dexbacked.raw.util.DexAnnotator;
import org.jf.dexlib2.util.AnnotatedBytes;

public class ProtoIdItem {
    public static final int ITEM_SIZE = 12;
    public static final int SHORTY_OFFSET = 0;
    public static final int RETURN_TYPE_OFFSET = 4;
    public static final int PARAMETERS_OFFSET = 8;

    @Nonnull
    public static SectionAnnotator makeAnnotator(@Nonnull DexAnnotator annotator, @Nonnull MapItem mapItem) {
        if (annotator == null) {
            ProtoIdItem.$$$reportNull$$$0(0);
        }
        if (mapItem == null) {
            ProtoIdItem.$$$reportNull$$$0(1);
        }
        SectionAnnotator sectionAnnotator = new SectionAnnotator(annotator, mapItem){

            @Override
            @Nonnull
            public String getItemName() {
                if ("proto_id_item" == null) {
                    1.$$$reportNull$$$0(0);
                }
                return "proto_id_item";
            }

            @Override
            protected void annotateItem(@Nonnull AnnotatedBytes out, int itemIndex, @Nullable String itemIdentity) {
                if (out == null) {
                    1.$$$reportNull$$$0(1);
                }
                int shortyIndex = this.dexFile.readSmallUint(out.getCursor());
                out.annotate(4, "shorty_idx = %s", StringIdItem.getReferenceAnnotation(this.dexFile, shortyIndex));
                int returnTypeIndex = this.dexFile.readSmallUint(out.getCursor());
                out.annotate(4, "return_type_idx = %s", TypeIdItem.getReferenceAnnotation(this.dexFile, returnTypeIndex));
                int parametersOffset = this.dexFile.readSmallUint(out.getCursor());
                out.annotate(4, "parameters_off = %s", TypeListItem.getReferenceAnnotation(this.dexFile, parametersOffset));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@Nonnull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jf/dexlib2/dexbacked/raw/ProtoIdItem$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getItemName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jf/dexlib2/dexbacked/raw/ProtoIdItem$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "annotateItem";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (sectionAnnotator == null) {
            ProtoIdItem.$$$reportNull$$$0(2);
        }
        return sectionAnnotator;
    }

    @Nonnull
    public static String getReferenceAnnotation(@Nonnull DexBackedDexFile dexFile, int protoIndex) {
        String string;
        if (dexFile == null) {
            ProtoIdItem.$$$reportNull$$$0(3);
        }
        try {
            String protoString = ProtoIdItem.asString(dexFile, protoIndex);
            string = String.format("proto_id_item[%d]: %s", protoIndex, protoString);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            String string2 = String.format("proto_id_item[%d]", protoIndex);
            if (string2 == null) {
                ProtoIdItem.$$$reportNull$$$0(5);
            }
            return string2;
        }
        if (string == null) {
            ProtoIdItem.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nonnull
    public static String asString(@Nonnull DexBackedDexFile dexFile, int protoIndex) {
        if (dexFile == null) {
            ProtoIdItem.$$$reportNull$$$0(6);
        }
        int offset = dexFile.getProtoIdItemOffset(protoIndex);
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        int parametersOffset = dexFile.readSmallUint(offset + 8);
        sb.append(TypeListItem.asString(dexFile, parametersOffset));
        sb.append(")");
        int returnTypeIndex = dexFile.readSmallUint(offset + 4);
        String returnType = dexFile.getType(returnTypeIndex);
        sb.append(returnType);
        String string = sb.toString();
        if (string == null) {
            ProtoIdItem.$$$reportNull$$$0(7);
        }
        return string;
    }

    public static String[] getProtos(@Nonnull RawDexFile dexFile) {
        MapItem mapItem;
        if (dexFile == null) {
            ProtoIdItem.$$$reportNull$$$0(8);
        }
        if ((mapItem = dexFile.getMapItemForSection(3)) == null) {
            return new String[0];
        }
        int protoCount = mapItem.getItemCount();
        String[] ret = new String[protoCount];
        for (int i = 0; i < protoCount; ++i) {
            ret[i] = ProtoIdItem.asString(dexFile, i);
        }
        return ret;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapItem";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jf/dexlib2/dexbacked/raw/ProtoIdItem";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dexFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jf/dexlib2/dexbacked/raw/ProtoIdItem";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "makeAnnotator";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceAnnotation";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "asString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "makeAnnotator";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceAnnotation";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "asString";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getProtos";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

