/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked.raw;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.raw.MapItem;
import org.jf.dexlib2.dexbacked.raw.ProtoIdItem;
import org.jf.dexlib2.dexbacked.raw.RawDexFile;
import org.jf.dexlib2.dexbacked.raw.SectionAnnotator;
import org.jf.dexlib2.dexbacked.raw.StringIdItem;
import org.jf.dexlib2.dexbacked.raw.TypeIdItem;
import org.jf.dexlib2.dexbacked.raw.util.DexAnnotator;
import org.jf.dexlib2.util.AnnotatedBytes;

public class MethodIdItem {
    public static final int ITEM_SIZE = 8;
    public static final int CLASS_OFFSET = 0;
    public static final int PROTO_OFFSET = 2;
    public static final int NAME_OFFSET = 4;

    @Nonnull
    public static SectionAnnotator makeAnnotator(@Nonnull DexAnnotator annotator, @Nonnull MapItem mapItem) {
        if (annotator == null) {
            MethodIdItem.$$$reportNull$$$0(0);
        }
        if (mapItem == null) {
            MethodIdItem.$$$reportNull$$$0(1);
        }
        SectionAnnotator sectionAnnotator = new SectionAnnotator(annotator, mapItem){

            @Override
            @Nonnull
            public String getItemName() {
                if ("method_id_item" == null) {
                    1.$$$reportNull$$$0(0);
                }
                return "method_id_item";
            }

            @Override
            public void annotateItem(@Nonnull AnnotatedBytes out, int itemIndex, @Nullable String itemIdentity) {
                if (out == null) {
                    1.$$$reportNull$$$0(1);
                }
                int classIndex = this.dexFile.readUshort(out.getCursor());
                out.annotate(2, "class_idx = %s", TypeIdItem.getReferenceAnnotation(this.dexFile, classIndex));
                int protoIndex = this.dexFile.readUshort(out.getCursor());
                out.annotate(2, "proto_idx = %s", ProtoIdItem.getReferenceAnnotation(this.dexFile, protoIndex));
                int nameIndex = this.dexFile.readSmallUint(out.getCursor());
                out.annotate(4, "name_idx = %s", StringIdItem.getReferenceAnnotation(this.dexFile, nameIndex));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@Nonnull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jf/dexlib2/dexbacked/raw/MethodIdItem$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getItemName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jf/dexlib2/dexbacked/raw/MethodIdItem$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "annotateItem";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (sectionAnnotator == null) {
            MethodIdItem.$$$reportNull$$$0(2);
        }
        return sectionAnnotator;
    }

    @Nonnull
    public static String asString(@Nonnull DexBackedDexFile dexFile, int methodIndex) {
        if (dexFile == null) {
            MethodIdItem.$$$reportNull$$$0(3);
        }
        int methodOffset = dexFile.getMethodIdItemOffset(methodIndex);
        int classIndex = dexFile.readUshort(methodOffset + 0);
        String classType = dexFile.getType(classIndex);
        int protoIndex = dexFile.readUshort(methodOffset + 2);
        String protoString = ProtoIdItem.asString(dexFile, protoIndex);
        int nameIndex = dexFile.readSmallUint(methodOffset + 4);
        String methodName = dexFile.getString(nameIndex);
        String string = String.format("%s->%s%s", classType, methodName, protoString);
        if (string == null) {
            MethodIdItem.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nonnull
    public static String getReferenceAnnotation(@Nonnull DexBackedDexFile dexFile, int methodIndex) {
        String string;
        if (dexFile == null) {
            MethodIdItem.$$$reportNull$$$0(5);
        }
        try {
            String methodString = MethodIdItem.asString(dexFile, methodIndex);
            string = String.format("method_id_item[%d]: %s", methodIndex, methodString);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            String string2 = String.format("method_id_item[%d]", methodIndex);
            if (string2 == null) {
                MethodIdItem.$$$reportNull$$$0(7);
            }
            return string2;
        }
        if (string == null) {
            MethodIdItem.$$$reportNull$$$0(6);
        }
        return string;
    }

    public static String[] getMethods(@Nonnull RawDexFile dexFile) {
        MapItem mapItem;
        if (dexFile == null) {
            MethodIdItem.$$$reportNull$$$0(8);
        }
        if ((mapItem = dexFile.getMapItemForSection(5)) == null) {
            return new String[0];
        }
        int methodCount = mapItem.getItemCount();
        String[] ret = new String[methodCount];
        for (int i = 0; i < methodCount; ++i) {
            ret[i] = MethodIdItem.asString(dexFile, i);
        }
        return ret;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapItem";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jf/dexlib2/dexbacked/raw/MethodIdItem";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dexFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jf/dexlib2/dexbacked/raw/MethodIdItem";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "makeAnnotator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "asString";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceAnnotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "makeAnnotator";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "asString";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceAnnotation";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getMethods";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

