/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked.raw;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.raw.ItemType;
import org.jf.dexlib2.dexbacked.raw.SectionAnnotator;
import org.jf.dexlib2.dexbacked.raw.util.DexAnnotator;
import org.jf.dexlib2.util.AnnotatedBytes;

public class MapItem {
    public static final int ITEM_SIZE = 12;
    public static final int TYPE_OFFSET = 0;
    public static final int SIZE_OFFSET = 4;
    public static final int OFFSET_OFFSET = 8;
    private final DexBackedDexFile dexFile;
    private final int offset;

    public MapItem(DexBackedDexFile dexFile, int offset) {
        this.dexFile = dexFile;
        this.offset = offset;
    }

    public int getType() {
        return this.dexFile.readUshort(this.offset + 0);
    }

    @Nonnull
    public String getName() {
        String string = ItemType.getItemTypeName(this.getType());
        if (string == null) {
            MapItem.$$$reportNull$$$0(0);
        }
        return string;
    }

    public int getItemCount() {
        return this.dexFile.readSmallUint(this.offset + 4);
    }

    public int getOffset() {
        return this.dexFile.readSmallUint(this.offset + 8);
    }

    @Nonnull
    public static SectionAnnotator makeAnnotator(@Nonnull DexAnnotator annotator, @Nonnull MapItem mapItem) {
        if (annotator == null) {
            MapItem.$$$reportNull$$$0(1);
        }
        if (mapItem == null) {
            MapItem.$$$reportNull$$$0(2);
        }
        SectionAnnotator sectionAnnotator = new SectionAnnotator(annotator, mapItem){

            @Override
            @Nonnull
            public String getItemName() {
                if ("map_item" == null) {
                    1.$$$reportNull$$$0(0);
                }
                return "map_item";
            }

            @Override
            protected void annotateItem(@Nonnull AnnotatedBytes out, int itemIndex, @Nullable String itemIdentity) {
                if (out == null) {
                    1.$$$reportNull$$$0(1);
                }
                int itemType = this.dexFile.readUshort(out.getCursor());
                out.annotate(2, "type = 0x%x: %s", itemType, ItemType.getItemTypeName(itemType));
                out.annotate(2, "unused", new Object[0]);
                int size = this.dexFile.readSmallUint(out.getCursor());
                out.annotate(4, "size = %d", size);
                int offset = this.dexFile.readSmallUint(out.getCursor());
                out.annotate(4, "offset = 0x%x", offset);
            }

            @Override
            public void annotateSection(@Nonnull AnnotatedBytes out) {
                if (out == null) {
                    1.$$$reportNull$$$0(2);
                }
                out.moveTo(this.sectionOffset);
                int mapItemCount = this.dexFile.readSmallUint(out.getCursor());
                out.annotate(4, "size = %d", mapItemCount);
                super.annotateSectionInner(out, mapItemCount);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@Nonnull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jf/dexlib2/dexbacked/raw/MapItem$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getItemName";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jf/dexlib2/dexbacked/raw/MapItem$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "annotateItem";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "annotateSection";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (sectionAnnotator == null) {
            MapItem.$$$reportNull$$$0(3);
        }
        return sectionAnnotator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jf/dexlib2/dexbacked/raw/MapItem";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapItem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jf/dexlib2/dexbacked/raw/MapItem";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "makeAnnotator";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "makeAnnotator";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

