/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked.raw;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.dexbacked.DexReader;
import org.jf.dexlib2.dexbacked.raw.MapItem;
import org.jf.dexlib2.dexbacked.raw.SectionAnnotator;
import org.jf.dexlib2.dexbacked.raw.StringIdItem;
import org.jf.dexlib2.dexbacked.raw.TypeIdItem;
import org.jf.dexlib2.dexbacked.raw.util.DexAnnotator;
import org.jf.dexlib2.util.AnnotatedBytes;

public class DebugInfoItem {
    @Nonnull
    public static SectionAnnotator makeAnnotator(@Nonnull DexAnnotator annotator, @Nonnull MapItem mapItem) {
        if (annotator == null) {
            DebugInfoItem.$$$reportNull$$$0(0);
        }
        if (mapItem == null) {
            DebugInfoItem.$$$reportNull$$$0(1);
        }
        SectionAnnotator sectionAnnotator = new SectionAnnotator(annotator, mapItem){

            @Override
            @Nonnull
            public String getItemName() {
                if ("debug_info_item" == null) {
                    1.$$$reportNull$$$0(0);
                }
                return "debug_info_item";
            }

            @Override
            public void annotateItem(@Nonnull AnnotatedBytes out, int itemIndex, @Nullable String itemIdentity) {
                if (out == null) {
                    1.$$$reportNull$$$0(1);
                }
                DexReader reader = this.dexFile.readerAt(out.getCursor());
                int lineStart = reader.readSmallUleb128();
                out.annotateTo(reader.getOffset(), "line_start = %d", lineStart);
                int parametersSize = reader.readSmallUleb128();
                out.annotateTo(reader.getOffset(), "parameters_size = %d", parametersSize);
                if (parametersSize > 0) {
                    out.annotate(0, "parameters:", new Object[0]);
                    out.indent();
                    for (int i = 0; i < parametersSize; ++i) {
                        int paramaterIndex = reader.readSmallUleb128() - 1;
                        out.annotateTo(reader.getOffset(), "%s", StringIdItem.getOptionalReferenceAnnotation(this.dexFile, paramaterIndex, true));
                    }
                    out.deindent();
                }
                out.annotate(0, "debug opcodes:", new Object[0]);
                out.indent();
                int codeAddress = 0;
                int lineNumber = lineStart;
                block13: while (true) {
                    int opcode = reader.readUbyte();
                    switch (opcode) {
                        case 0: {
                            out.annotateTo(reader.getOffset(), "DBG_END_SEQUENCE", new Object[0]);
                            break block13;
                        }
                        case 1: {
                            out.annotateTo(reader.getOffset(), "DBG_ADVANCE_PC", new Object[0]);
                            out.indent();
                            int addressDiff = reader.readSmallUleb128();
                            out.annotateTo(reader.getOffset(), "addr_diff = +0x%x: 0x%x", addressDiff, codeAddress += addressDiff);
                            out.deindent();
                            continue block13;
                        }
                        case 2: {
                            out.annotateTo(reader.getOffset(), "DBG_ADVANCE_LINE", new Object[0]);
                            out.indent();
                            int lineDiff = reader.readSleb128();
                            out.annotateTo(reader.getOffset(), "line_diff = +%d: %d", Math.abs(lineDiff), lineNumber += lineDiff);
                            out.deindent();
                            continue block13;
                        }
                        case 3: {
                            out.annotateTo(reader.getOffset(), "DBG_START_LOCAL", new Object[0]);
                            out.indent();
                            int registerNum = reader.readSmallUleb128();
                            out.annotateTo(reader.getOffset(), "register_num = v%d", registerNum);
                            int nameIndex = reader.readSmallUleb128() - 1;
                            out.annotateTo(reader.getOffset(), "name_idx = %s", StringIdItem.getOptionalReferenceAnnotation(this.dexFile, nameIndex, true));
                            int typeIndex = reader.readSmallUleb128() - 1;
                            out.annotateTo(reader.getOffset(), "type_idx = %s", TypeIdItem.getOptionalReferenceAnnotation(this.dexFile, typeIndex));
                            out.deindent();
                            continue block13;
                        }
                        case 4: {
                            out.annotateTo(reader.getOffset(), "DBG_START_LOCAL_EXTENDED", new Object[0]);
                            out.indent();
                            int registerNum = reader.readSmallUleb128();
                            out.annotateTo(reader.getOffset(), "register_num = v%d", registerNum);
                            int nameIndex = reader.readSmallUleb128() - 1;
                            out.annotateTo(reader.getOffset(), "name_idx = %s", StringIdItem.getOptionalReferenceAnnotation(this.dexFile, nameIndex, true));
                            int typeIndex = reader.readSmallUleb128() - 1;
                            out.annotateTo(reader.getOffset(), "type_idx = %s", TypeIdItem.getOptionalReferenceAnnotation(this.dexFile, typeIndex));
                            int sigIndex = reader.readSmallUleb128() - 1;
                            out.annotateTo(reader.getOffset(), "sig_idx = %s", StringIdItem.getOptionalReferenceAnnotation(this.dexFile, sigIndex, true));
                            out.deindent();
                            continue block13;
                        }
                        case 5: {
                            out.annotateTo(reader.getOffset(), "DBG_END_LOCAL", new Object[0]);
                            out.indent();
                            int registerNum = reader.readSmallUleb128();
                            out.annotateTo(reader.getOffset(), "register_num = v%d", registerNum);
                            out.deindent();
                            continue block13;
                        }
                        case 6: {
                            out.annotateTo(reader.getOffset(), "DBG_RESTART_LOCAL", new Object[0]);
                            out.indent();
                            int registerNum = reader.readSmallUleb128();
                            out.annotateTo(reader.getOffset(), "register_num = v%d", registerNum);
                            out.deindent();
                            continue block13;
                        }
                        case 7: {
                            out.annotateTo(reader.getOffset(), "DBG_SET_PROLOGUE_END", new Object[0]);
                            continue block13;
                        }
                        case 8: {
                            out.annotateTo(reader.getOffset(), "DBG_SET_EPILOGUE_BEGIN", new Object[0]);
                            continue block13;
                        }
                        case 9: {
                            out.annotateTo(reader.getOffset(), "DBG_SET_FILE", new Object[0]);
                            out.indent();
                            int nameIdx = reader.readSmallUleb128() - 1;
                            out.annotateTo(reader.getOffset(), "name_idx = %s", StringIdItem.getOptionalReferenceAnnotation(this.dexFile, nameIdx));
                            out.deindent();
                            continue block13;
                        }
                        default: {
                            int adjusted = opcode - 10;
                            int addressDiff = adjusted / 15;
                            int lineDiff = adjusted % 15 - 4;
                            out.annotateTo(reader.getOffset(), "address_diff = +0x%x:0x%x, line_diff = +%d:%d, ", addressDiff, codeAddress += addressDiff, lineDiff, lineNumber += lineDiff);
                            continue block13;
                        }
                    }
                    break;
                }
                out.deindent();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@Nonnull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jf/dexlib2/dexbacked/raw/DebugInfoItem$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getItemName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jf/dexlib2/dexbacked/raw/DebugInfoItem$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "annotateItem";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (sectionAnnotator == null) {
            DebugInfoItem.$$$reportNull$$$0(2);
        }
        return sectionAnnotator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapItem";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jf/dexlib2/dexbacked/raw/DebugInfoItem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jf/dexlib2/dexbacked/raw/DebugInfoItem";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "makeAnnotator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "makeAnnotator";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

