/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked.raw;

import com.google.common.base.Joiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.AccessFlags;
import org.jf.dexlib2.dexbacked.DexReader;
import org.jf.dexlib2.dexbacked.raw.FieldIdItem;
import org.jf.dexlib2.dexbacked.raw.MapItem;
import org.jf.dexlib2.dexbacked.raw.MethodIdItem;
import org.jf.dexlib2.dexbacked.raw.RawDexFile;
import org.jf.dexlib2.dexbacked.raw.SectionAnnotator;
import org.jf.dexlib2.dexbacked.raw.util.DexAnnotator;
import org.jf.dexlib2.util.AnnotatedBytes;

public class ClassDataItem {
    @Nonnull
    public static SectionAnnotator makeAnnotator(@Nonnull DexAnnotator annotator, @Nonnull MapItem mapItem) {
        if (annotator == null) {
            ClassDataItem.$$$reportNull$$$0(0);
        }
        if (mapItem == null) {
            ClassDataItem.$$$reportNull$$$0(1);
        }
        SectionAnnotator sectionAnnotator = new SectionAnnotator(annotator, mapItem){
            private SectionAnnotator codeItemAnnotator = null;

            @Override
            public void annotateSection(@Nonnull AnnotatedBytes out) {
                if (out == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.codeItemAnnotator = this.annotator.getAnnotator(8193);
                super.annotateSection(out);
            }

            @Override
            @Nonnull
            public String getItemName() {
                if ("class_data_item" == null) {
                    1.$$$reportNull$$$0(1);
                }
                return "class_data_item";
            }

            @Override
            protected void annotateItem(@Nonnull AnnotatedBytes out, int itemIndex, @Nullable String itemIdentity) {
                int i;
                if (out == null) {
                    1.$$$reportNull$$$0(2);
                }
                DexReader reader = this.dexFile.readerAt(out.getCursor());
                int staticFieldsSize = reader.readSmallUleb128();
                out.annotateTo(reader.getOffset(), "static_fields_size = %d", staticFieldsSize);
                int instanceFieldsSize = reader.readSmallUleb128();
                out.annotateTo(reader.getOffset(), "instance_fields_size = %d", instanceFieldsSize);
                int directMethodsSize = reader.readSmallUleb128();
                out.annotateTo(reader.getOffset(), "direct_methods_size = %d", directMethodsSize);
                int virtualMethodsSize = reader.readSmallUleb128();
                out.annotateTo(reader.getOffset(), "virtual_methods_size = %d", virtualMethodsSize);
                int previousIndex = 0;
                if (staticFieldsSize > 0) {
                    out.annotate(0, "static_fields:", new Object[0]);
                    out.indent();
                    for (i = 0; i < staticFieldsSize; ++i) {
                        out.annotate(0, "static_field[%d]", i);
                        out.indent();
                        previousIndex = this.annotateEncodedField(out, this.dexFile, reader, previousIndex);
                        out.deindent();
                    }
                    out.deindent();
                }
                if (instanceFieldsSize > 0) {
                    out.annotate(0, "instance_fields:", new Object[0]);
                    out.indent();
                    previousIndex = 0;
                    for (i = 0; i < instanceFieldsSize; ++i) {
                        out.annotate(0, "instance_field[%d]", i);
                        out.indent();
                        previousIndex = this.annotateEncodedField(out, this.dexFile, reader, previousIndex);
                        out.deindent();
                    }
                    out.deindent();
                }
                if (directMethodsSize > 0) {
                    out.annotate(0, "direct_methods:", new Object[0]);
                    out.indent();
                    previousIndex = 0;
                    for (i = 0; i < directMethodsSize; ++i) {
                        out.annotate(0, "direct_method[%d]", i);
                        out.indent();
                        previousIndex = this.annotateEncodedMethod(out, this.dexFile, reader, previousIndex);
                        out.deindent();
                    }
                    out.deindent();
                }
                if (virtualMethodsSize > 0) {
                    out.annotate(0, "virtual_methods:", new Object[0]);
                    out.indent();
                    previousIndex = 0;
                    for (i = 0; i < virtualMethodsSize; ++i) {
                        out.annotate(0, "virtual_method[%d]", i);
                        out.indent();
                        previousIndex = this.annotateEncodedMethod(out, this.dexFile, reader, previousIndex);
                        out.deindent();
                    }
                    out.deindent();
                }
            }

            private int annotateEncodedField(@Nonnull AnnotatedBytes out, @Nonnull RawDexFile dexFile, @Nonnull DexReader reader, int previousIndex) {
                if (out == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (dexFile == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (reader == null) {
                    1.$$$reportNull$$$0(5);
                }
                int indexDelta = reader.readLargeUleb128();
                int fieldIndex = previousIndex + indexDelta;
                out.annotateTo(reader.getOffset(), "field_idx_diff = %d: %s", indexDelta, FieldIdItem.getReferenceAnnotation(dexFile, fieldIndex));
                int accessFlags = reader.readSmallUleb128();
                out.annotateTo(reader.getOffset(), "access_flags = 0x%x: %s", accessFlags, Joiner.on('|').join((Object[])AccessFlags.getAccessFlagsForField(accessFlags)));
                return fieldIndex;
            }

            private int annotateEncodedMethod(@Nonnull AnnotatedBytes out, @Nonnull RawDexFile dexFile, @Nonnull DexReader reader, int previousIndex) {
                if (out == null) {
                    1.$$$reportNull$$$0(6);
                }
                if (dexFile == null) {
                    1.$$$reportNull$$$0(7);
                }
                if (reader == null) {
                    1.$$$reportNull$$$0(8);
                }
                int indexDelta = reader.readLargeUleb128();
                int methodIndex = previousIndex + indexDelta;
                out.annotateTo(reader.getOffset(), "method_idx_diff = %d: %s", indexDelta, MethodIdItem.getReferenceAnnotation(dexFile, methodIndex));
                int accessFlags = reader.readSmallUleb128();
                out.annotateTo(reader.getOffset(), "access_flags = 0x%x: %s", accessFlags, Joiner.on('|').join((Object[])AccessFlags.getAccessFlagsForMethod(accessFlags)));
                int codeOffset = reader.readSmallUleb128();
                if (codeOffset == 0) {
                    out.annotateTo(reader.getOffset(), "code_off = code_item[NO_OFFSET]", new Object[0]);
                } else {
                    out.annotateTo(reader.getOffset(), "code_off = code_item[0x%x]", codeOffset);
                    this.addCodeItemIdentity(codeOffset, MethodIdItem.asString(dexFile, methodIndex));
                }
                return methodIndex;
            }

            private void addCodeItemIdentity(int codeItemOffset, String methodString) {
                if (this.codeItemAnnotator != null) {
                    this.codeItemAnnotator.setItemIdentity(codeItemOffset, methodString);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@Nonnull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jf/dexlib2/dexbacked/raw/ClassDataItem$1";
                        break;
                    }
                    case 4: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dexFile";
                        break;
                    }
                    case 5: 
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "reader";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jf/dexlib2/dexbacked/raw/ClassDataItem$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getItemName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "annotateSection";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "annotateItem";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "annotateEncodedField";
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        objectArray = objectArray;
                        objectArray[2] = "annotateEncodedMethod";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (sectionAnnotator == null) {
            ClassDataItem.$$$reportNull$$$0(2);
        }
        return sectionAnnotator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapItem";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jf/dexlib2/dexbacked/raw/ClassDataItem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jf/dexlib2/dexbacked/raw/ClassDataItem";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "makeAnnotator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "makeAnnotator";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

