/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked.instruction;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.DexReader;
import org.jf.dexlib2.dexbacked.instruction.DexBackedArrayPayload;
import org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction10t;
import org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction10x;
import org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction11n;
import org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction11x;
import org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction12x;
import org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction20bc;
import org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction20t;
import org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction21c;
import org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction21ih;
import org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction21lh;
import org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction21s;
import org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction21t;
import org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction22b;
import org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction22c;
import org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction22cs;
import org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction22s;
import org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction22t;
import org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction22x;
import org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction23x;
import org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction30t;
import org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction31c;
import org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction31i;
import org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction31t;
import org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction32x;
import org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction35c;
import org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction35mi;
import org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction35ms;
import org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction3rc;
import org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction3rmi;
import org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction3rms;
import org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction45cc;
import org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction4rcc;
import org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction51l;
import org.jf.dexlib2.dexbacked.instruction.DexBackedPackedSwitchPayload;
import org.jf.dexlib2.dexbacked.instruction.DexBackedSparseSwitchPayload;
import org.jf.dexlib2.dexbacked.instruction.DexBackedUnknownInstruction;
import org.jf.dexlib2.iface.instruction.Instruction;
import org.jf.util.ExceptionWithContext;

public abstract class DexBackedInstruction
implements Instruction {
    @Nonnull
    public final DexBackedDexFile dexFile;
    @Nonnull
    public final Opcode opcode;
    public final int instructionStart;

    public DexBackedInstruction(@Nonnull DexBackedDexFile dexFile, @Nonnull Opcode opcode, int instructionStart) {
        if (dexFile == null) {
            DexBackedInstruction.$$$reportNull$$$0(0);
        }
        if (opcode == null) {
            DexBackedInstruction.$$$reportNull$$$0(1);
        }
        this.dexFile = dexFile;
        this.opcode = opcode;
        this.instructionStart = instructionStart;
    }

    @Override
    @Nonnull
    public Opcode getOpcode() {
        Opcode opcode = this.opcode;
        if (opcode == null) {
            DexBackedInstruction.$$$reportNull$$$0(2);
        }
        return opcode;
    }

    @Override
    public int getCodeUnits() {
        return this.opcode.format.size / 2;
    }

    @Nonnull
    public static Instruction readFrom(@Nonnull DexReader reader) {
        int opcodeValue;
        if (reader == null) {
            DexBackedInstruction.$$$reportNull$$$0(3);
        }
        if ((opcodeValue = reader.peekUbyte()) == 0) {
            opcodeValue = reader.peekUshort();
        }
        Opcode opcode = ((DexBackedDexFile)reader.dexBuf).getOpcodes().getOpcodeByValue(opcodeValue);
        DexBackedInstruction instruction = DexBackedInstruction.buildInstruction((DexBackedDexFile)reader.dexBuf, opcode, reader.getOffset());
        reader.moveRelative(instruction.getCodeUnits() * 2);
        DexBackedInstruction dexBackedInstruction = instruction;
        if (dexBackedInstruction == null) {
            DexBackedInstruction.$$$reportNull$$$0(4);
        }
        return dexBackedInstruction;
    }

    private static DexBackedInstruction buildInstruction(@Nonnull DexBackedDexFile dexFile, @Nullable Opcode opcode, int instructionStartOffset) {
        if (dexFile == null) {
            DexBackedInstruction.$$$reportNull$$$0(5);
        }
        if (opcode == null) {
            return new DexBackedUnknownInstruction(dexFile, instructionStartOffset);
        }
        switch (opcode.format) {
            case Format10t: {
                return new DexBackedInstruction10t(dexFile, opcode, instructionStartOffset);
            }
            case Format10x: {
                return new DexBackedInstruction10x(dexFile, opcode, instructionStartOffset);
            }
            case Format11n: {
                return new DexBackedInstruction11n(dexFile, opcode, instructionStartOffset);
            }
            case Format11x: {
                return new DexBackedInstruction11x(dexFile, opcode, instructionStartOffset);
            }
            case Format12x: {
                return new DexBackedInstruction12x(dexFile, opcode, instructionStartOffset);
            }
            case Format20bc: {
                return new DexBackedInstruction20bc(dexFile, opcode, instructionStartOffset);
            }
            case Format20t: {
                return new DexBackedInstruction20t(dexFile, opcode, instructionStartOffset);
            }
            case Format21c: {
                return new DexBackedInstruction21c(dexFile, opcode, instructionStartOffset);
            }
            case Format21ih: {
                return new DexBackedInstruction21ih(dexFile, opcode, instructionStartOffset);
            }
            case Format21lh: {
                return new DexBackedInstruction21lh(dexFile, opcode, instructionStartOffset);
            }
            case Format21s: {
                return new DexBackedInstruction21s(dexFile, opcode, instructionStartOffset);
            }
            case Format21t: {
                return new DexBackedInstruction21t(dexFile, opcode, instructionStartOffset);
            }
            case Format22b: {
                return new DexBackedInstruction22b(dexFile, opcode, instructionStartOffset);
            }
            case Format22c: {
                return new DexBackedInstruction22c(dexFile, opcode, instructionStartOffset);
            }
            case Format22cs: {
                return new DexBackedInstruction22cs(dexFile, opcode, instructionStartOffset);
            }
            case Format22s: {
                return new DexBackedInstruction22s(dexFile, opcode, instructionStartOffset);
            }
            case Format22t: {
                return new DexBackedInstruction22t(dexFile, opcode, instructionStartOffset);
            }
            case Format22x: {
                return new DexBackedInstruction22x(dexFile, opcode, instructionStartOffset);
            }
            case Format23x: {
                return new DexBackedInstruction23x(dexFile, opcode, instructionStartOffset);
            }
            case Format30t: {
                return new DexBackedInstruction30t(dexFile, opcode, instructionStartOffset);
            }
            case Format31c: {
                return new DexBackedInstruction31c(dexFile, opcode, instructionStartOffset);
            }
            case Format31i: {
                return new DexBackedInstruction31i(dexFile, opcode, instructionStartOffset);
            }
            case Format31t: {
                return new DexBackedInstruction31t(dexFile, opcode, instructionStartOffset);
            }
            case Format32x: {
                return new DexBackedInstruction32x(dexFile, opcode, instructionStartOffset);
            }
            case Format35c: {
                return new DexBackedInstruction35c(dexFile, opcode, instructionStartOffset);
            }
            case Format35ms: {
                return new DexBackedInstruction35ms(dexFile, opcode, instructionStartOffset);
            }
            case Format35mi: {
                return new DexBackedInstruction35mi(dexFile, opcode, instructionStartOffset);
            }
            case Format3rc: {
                return new DexBackedInstruction3rc(dexFile, opcode, instructionStartOffset);
            }
            case Format3rmi: {
                return new DexBackedInstruction3rmi(dexFile, opcode, instructionStartOffset);
            }
            case Format3rms: {
                return new DexBackedInstruction3rms(dexFile, opcode, instructionStartOffset);
            }
            case Format45cc: {
                return new DexBackedInstruction45cc(dexFile, opcode, instructionStartOffset);
            }
            case Format4rcc: {
                return new DexBackedInstruction4rcc(dexFile, opcode, instructionStartOffset);
            }
            case Format51l: {
                return new DexBackedInstruction51l(dexFile, opcode, instructionStartOffset);
            }
            case PackedSwitchPayload: {
                return new DexBackedPackedSwitchPayload(dexFile, instructionStartOffset);
            }
            case SparseSwitchPayload: {
                return new DexBackedSparseSwitchPayload(dexFile, instructionStartOffset);
            }
            case ArrayPayload: {
                return new DexBackedArrayPayload(dexFile, instructionStartOffset);
            }
        }
        throw new ExceptionWithContext("Unexpected opcode format: %s", opcode.format.toString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dexFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "opcode";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jf/dexlib2/dexbacked/instruction/DexBackedInstruction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jf/dexlib2/dexbacked/instruction/DexBackedInstruction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpcode";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "readFrom";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readFrom";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildInstruction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

