/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked;

import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.DexBackedMethod;
import org.jf.dexlib2.dexbacked.DexBackedTryBlock;
import org.jf.dexlib2.dexbacked.DexReader;
import org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction;
import org.jf.dexlib2.dexbacked.util.DebugInfo;
import org.jf.dexlib2.dexbacked.util.FixedSizeList;
import org.jf.dexlib2.dexbacked.util.VariableSizeLookaheadIterator;
import org.jf.dexlib2.iface.MethodImplementation;
import org.jf.dexlib2.iface.debug.DebugItem;
import org.jf.dexlib2.iface.instruction.Instruction;
import org.jf.util.AlignmentUtils;
import org.jf.util.ExceptionWithContext;

public class DexBackedMethodImplementation
implements MethodImplementation {
    @Nonnull
    public final DexBackedDexFile dexFile;
    @Nonnull
    public final DexBackedMethod method;
    private final int codeOffset;

    public DexBackedMethodImplementation(@Nonnull DexBackedDexFile dexFile, @Nonnull DexBackedMethod method, int codeOffset) {
        if (dexFile == null) {
            DexBackedMethodImplementation.$$$reportNull$$$0(0);
        }
        if (method == null) {
            DexBackedMethodImplementation.$$$reportNull$$$0(1);
        }
        this.dexFile = dexFile;
        this.method = method;
        this.codeOffset = codeOffset;
    }

    @Override
    public int getRegisterCount() {
        return this.dexFile.readUshort(this.codeOffset);
    }

    @Override
    @Nonnull
    public Iterable<? extends Instruction> getInstructions() {
        int instructionsSize = this.dexFile.readSmallUint(this.codeOffset + 12);
        final int instructionsStartOffset = this.codeOffset + 16;
        final int endOffset = instructionsStartOffset + instructionsSize * 2;
        Iterable<Instruction> iterable = new Iterable<Instruction>(){

            @Override
            public Iterator<Instruction> iterator() {
                return new VariableSizeLookaheadIterator<Instruction>(DexBackedMethodImplementation.this.dexFile, instructionsStartOffset){

                    @Override
                    protected Instruction readNextItem(@Nonnull DexReader reader) {
                        if (reader == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (reader.getOffset() >= endOffset) {
                            return (Instruction)this.endOfData();
                        }
                        Instruction instruction = DexBackedInstruction.readFrom(reader);
                        int offset = reader.getOffset();
                        if (offset > endOffset || offset < 0) {
                            throw new ExceptionWithContext("The last instruction in method %s is truncated", DexBackedMethodImplementation.this.method);
                        }
                        return instruction;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", "reader", "org/jf/dexlib2/dexbacked/DexBackedMethodImplementation$1$1", "readNextItem"));
                    }
                };
            }
        };
        if (iterable == null) {
            DexBackedMethodImplementation.$$$reportNull$$$0(2);
        }
        return iterable;
    }

    @Nonnull
    public List<? extends DexBackedTryBlock> getTryBlocks() {
        final int triesSize = this.dexFile.readUshort(this.codeOffset + 6);
        if (triesSize > 0) {
            int instructionsSize = this.dexFile.readSmallUint(this.codeOffset + 12);
            final int triesStartOffset = AlignmentUtils.alignOffset(this.codeOffset + 16 + instructionsSize * 2, 4);
            final int handlersStartOffset = triesStartOffset + triesSize * 8;
            FixedSizeList<DexBackedTryBlock> fixedSizeList = new FixedSizeList<DexBackedTryBlock>(){

                @Override
                @Nonnull
                public DexBackedTryBlock readItem(int index) {
                    DexBackedTryBlock dexBackedTryBlock = new DexBackedTryBlock(DexBackedMethodImplementation.this.dexFile, triesStartOffset + index * 8, handlersStartOffset);
                    if (dexBackedTryBlock == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return dexBackedTryBlock;
                }

                @Override
                public int size() {
                    return triesSize;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@Nonnull method %s.%s must not return null", "org/jf/dexlib2/dexbacked/DexBackedMethodImplementation$2", "readItem"));
                }
            };
            if (fixedSizeList == null) {
                DexBackedMethodImplementation.$$$reportNull$$$0(3);
            }
            return fixedSizeList;
        }
        ImmutableList immutableList = ImmutableList.of();
        if (immutableList == null) {
            DexBackedMethodImplementation.$$$reportNull$$$0(4);
        }
        return immutableList;
    }

    @Nonnull
    private DebugInfo getDebugInfo() {
        int debugOffset = this.dexFile.readInt(this.codeOffset + 8);
        if (debugOffset == -1 || debugOffset == 0) {
            DebugInfo debugInfo = DebugInfo.newOrEmpty(this.dexFile, 0, this);
            if (debugInfo == null) {
                DexBackedMethodImplementation.$$$reportNull$$$0(5);
            }
            return debugInfo;
        }
        if (debugOffset < 0) {
            System.err.println(String.format("%s: Invalid debug offset", this.method));
            DebugInfo debugInfo = DebugInfo.newOrEmpty(this.dexFile, 0, this);
            if (debugInfo == null) {
                DexBackedMethodImplementation.$$$reportNull$$$0(6);
            }
            return debugInfo;
        }
        if (debugOffset >= this.dexFile.buf.length) {
            System.err.println(String.format("%s: Invalid debug offset", this.method));
            DebugInfo debugInfo = DebugInfo.newOrEmpty(this.dexFile, 0, this);
            if (debugInfo == null) {
                DexBackedMethodImplementation.$$$reportNull$$$0(7);
            }
            return debugInfo;
        }
        DebugInfo debugInfo = DebugInfo.newOrEmpty(this.dexFile, debugOffset, this);
        if (debugInfo == null) {
            DexBackedMethodImplementation.$$$reportNull$$$0(8);
        }
        return debugInfo;
    }

    @Override
    @Nonnull
    public Iterable<? extends DebugItem> getDebugItems() {
        DebugInfo debugInfo = this.getDebugInfo();
        if (debugInfo == null) {
            DexBackedMethodImplementation.$$$reportNull$$$0(9);
        }
        return debugInfo;
    }

    @Nonnull
    public Iterator<String> getParameterNames(@Nullable DexReader dexReader) {
        Iterator<String> iterator = this.getDebugInfo().getParameterNames(dexReader);
        if (iterator == null) {
            DexBackedMethodImplementation.$$$reportNull$$$0(10);
        }
        return iterator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dexFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jf/dexlib2/dexbacked/DexBackedMethodImplementation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jf/dexlib2/dexbacked/DexBackedMethodImplementation";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstructions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTryBlocks";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugInfo";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugItems";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

