/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.base.reference.BaseMethodReference;
import org.jf.dexlib2.dexbacked.DexBackedAnnotation;
import org.jf.dexlib2.dexbacked.DexBackedClassDef;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.DexBackedMethodImplementation;
import org.jf.dexlib2.dexbacked.DexReader;
import org.jf.dexlib2.dexbacked.util.AnnotationsDirectory;
import org.jf.dexlib2.dexbacked.util.FixedSizeList;
import org.jf.dexlib2.dexbacked.util.ParameterIterator;
import org.jf.dexlib2.iface.Annotation;
import org.jf.dexlib2.iface.Method;
import org.jf.dexlib2.iface.MethodParameter;
import org.jf.util.AbstractForwardSequentialList;

public class DexBackedMethod
extends BaseMethodReference
implements Method {
    @Nonnull
    public final DexBackedDexFile dexFile;
    @Nonnull
    public final DexBackedClassDef classDef;
    public final int accessFlags;
    private final int codeOffset;
    private final int parameterAnnotationSetListOffset;
    private final int methodAnnotationSetOffset;
    public final int methodIndex;
    private int methodIdItemOffset;
    private int protoIdItemOffset;
    private int parametersOffset;

    public DexBackedMethod(@Nonnull DexReader reader, @Nonnull DexBackedClassDef classDef, int previousMethodIndex) {
        if (reader == null) {
            DexBackedMethod.$$$reportNull$$$0(0);
        }
        if (classDef == null) {
            DexBackedMethod.$$$reportNull$$$0(1);
        }
        this.parametersOffset = -1;
        this.dexFile = (DexBackedDexFile)reader.dexBuf;
        this.classDef = classDef;
        int methodIndexDiff = reader.readLargeUleb128();
        this.methodIndex = methodIndexDiff + previousMethodIndex;
        this.accessFlags = reader.readSmallUleb128();
        this.codeOffset = reader.readSmallUleb128();
        this.methodAnnotationSetOffset = 0;
        this.parameterAnnotationSetListOffset = 0;
    }

    public DexBackedMethod(@Nonnull DexReader reader, @Nonnull DexBackedClassDef classDef, int previousMethodIndex, @Nonnull AnnotationsDirectory.AnnotationIterator methodAnnotationIterator, @Nonnull AnnotationsDirectory.AnnotationIterator paramaterAnnotationIterator) {
        if (reader == null) {
            DexBackedMethod.$$$reportNull$$$0(2);
        }
        if (classDef == null) {
            DexBackedMethod.$$$reportNull$$$0(3);
        }
        if (methodAnnotationIterator == null) {
            DexBackedMethod.$$$reportNull$$$0(4);
        }
        if (paramaterAnnotationIterator == null) {
            DexBackedMethod.$$$reportNull$$$0(5);
        }
        this.parametersOffset = -1;
        this.dexFile = (DexBackedDexFile)reader.dexBuf;
        this.classDef = classDef;
        int methodIndexDiff = reader.readLargeUleb128();
        this.methodIndex = methodIndexDiff + previousMethodIndex;
        this.accessFlags = reader.readSmallUleb128();
        this.codeOffset = reader.readSmallUleb128();
        this.methodAnnotationSetOffset = methodAnnotationIterator.seekTo(this.methodIndex);
        this.parameterAnnotationSetListOffset = paramaterAnnotationIterator.seekTo(this.methodIndex);
    }

    public int getMethodIndex() {
        return this.methodIndex;
    }

    @Override
    @Nonnull
    public String getDefiningClass() {
        String string = this.classDef.getType();
        if (string == null) {
            DexBackedMethod.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    public int getAccessFlags() {
        return this.accessFlags;
    }

    @Override
    @Nonnull
    public String getName() {
        String string = this.dexFile.getString(this.dexFile.readSmallUint(this.getMethodIdItemOffset() + 4));
        if (string == null) {
            DexBackedMethod.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @Nonnull
    public String getReturnType() {
        String string = this.dexFile.getType(this.dexFile.readSmallUint(this.getProtoIdItemOffset() + 4));
        if (string == null) {
            DexBackedMethod.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @Nonnull
    public List<? extends MethodParameter> getParameters() {
        int parametersOffset = this.getParametersOffset();
        if (parametersOffset > 0) {
            final List<String> parameterTypes = this.getParameterTypes();
            AbstractForwardSequentialList<MethodParameter> abstractForwardSequentialList = new AbstractForwardSequentialList<MethodParameter>(){

                @Override
                @Nonnull
                public Iterator<MethodParameter> iterator() {
                    ParameterIterator parameterIterator = new ParameterIterator(parameterTypes, DexBackedMethod.this.getParameterAnnotations(), DexBackedMethod.this.getParameterNames());
                    if (parameterIterator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return parameterIterator;
                }

                @Override
                public int size() {
                    return parameterTypes.size();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@Nonnull method %s.%s must not return null", "org/jf/dexlib2/dexbacked/DexBackedMethod$1", "iterator"));
                }
            };
            if (abstractForwardSequentialList == null) {
                DexBackedMethod.$$$reportNull$$$0(9);
            }
            return abstractForwardSequentialList;
        }
        ImmutableList immutableList = ImmutableList.of();
        if (immutableList == null) {
            DexBackedMethod.$$$reportNull$$$0(10);
        }
        return immutableList;
    }

    @Nonnull
    public List<? extends Set<? extends DexBackedAnnotation>> getParameterAnnotations() {
        List<Set<? extends DexBackedAnnotation>> list = AnnotationsDirectory.getParameterAnnotations(this.dexFile, this.parameterAnnotationSetListOffset);
        if (list == null) {
            DexBackedMethod.$$$reportNull$$$0(11);
        }
        return list;
    }

    @Nonnull
    public Iterator<String> getParameterNames() {
        DexBackedMethodImplementation methodImpl = this.getImplementation();
        if (methodImpl != null) {
            Iterator<String> iterator = methodImpl.getParameterNames(null);
            if (iterator == null) {
                DexBackedMethod.$$$reportNull$$$0(12);
            }
            return iterator;
        }
        Iterator iterator = ImmutableSet.of().iterator();
        if (iterator == null) {
            DexBackedMethod.$$$reportNull$$$0(13);
        }
        return iterator;
    }

    @Nonnull
    public List<String> getParameterTypes() {
        int parametersOffset = this.getParametersOffset();
        if (parametersOffset > 0) {
            final int parameterCount = this.dexFile.readSmallUint(parametersOffset + 0);
            final int paramListStart = parametersOffset + 4;
            FixedSizeList<String> fixedSizeList = new FixedSizeList<String>(){

                @Override
                @Nonnull
                public String readItem(int index) {
                    String string = DexBackedMethod.this.dexFile.getType(DexBackedMethod.this.dexFile.readUshort(paramListStart + 2 * index));
                    if (string == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                @Override
                public int size() {
                    return parameterCount;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@Nonnull method %s.%s must not return null", "org/jf/dexlib2/dexbacked/DexBackedMethod$2", "readItem"));
                }
            };
            if (fixedSizeList == null) {
                DexBackedMethod.$$$reportNull$$$0(14);
            }
            return fixedSizeList;
        }
        ImmutableList<String> immutableList = ImmutableList.of();
        if (immutableList == null) {
            DexBackedMethod.$$$reportNull$$$0(15);
        }
        return immutableList;
    }

    @Override
    @Nonnull
    public Set<? extends Annotation> getAnnotations() {
        Set<? extends DexBackedAnnotation> set = AnnotationsDirectory.getAnnotations(this.dexFile, this.methodAnnotationSetOffset);
        if (set == null) {
            DexBackedMethod.$$$reportNull$$$0(16);
        }
        return set;
    }

    @Override
    @Nullable
    public DexBackedMethodImplementation getImplementation() {
        if (this.codeOffset > 0) {
            return new DexBackedMethodImplementation(this.dexFile, this, this.codeOffset);
        }
        return null;
    }

    private int getMethodIdItemOffset() {
        if (this.methodIdItemOffset == 0) {
            this.methodIdItemOffset = this.dexFile.getMethodIdItemOffset(this.methodIndex);
        }
        return this.methodIdItemOffset;
    }

    private int getProtoIdItemOffset() {
        if (this.protoIdItemOffset == 0) {
            int protoIndex = this.dexFile.readUshort(this.getMethodIdItemOffset() + 2);
            this.protoIdItemOffset = this.dexFile.getProtoIdItemOffset(protoIndex);
        }
        return this.protoIdItemOffset;
    }

    private int getParametersOffset() {
        if (this.parametersOffset == -1) {
            this.parametersOffset = this.dexFile.readSmallUint(this.getProtoIdItemOffset() + 8);
        }
        return this.parametersOffset;
    }

    public static void skipMethods(@Nonnull DexReader reader, int count) {
        if (reader == null) {
            DexBackedMethod.$$$reportNull$$$0(17);
        }
        for (int i = 0; i < count; ++i) {
            reader.skipUleb128();
            reader.skipUleb128();
            reader.skipUleb128();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDef";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodAnnotationIterator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramaterAnnotationIterator";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jf/dexlib2/dexbacked/DexBackedMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jf/dexlib2/dexbacked/DexBackedMethod";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefiningClass";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnType";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterAnnotations";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterNames";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterTypes";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "skipMethods";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

