/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked;

import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.base.reference.BaseFieldReference;
import org.jf.dexlib2.dexbacked.DexBackedAnnotation;
import org.jf.dexlib2.dexbacked.DexBackedClassDef;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.DexReader;
import org.jf.dexlib2.dexbacked.util.AnnotationsDirectory;
import org.jf.dexlib2.dexbacked.util.StaticInitialValueIterator;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.Field;
import org.jf.dexlib2.iface.value.EncodedValue;

public class DexBackedField
extends BaseFieldReference
implements Field {
    @Nonnull
    public final DexBackedDexFile dexFile;
    @Nonnull
    public final ClassDef classDef;
    public final int accessFlags;
    @Nullable
    public final EncodedValue initialValue;
    public final int annotationSetOffset;
    public final int fieldIndex;
    private int fieldIdItemOffset;

    public DexBackedField(@Nonnull DexReader reader, @Nonnull DexBackedClassDef classDef, int previousFieldIndex, @Nonnull StaticInitialValueIterator staticInitialValueIterator, @Nonnull AnnotationsDirectory.AnnotationIterator annotationIterator) {
        if (reader == null) {
            DexBackedField.$$$reportNull$$$0(0);
        }
        if (classDef == null) {
            DexBackedField.$$$reportNull$$$0(1);
        }
        if (staticInitialValueIterator == null) {
            DexBackedField.$$$reportNull$$$0(2);
        }
        if (annotationIterator == null) {
            DexBackedField.$$$reportNull$$$0(3);
        }
        this.dexFile = (DexBackedDexFile)reader.dexBuf;
        this.classDef = classDef;
        int fieldIndexDiff = reader.readLargeUleb128();
        this.fieldIndex = fieldIndexDiff + previousFieldIndex;
        this.accessFlags = reader.readSmallUleb128();
        this.annotationSetOffset = annotationIterator.seekTo(this.fieldIndex);
        this.initialValue = staticInitialValueIterator.getNextOrNull();
    }

    public DexBackedField(@Nonnull DexReader reader, @Nonnull DexBackedClassDef classDef, int previousFieldIndex, @Nonnull AnnotationsDirectory.AnnotationIterator annotationIterator) {
        if (reader == null) {
            DexBackedField.$$$reportNull$$$0(4);
        }
        if (classDef == null) {
            DexBackedField.$$$reportNull$$$0(5);
        }
        if (annotationIterator == null) {
            DexBackedField.$$$reportNull$$$0(6);
        }
        this.dexFile = (DexBackedDexFile)reader.dexBuf;
        this.classDef = classDef;
        int fieldIndexDiff = reader.readLargeUleb128();
        this.fieldIndex = fieldIndexDiff + previousFieldIndex;
        this.accessFlags = reader.readSmallUleb128();
        this.annotationSetOffset = annotationIterator.seekTo(this.fieldIndex);
        this.initialValue = null;
    }

    @Override
    @Nonnull
    public String getName() {
        String string = this.dexFile.getString(this.dexFile.readSmallUint(this.getFieldIdItemOffset() + 4));
        if (string == null) {
            DexBackedField.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @Nonnull
    public String getType() {
        String string = this.dexFile.getType(this.dexFile.readUshort(this.getFieldIdItemOffset() + 2));
        if (string == null) {
            DexBackedField.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @Nonnull
    public String getDefiningClass() {
        String string = this.classDef.getType();
        if (string == null) {
            DexBackedField.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    public int getAccessFlags() {
        return this.accessFlags;
    }

    @Override
    @Nullable
    public EncodedValue getInitialValue() {
        return this.initialValue;
    }

    @Nonnull
    public Set<? extends DexBackedAnnotation> getAnnotations() {
        Set<? extends DexBackedAnnotation> set = AnnotationsDirectory.getAnnotations(this.dexFile, this.annotationSetOffset);
        if (set == null) {
            DexBackedField.$$$reportNull$$$0(10);
        }
        return set;
    }

    public static void skipFields(@Nonnull DexReader reader, int count) {
        if (reader == null) {
            DexBackedField.$$$reportNull$$$0(11);
        }
        for (int i = 0; i < count; ++i) {
            reader.skipUleb128();
            reader.skipUleb128();
        }
    }

    private int getFieldIdItemOffset() {
        if (this.fieldIdItemOffset == 0) {
            this.fieldIdItemOffset = this.dexFile.getFieldIdItemOffset(this.fieldIndex);
        }
        return this.fieldIdItemOffset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDef";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "staticInitialValueIterator";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationIterator";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jf/dexlib2/dexbacked/DexBackedField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jf/dexlib2/dexbacked/DexBackedField";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefiningClass";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "skipFields";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

