/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.base.reference.BaseTypeReference;
import org.jf.dexlib2.dexbacked.DexBackedAnnotation;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.DexBackedField;
import org.jf.dexlib2.dexbacked.DexBackedMethod;
import org.jf.dexlib2.dexbacked.DexReader;
import org.jf.dexlib2.dexbacked.util.AnnotationsDirectory;
import org.jf.dexlib2.dexbacked.util.StaticInitialValueIterator;
import org.jf.dexlib2.dexbacked.util.VariableSizeLookaheadIterator;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.reference.FieldReference;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.immutable.reference.ImmutableFieldReference;
import org.jf.dexlib2.immutable.reference.ImmutableMethodReference;

public class DexBackedClassDef
extends BaseTypeReference
implements ClassDef {
    @Nonnull
    public final DexBackedDexFile dexFile;
    private final int classDefOffset;
    private final int staticFieldsOffset;
    private int instanceFieldsOffset;
    private int directMethodsOffset;
    private int virtualMethodsOffset;
    private final int staticFieldCount;
    private final int instanceFieldCount;
    private final int directMethodCount;
    private final int virtualMethodCount;
    @Nullable
    private AnnotationsDirectory annotationsDirectory;

    public DexBackedClassDef(@Nonnull DexBackedDexFile dexFile, int classDefOffset) {
        if (dexFile == null) {
            DexBackedClassDef.$$$reportNull$$$0(0);
        }
        this.instanceFieldsOffset = 0;
        this.directMethodsOffset = 0;
        this.virtualMethodsOffset = 0;
        this.dexFile = dexFile;
        this.classDefOffset = classDefOffset;
        int classDataOffset = dexFile.readSmallUint(classDefOffset + 24);
        if (classDataOffset == 0) {
            this.staticFieldsOffset = -1;
            this.staticFieldCount = 0;
            this.instanceFieldCount = 0;
            this.directMethodCount = 0;
            this.virtualMethodCount = 0;
        } else {
            DexReader reader = dexFile.readerAt(classDataOffset);
            this.staticFieldCount = reader.readSmallUleb128();
            this.instanceFieldCount = reader.readSmallUleb128();
            this.directMethodCount = reader.readSmallUleb128();
            this.virtualMethodCount = reader.readSmallUleb128();
            this.staticFieldsOffset = reader.getOffset();
        }
    }

    @Override
    @Nonnull
    public String getType() {
        String string = this.dexFile.getType(this.dexFile.readSmallUint(this.classDefOffset + 0));
        if (string == null) {
            DexBackedClassDef.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    public String getSuperclass() {
        return this.dexFile.getOptionalType(this.dexFile.readOptionalUint(this.classDefOffset + 8));
    }

    @Override
    public int getAccessFlags() {
        return this.dexFile.readSmallUint(this.classDefOffset + 4);
    }

    @Override
    @Nullable
    public String getSourceFile() {
        return this.dexFile.getOptionalString(this.dexFile.readOptionalUint(this.classDefOffset + 16));
    }

    @Override
    @Nonnull
    public List<String> getInterfaces() {
        final int interfacesOffset = this.dexFile.readSmallUint(this.classDefOffset + 12);
        if (interfacesOffset > 0) {
            final int size = this.dexFile.readSmallUint(interfacesOffset);
            AbstractList<String> abstractList = new AbstractList<String>(){

                @Override
                @Nonnull
                public String get(int index) {
                    String string = DexBackedClassDef.this.dexFile.getType(DexBackedClassDef.this.dexFile.readUshort(interfacesOffset + 4 + 2 * index));
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                @Override
                public int size() {
                    return size;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@Nonnull method %s.%s must not return null", "org/jf/dexlib2/dexbacked/DexBackedClassDef$1", "get"));
                }
            };
            if (abstractList == null) {
                DexBackedClassDef.$$$reportNull$$$0(2);
            }
            return abstractList;
        }
        ImmutableList<String> immutableList = ImmutableList.of();
        if (immutableList == null) {
            DexBackedClassDef.$$$reportNull$$$0(3);
        }
        return immutableList;
    }

    @Nonnull
    public Set<? extends DexBackedAnnotation> getAnnotations() {
        Set<? extends DexBackedAnnotation> set = this.getAnnotationsDirectory().getClassAnnotations();
        if (set == null) {
            DexBackedClassDef.$$$reportNull$$$0(4);
        }
        return set;
    }

    @Nonnull
    public Iterable<? extends DexBackedField> getStaticFields() {
        Iterable<? extends DexBackedField> iterable = this.getStaticFields(true);
        if (iterable == null) {
            DexBackedClassDef.$$$reportNull$$$0(5);
        }
        return iterable;
    }

    @Nonnull
    public Iterable<? extends DexBackedField> getStaticFields(final boolean skipDuplicates) {
        if (this.staticFieldCount > 0) {
            DexReader reader = this.dexFile.readerAt(this.staticFieldsOffset);
            final AnnotationsDirectory annotationsDirectory = this.getAnnotationsDirectory();
            final int staticInitialValuesOffset = this.dexFile.readSmallUint(this.classDefOffset + 28);
            final int fieldsStartOffset = reader.getOffset();
            Iterable<DexBackedField> iterable = new Iterable<DexBackedField>(){

                @Override
                @Nonnull
                public Iterator<DexBackedField> iterator() {
                    final AnnotationsDirectory.AnnotationIterator annotationIterator = annotationsDirectory.getFieldAnnotationIterator();
                    final StaticInitialValueIterator staticInitialValueIterator = StaticInitialValueIterator.newOrEmpty(DexBackedClassDef.this.dexFile, staticInitialValuesOffset);
                    VariableSizeLookaheadIterator<DexBackedField> variableSizeLookaheadIterator = new VariableSizeLookaheadIterator<DexBackedField>(DexBackedClassDef.this.dexFile, fieldsStartOffset){
                        private int count;
                        @Nullable
                        private FieldReference previousField;
                        private int previousIndex;

                        @Override
                        @Nullable
                        protected DexBackedField readNextItem(@Nonnull DexReader reader) {
                            DexBackedField item;
                            ImmutableFieldReference nextField;
                            FieldReference currentField;
                            if (reader == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            do {
                                if (++this.count > DexBackedClassDef.this.staticFieldCount) {
                                    DexBackedClassDef.this.instanceFieldsOffset = reader.getOffset();
                                    return (DexBackedField)this.endOfData();
                                }
                                item = new DexBackedField(reader, DexBackedClassDef.this, this.previousIndex, staticInitialValueIterator, annotationIterator);
                                currentField = this.previousField;
                                nextField = ImmutableFieldReference.of(item);
                                this.previousField = nextField;
                                this.previousIndex = item.fieldIndex;
                            } while (skipDuplicates && currentField != null && currentField.equals(nextField));
                            return item;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", "reader", "org/jf/dexlib2/dexbacked/DexBackedClassDef$2$1", "readNextItem"));
                        }
                    };
                    if (variableSizeLookaheadIterator == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return variableSizeLookaheadIterator;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@Nonnull method %s.%s must not return null", "org/jf/dexlib2/dexbacked/DexBackedClassDef$2", "iterator"));
                }
            };
            if (iterable == null) {
                DexBackedClassDef.$$$reportNull$$$0(6);
            }
            return iterable;
        }
        this.instanceFieldsOffset = this.staticFieldsOffset;
        ImmutableSet immutableSet = ImmutableSet.of();
        if (immutableSet == null) {
            DexBackedClassDef.$$$reportNull$$$0(7);
        }
        return immutableSet;
    }

    @Nonnull
    public Iterable<? extends DexBackedField> getInstanceFields() {
        Iterable<? extends DexBackedField> iterable = this.getInstanceFields(true);
        if (iterable == null) {
            DexBackedClassDef.$$$reportNull$$$0(8);
        }
        return iterable;
    }

    @Nonnull
    public Iterable<? extends DexBackedField> getInstanceFields(final boolean skipDuplicates) {
        if (this.instanceFieldCount > 0) {
            DexReader reader = this.dexFile.readerAt(this.getInstanceFieldsOffset());
            final AnnotationsDirectory annotationsDirectory = this.getAnnotationsDirectory();
            final int fieldsStartOffset = reader.getOffset();
            Iterable<DexBackedField> iterable = new Iterable<DexBackedField>(){

                @Override
                @Nonnull
                public Iterator<DexBackedField> iterator() {
                    final AnnotationsDirectory.AnnotationIterator annotationIterator = annotationsDirectory.getFieldAnnotationIterator();
                    VariableSizeLookaheadIterator<DexBackedField> variableSizeLookaheadIterator = new VariableSizeLookaheadIterator<DexBackedField>(DexBackedClassDef.this.dexFile, fieldsStartOffset){
                        private int count;
                        @Nullable
                        private FieldReference previousField;
                        private int previousIndex;

                        @Override
                        @Nullable
                        protected DexBackedField readNextItem(@Nonnull DexReader reader) {
                            DexBackedField item;
                            ImmutableFieldReference nextField;
                            FieldReference currentField;
                            if (reader == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            do {
                                if (++this.count > DexBackedClassDef.this.instanceFieldCount) {
                                    DexBackedClassDef.this.directMethodsOffset = reader.getOffset();
                                    return (DexBackedField)this.endOfData();
                                }
                                item = new DexBackedField(reader, DexBackedClassDef.this, this.previousIndex, annotationIterator);
                                currentField = this.previousField;
                                nextField = ImmutableFieldReference.of(item);
                                this.previousField = nextField;
                                this.previousIndex = item.fieldIndex;
                            } while (skipDuplicates && currentField != null && currentField.equals(nextField));
                            return item;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", "reader", "org/jf/dexlib2/dexbacked/DexBackedClassDef$3$1", "readNextItem"));
                        }
                    };
                    if (variableSizeLookaheadIterator == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return variableSizeLookaheadIterator;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@Nonnull method %s.%s must not return null", "org/jf/dexlib2/dexbacked/DexBackedClassDef$3", "iterator"));
                }
            };
            if (iterable == null) {
                DexBackedClassDef.$$$reportNull$$$0(9);
            }
            return iterable;
        }
        if (this.instanceFieldsOffset > 0) {
            this.directMethodsOffset = this.instanceFieldsOffset;
        }
        ImmutableSet immutableSet = ImmutableSet.of();
        if (immutableSet == null) {
            DexBackedClassDef.$$$reportNull$$$0(10);
        }
        return immutableSet;
    }

    @Nonnull
    public Iterable<? extends DexBackedField> getFields() {
        Iterable<? extends DexBackedField> iterable = Iterables.concat(this.getStaticFields(), this.getInstanceFields());
        if (iterable == null) {
            DexBackedClassDef.$$$reportNull$$$0(11);
        }
        return iterable;
    }

    @Nonnull
    public Iterable<? extends DexBackedMethod> getDirectMethods() {
        Iterable<? extends DexBackedMethod> iterable = this.getDirectMethods(true);
        if (iterable == null) {
            DexBackedClassDef.$$$reportNull$$$0(12);
        }
        return iterable;
    }

    @Nonnull
    public Iterable<? extends DexBackedMethod> getDirectMethods(final boolean skipDuplicates) {
        if (this.directMethodCount > 0) {
            DexReader reader = this.dexFile.readerAt(this.getDirectMethodsOffset());
            final AnnotationsDirectory annotationsDirectory = this.getAnnotationsDirectory();
            final int methodsStartOffset = reader.getOffset();
            Iterable<DexBackedMethod> iterable = new Iterable<DexBackedMethod>(){

                @Override
                @Nonnull
                public Iterator<DexBackedMethod> iterator() {
                    final AnnotationsDirectory.AnnotationIterator methodAnnotationIterator = annotationsDirectory.getMethodAnnotationIterator();
                    final AnnotationsDirectory.AnnotationIterator parameterAnnotationIterator = annotationsDirectory.getParameterAnnotationIterator();
                    VariableSizeLookaheadIterator<DexBackedMethod> variableSizeLookaheadIterator = new VariableSizeLookaheadIterator<DexBackedMethod>(DexBackedClassDef.this.dexFile, methodsStartOffset){
                        private int count;
                        @Nullable
                        private MethodReference previousMethod;
                        private int previousIndex;

                        @Override
                        @Nullable
                        protected DexBackedMethod readNextItem(@Nonnull DexReader reader) {
                            DexBackedMethod item;
                            ImmutableMethodReference nextMethod;
                            MethodReference currentMethod;
                            if (reader == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            do {
                                if (++this.count > DexBackedClassDef.this.directMethodCount) {
                                    DexBackedClassDef.this.virtualMethodsOffset = reader.getOffset();
                                    return (DexBackedMethod)this.endOfData();
                                }
                                item = new DexBackedMethod(reader, DexBackedClassDef.this, this.previousIndex, methodAnnotationIterator, parameterAnnotationIterator);
                                currentMethod = this.previousMethod;
                                nextMethod = ImmutableMethodReference.of(item);
                                this.previousMethod = nextMethod;
                                this.previousIndex = item.methodIndex;
                            } while (skipDuplicates && currentMethod != null && currentMethod.equals(nextMethod));
                            return item;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", "reader", "org/jf/dexlib2/dexbacked/DexBackedClassDef$4$1", "readNextItem"));
                        }
                    };
                    if (variableSizeLookaheadIterator == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    return variableSizeLookaheadIterator;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@Nonnull method %s.%s must not return null", "org/jf/dexlib2/dexbacked/DexBackedClassDef$4", "iterator"));
                }
            };
            if (iterable == null) {
                DexBackedClassDef.$$$reportNull$$$0(13);
            }
            return iterable;
        }
        if (this.directMethodsOffset > 0) {
            this.virtualMethodsOffset = this.directMethodsOffset;
        }
        ImmutableSet immutableSet = ImmutableSet.of();
        if (immutableSet == null) {
            DexBackedClassDef.$$$reportNull$$$0(14);
        }
        return immutableSet;
    }

    @Nonnull
    public Iterable<? extends DexBackedMethod> getVirtualMethods(final boolean skipDuplicates) {
        if (this.virtualMethodCount > 0) {
            DexReader reader = this.dexFile.readerAt(this.getVirtualMethodsOffset());
            final AnnotationsDirectory annotationsDirectory = this.getAnnotationsDirectory();
            final int methodsStartOffset = reader.getOffset();
            Iterable<DexBackedMethod> iterable = new Iterable<DexBackedMethod>(){
                final AnnotationsDirectory.AnnotationIterator methodAnnotationIterator;
                final AnnotationsDirectory.AnnotationIterator parameterAnnotationIterator;
                {
                    this.methodAnnotationIterator = annotationsDirectory.getMethodAnnotationIterator();
                    this.parameterAnnotationIterator = annotationsDirectory.getParameterAnnotationIterator();
                }

                @Override
                @Nonnull
                public Iterator<DexBackedMethod> iterator() {
                    VariableSizeLookaheadIterator<DexBackedMethod> variableSizeLookaheadIterator = new VariableSizeLookaheadIterator<DexBackedMethod>(DexBackedClassDef.this.dexFile, methodsStartOffset){
                        private int count;
                        @Nullable
                        private MethodReference previousMethod;
                        private int previousIndex;

                        @Override
                        @Nullable
                        protected DexBackedMethod readNextItem(@Nonnull DexReader reader) {
                            DexBackedMethod item;
                            ImmutableMethodReference nextMethod;
                            MethodReference currentMethod;
                            if (reader == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            do {
                                if (++this.count > DexBackedClassDef.this.virtualMethodCount) {
                                    return (DexBackedMethod)this.endOfData();
                                }
                                item = new DexBackedMethod(reader, DexBackedClassDef.this, this.previousIndex, methodAnnotationIterator, parameterAnnotationIterator);
                                currentMethod = this.previousMethod;
                                nextMethod = ImmutableMethodReference.of(item);
                                this.previousMethod = nextMethod;
                                this.previousIndex = item.methodIndex;
                            } while (skipDuplicates && currentMethod != null && currentMethod.equals(nextMethod));
                            return item;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", "reader", "org/jf/dexlib2/dexbacked/DexBackedClassDef$5$1", "readNextItem"));
                        }
                    };
                    if (variableSizeLookaheadIterator == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    return variableSizeLookaheadIterator;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@Nonnull method %s.%s must not return null", "org/jf/dexlib2/dexbacked/DexBackedClassDef$5", "iterator"));
                }
            };
            if (iterable == null) {
                DexBackedClassDef.$$$reportNull$$$0(15);
            }
            return iterable;
        }
        ImmutableSet immutableSet = ImmutableSet.of();
        if (immutableSet == null) {
            DexBackedClassDef.$$$reportNull$$$0(16);
        }
        return immutableSet;
    }

    @Nonnull
    public Iterable<? extends DexBackedMethod> getVirtualMethods() {
        Iterable<? extends DexBackedMethod> iterable = this.getVirtualMethods(true);
        if (iterable == null) {
            DexBackedClassDef.$$$reportNull$$$0(17);
        }
        return iterable;
    }

    @Nonnull
    public Iterable<? extends DexBackedMethod> getMethods() {
        Iterable<? extends DexBackedMethod> iterable = Iterables.concat(this.getDirectMethods(), this.getVirtualMethods());
        if (iterable == null) {
            DexBackedClassDef.$$$reportNull$$$0(18);
        }
        return iterable;
    }

    private AnnotationsDirectory getAnnotationsDirectory() {
        if (this.annotationsDirectory == null) {
            int annotationsDirectoryOffset = this.dexFile.readSmallUint(this.classDefOffset + 20);
            this.annotationsDirectory = AnnotationsDirectory.newOrEmpty(this.dexFile, annotationsDirectoryOffset);
        }
        return this.annotationsDirectory;
    }

    private int getInstanceFieldsOffset() {
        if (this.instanceFieldsOffset > 0) {
            return this.instanceFieldsOffset;
        }
        DexReader reader = new DexReader(this.dexFile, this.staticFieldsOffset);
        DexBackedField.skipFields(reader, this.staticFieldCount);
        this.instanceFieldsOffset = reader.getOffset();
        return this.instanceFieldsOffset;
    }

    private int getDirectMethodsOffset() {
        if (this.directMethodsOffset > 0) {
            return this.directMethodsOffset;
        }
        DexReader reader = this.dexFile.readerAt(this.getInstanceFieldsOffset());
        DexBackedField.skipFields(reader, this.instanceFieldCount);
        this.directMethodsOffset = reader.getOffset();
        return this.directMethodsOffset;
    }

    private int getVirtualMethodsOffset() {
        if (this.virtualMethodsOffset > 0) {
            return this.virtualMethodsOffset;
        }
        DexReader reader = this.dexFile.readerAt(this.getDirectMethodsOffset());
        DexBackedMethod.skipMethods(reader, this.directMethodCount);
        this.virtualMethodsOffset = reader.getOffset();
        return this.virtualMethodsOffset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dexFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jf/dexlib2/dexbacked/DexBackedClassDef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jf/dexlib2/dexbacked/DexBackedClassDef";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterfaces";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotations";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getStaticFields";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstanceFields";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFields";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectMethods";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualMethods";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethods";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

