/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked;

import javax.annotation.Nonnull;
import org.jf.dexlib2.dexbacked.BaseDexReader;
import org.jf.util.ExceptionWithContext;

public class BaseDexBuffer {
    @Nonnull
    final byte[] buf;
    final int baseOffset;

    public BaseDexBuffer(@Nonnull byte[] buf) {
        if (buf == null) {
            BaseDexBuffer.$$$reportNull$$$0(0);
        }
        this(buf, 0);
    }

    public BaseDexBuffer(@Nonnull byte[] buf, int offset) {
        if (buf == null) {
            BaseDexBuffer.$$$reportNull$$$0(1);
        }
        this.buf = buf;
        this.baseOffset = offset;
    }

    public int readSmallUint(int offset) {
        int result;
        byte[] buf = this.buf;
        if ((result = buf[offset += this.baseOffset] & 0xFF | (buf[offset + 1] & 0xFF) << 8 | (buf[offset + 2] & 0xFF) << 16 | buf[offset + 3] << 24) < 0) {
            throw new ExceptionWithContext("Encountered small uint that is out of range at offset 0x%x", offset);
        }
        return result;
    }

    public int readOptionalUint(int offset) {
        int result;
        byte[] buf = this.buf;
        if ((result = buf[offset += this.baseOffset] & 0xFF | (buf[offset + 1] & 0xFF) << 8 | (buf[offset + 2] & 0xFF) << 16 | buf[offset + 3] << 24) < -1) {
            throw new ExceptionWithContext("Encountered optional uint that is out of range at offset 0x%x", offset);
        }
        return result;
    }

    public int readUshort(int offset) {
        byte[] buf = this.buf;
        return buf[offset += this.baseOffset] & 0xFF | (buf[offset + 1] & 0xFF) << 8;
    }

    public int readUbyte(int offset) {
        return this.buf[offset + this.baseOffset] & 0xFF;
    }

    public long readLong(int offset) {
        byte[] buf = this.buf;
        return (long)(buf[offset += this.baseOffset] & 0xFF | (buf[offset + 1] & 0xFF) << 8 | (buf[offset + 2] & 0xFF) << 16) | ((long)buf[offset + 3] & 0xFFL) << 24 | ((long)buf[offset + 4] & 0xFFL) << 32 | ((long)buf[offset + 5] & 0xFFL) << 40 | ((long)buf[offset + 6] & 0xFFL) << 48 | (long)buf[offset + 7] << 56;
    }

    public int readLongAsSmallUint(int offset) {
        long result;
        byte[] buf = this.buf;
        if ((result = (long)(buf[offset += this.baseOffset] & 0xFF | (buf[offset + 1] & 0xFF) << 8 | (buf[offset + 2] & 0xFF) << 16) | ((long)buf[offset + 3] & 0xFFL) << 24 | ((long)buf[offset + 4] & 0xFFL) << 32 | ((long)buf[offset + 5] & 0xFFL) << 40 | ((long)buf[offset + 6] & 0xFFL) << 48 | (long)buf[offset + 7] << 56) < 0L || result > Integer.MAX_VALUE) {
            throw new ExceptionWithContext("Encountered out-of-range ulong at offset 0x%x", offset);
        }
        return (int)result;
    }

    public int readInt(int offset) {
        byte[] buf = this.buf;
        return buf[offset += this.baseOffset] & 0xFF | (buf[offset + 1] & 0xFF) << 8 | (buf[offset + 2] & 0xFF) << 16 | buf[offset + 3] << 24;
    }

    public int readShort(int offset) {
        byte[] buf = this.buf;
        return buf[offset += this.baseOffset] & 0xFF | buf[offset + 1] << 8;
    }

    public int readByte(int offset) {
        return this.buf[this.baseOffset + offset];
    }

    @Nonnull
    public BaseDexReader readerAt(int offset) {
        BaseDexReader<BaseDexBuffer> baseDexReader = new BaseDexReader<BaseDexBuffer>(this, offset);
        if (baseDexReader == null) {
            BaseDexBuffer.$$$reportNull$$$0(2);
        }
        return baseDexReader;
    }

    @Nonnull
    protected byte[] getBuf() {
        if (this.buf == null) {
            BaseDexBuffer.$$$reportNull$$$0(3);
        }
        return this.buf;
    }

    protected int getBaseOffset() {
        return this.baseOffset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buf";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jf/dexlib2/dexbacked/BaseDexBuffer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jf/dexlib2/dexbacked/BaseDexBuffer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "readerAt";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

