/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.builder.instruction;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.Format;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.builder.BuilderSwitchPayload;
import org.jf.dexlib2.builder.Label;
import org.jf.dexlib2.builder.instruction.BuilderSwitchElement;
import org.jf.dexlib2.iface.instruction.formats.PackedSwitchPayload;

public class BuilderPackedSwitchPayload
extends BuilderSwitchPayload
implements PackedSwitchPayload {
    public static final Opcode OPCODE = Opcode.PACKED_SWITCH_PAYLOAD;
    @Nonnull
    protected final List<BuilderSwitchElement> switchElements;

    public BuilderPackedSwitchPayload(int startKey, @Nullable List<? extends Label> switchElements) {
        super(OPCODE);
        if (switchElements == null) {
            this.switchElements = ImmutableList.of();
        } else {
            this.switchElements = Lists.newArrayList();
            int key = startKey;
            for (Label label : switchElements) {
                this.switchElements.add(new BuilderSwitchElement(this, key++, label));
            }
        }
    }

    @Nonnull
    public List<BuilderSwitchElement> getSwitchElements() {
        List<BuilderSwitchElement> list = this.switchElements;
        if (list == null) {
            BuilderPackedSwitchPayload.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    public int getCodeUnits() {
        return 4 + this.switchElements.size() * 2;
    }

    @Override
    public Format getFormat() {
        return BuilderPackedSwitchPayload.OPCODE.format;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@Nonnull method %s.%s must not return null", "org/jf/dexlib2/builder/instruction/BuilderPackedSwitchPayload", "getSwitchElements"));
    }
}

