/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.builder;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.builder.BuilderDebugItem;
import org.jf.dexlib2.builder.BuilderInstruction;
import org.jf.dexlib2.builder.BuilderOffsetInstruction;
import org.jf.dexlib2.builder.BuilderSwitchPayload;
import org.jf.dexlib2.builder.BuilderTryBlock;
import org.jf.dexlib2.builder.Label;
import org.jf.dexlib2.builder.MethodLocation;
import org.jf.dexlib2.builder.SwitchLabelElement;
import org.jf.dexlib2.builder.debug.BuilderEndLocal;
import org.jf.dexlib2.builder.debug.BuilderEpilogueBegin;
import org.jf.dexlib2.builder.debug.BuilderLineNumber;
import org.jf.dexlib2.builder.debug.BuilderPrologueEnd;
import org.jf.dexlib2.builder.debug.BuilderRestartLocal;
import org.jf.dexlib2.builder.debug.BuilderSetSourceFile;
import org.jf.dexlib2.builder.debug.BuilderStartLocal;
import org.jf.dexlib2.builder.instruction.BuilderArrayPayload;
import org.jf.dexlib2.builder.instruction.BuilderInstruction10t;
import org.jf.dexlib2.builder.instruction.BuilderInstruction10x;
import org.jf.dexlib2.builder.instruction.BuilderInstruction11n;
import org.jf.dexlib2.builder.instruction.BuilderInstruction11x;
import org.jf.dexlib2.builder.instruction.BuilderInstruction12x;
import org.jf.dexlib2.builder.instruction.BuilderInstruction20bc;
import org.jf.dexlib2.builder.instruction.BuilderInstruction20t;
import org.jf.dexlib2.builder.instruction.BuilderInstruction21c;
import org.jf.dexlib2.builder.instruction.BuilderInstruction21ih;
import org.jf.dexlib2.builder.instruction.BuilderInstruction21lh;
import org.jf.dexlib2.builder.instruction.BuilderInstruction21s;
import org.jf.dexlib2.builder.instruction.BuilderInstruction21t;
import org.jf.dexlib2.builder.instruction.BuilderInstruction22b;
import org.jf.dexlib2.builder.instruction.BuilderInstruction22c;
import org.jf.dexlib2.builder.instruction.BuilderInstruction22s;
import org.jf.dexlib2.builder.instruction.BuilderInstruction22t;
import org.jf.dexlib2.builder.instruction.BuilderInstruction22x;
import org.jf.dexlib2.builder.instruction.BuilderInstruction23x;
import org.jf.dexlib2.builder.instruction.BuilderInstruction30t;
import org.jf.dexlib2.builder.instruction.BuilderInstruction31c;
import org.jf.dexlib2.builder.instruction.BuilderInstruction31i;
import org.jf.dexlib2.builder.instruction.BuilderInstruction31t;
import org.jf.dexlib2.builder.instruction.BuilderInstruction32x;
import org.jf.dexlib2.builder.instruction.BuilderInstruction35c;
import org.jf.dexlib2.builder.instruction.BuilderInstruction3rc;
import org.jf.dexlib2.builder.instruction.BuilderInstruction51l;
import org.jf.dexlib2.builder.instruction.BuilderPackedSwitchPayload;
import org.jf.dexlib2.builder.instruction.BuilderSparseSwitchPayload;
import org.jf.dexlib2.iface.ExceptionHandler;
import org.jf.dexlib2.iface.MethodImplementation;
import org.jf.dexlib2.iface.TryBlock;
import org.jf.dexlib2.iface.debug.DebugItem;
import org.jf.dexlib2.iface.debug.EndLocal;
import org.jf.dexlib2.iface.debug.LineNumber;
import org.jf.dexlib2.iface.debug.RestartLocal;
import org.jf.dexlib2.iface.debug.SetSourceFile;
import org.jf.dexlib2.iface.debug.StartLocal;
import org.jf.dexlib2.iface.instruction.Instruction;
import org.jf.dexlib2.iface.instruction.SwitchElement;
import org.jf.dexlib2.iface.instruction.formats.ArrayPayload;
import org.jf.dexlib2.iface.instruction.formats.Instruction10t;
import org.jf.dexlib2.iface.instruction.formats.Instruction10x;
import org.jf.dexlib2.iface.instruction.formats.Instruction11n;
import org.jf.dexlib2.iface.instruction.formats.Instruction11x;
import org.jf.dexlib2.iface.instruction.formats.Instruction12x;
import org.jf.dexlib2.iface.instruction.formats.Instruction20bc;
import org.jf.dexlib2.iface.instruction.formats.Instruction20t;
import org.jf.dexlib2.iface.instruction.formats.Instruction21c;
import org.jf.dexlib2.iface.instruction.formats.Instruction21ih;
import org.jf.dexlib2.iface.instruction.formats.Instruction21lh;
import org.jf.dexlib2.iface.instruction.formats.Instruction21s;
import org.jf.dexlib2.iface.instruction.formats.Instruction21t;
import org.jf.dexlib2.iface.instruction.formats.Instruction22b;
import org.jf.dexlib2.iface.instruction.formats.Instruction22c;
import org.jf.dexlib2.iface.instruction.formats.Instruction22s;
import org.jf.dexlib2.iface.instruction.formats.Instruction22t;
import org.jf.dexlib2.iface.instruction.formats.Instruction22x;
import org.jf.dexlib2.iface.instruction.formats.Instruction23x;
import org.jf.dexlib2.iface.instruction.formats.Instruction30t;
import org.jf.dexlib2.iface.instruction.formats.Instruction31c;
import org.jf.dexlib2.iface.instruction.formats.Instruction31i;
import org.jf.dexlib2.iface.instruction.formats.Instruction31t;
import org.jf.dexlib2.iface.instruction.formats.Instruction32x;
import org.jf.dexlib2.iface.instruction.formats.Instruction35c;
import org.jf.dexlib2.iface.instruction.formats.Instruction3rc;
import org.jf.dexlib2.iface.instruction.formats.Instruction51l;
import org.jf.dexlib2.iface.instruction.formats.PackedSwitchPayload;
import org.jf.dexlib2.iface.instruction.formats.SparseSwitchPayload;
import org.jf.dexlib2.iface.reference.TypeReference;
import org.jf.util.ExceptionWithContext;

public class MutableMethodImplementation
implements MethodImplementation {
    private final int registerCount;
    final ArrayList<MethodLocation> instructionList;
    private final ArrayList<BuilderTryBlock> tryBlocks;
    private boolean fixInstructions;

    /*
     * WARNING - void declaration
     */
    public MutableMethodImplementation(@Nonnull MethodImplementation methodImplementation) {
        void var5_7;
        if (methodImplementation == null) {
            MutableMethodImplementation.$$$reportNull$$$0(0);
        }
        this.instructionList = Lists.newArrayList(new MethodLocation(null, 0, 0));
        this.tryBlocks = Lists.newArrayList();
        this.fixInstructions = true;
        this.registerCount = methodImplementation.getRegisterCount();
        int codeAddress = 0;
        int index = 0;
        for (Instruction instruction : methodImplementation.getInstructions()) {
            this.instructionList.add(new MethodLocation(null, codeAddress += instruction.getCodeUnits(), ++index));
        }
        final int[] codeAddressToIndex = new int[codeAddress + 1];
        Arrays.fill(codeAddressToIndex, -1);
        boolean bl = false;
        while (var5_7 < this.instructionList.size()) {
            codeAddressToIndex[this.instructionList.get((int)var5_7).codeAddress] = var5_7;
            ++var5_7;
        }
        ArrayList<1> arrayList = Lists.newArrayList();
        index = 0;
        for (final Instruction instruction : methodImplementation.getInstructions()) {
            final MethodLocation location = this.instructionList.get(index);
            Opcode opcode = instruction.getOpcode();
            if (opcode == Opcode.PACKED_SWITCH_PAYLOAD || opcode == Opcode.SPARSE_SWITCH_PAYLOAD) {
                arrayList.add(new Task(){

                    @Override
                    public void perform() {
                        MutableMethodImplementation.this.convertAndSetInstruction(location, codeAddressToIndex, instruction);
                    }
                });
            } else {
                this.convertAndSetInstruction(location, codeAddressToIndex, instruction);
            }
            ++index;
        }
        for (Task task : arrayList) {
            task.perform();
        }
        for (DebugItem debugItem : methodImplementation.getDebugItems()) {
            int debugCodeAddress = debugItem.getCodeAddress();
            int locationIndex = this.mapCodeAddressToIndex(codeAddressToIndex, debugCodeAddress);
            MethodLocation debugLocation = this.instructionList.get(locationIndex);
            BuilderDebugItem builderDebugItem = this.convertDebugItem(debugItem);
            debugLocation.getDebugItems().add(builderDebugItem);
            builderDebugItem.location = debugLocation;
        }
        for (TryBlock tryBlock : methodImplementation.getTryBlocks()) {
            Label startLabel = this.newLabel(codeAddressToIndex, tryBlock.getStartCodeAddress());
            Label endLabel = this.newLabel(codeAddressToIndex, tryBlock.getStartCodeAddress() + tryBlock.getCodeUnitCount());
            for (ExceptionHandler exceptionHandler : tryBlock.getExceptionHandlers()) {
                this.tryBlocks.add(new BuilderTryBlock(startLabel, endLabel, exceptionHandler.getExceptionTypeReference(), this.newLabel(codeAddressToIndex, exceptionHandler.getHandlerCodeAddress())));
            }
        }
    }

    public MutableMethodImplementation(int registerCount) {
        this.instructionList = Lists.newArrayList(new MethodLocation(null, 0, 0));
        this.tryBlocks = Lists.newArrayList();
        this.fixInstructions = true;
        this.registerCount = registerCount;
    }

    @Override
    public int getRegisterCount() {
        return this.registerCount;
    }

    @Nonnull
    public List<BuilderInstruction> getInstructions() {
        if (this.fixInstructions) {
            this.fixInstructions();
        }
        AbstractList<BuilderInstruction> abstractList = new AbstractList<BuilderInstruction>(){

            @Override
            public BuilderInstruction get(int i) {
                if (i >= this.size()) {
                    throw new IndexOutOfBoundsException();
                }
                if (MutableMethodImplementation.this.fixInstructions) {
                    MutableMethodImplementation.this.fixInstructions();
                }
                return MutableMethodImplementation.this.instructionList.get((int)i).instruction;
            }

            @Override
            public int size() {
                if (MutableMethodImplementation.this.fixInstructions) {
                    MutableMethodImplementation.this.fixInstructions();
                }
                return MutableMethodImplementation.this.instructionList.size() - 1;
            }
        };
        if (abstractList == null) {
            MutableMethodImplementation.$$$reportNull$$$0(1);
        }
        return abstractList;
    }

    @Nonnull
    public List<BuilderTryBlock> getTryBlocks() {
        if (this.fixInstructions) {
            this.fixInstructions();
        }
        List<BuilderTryBlock> list = Collections.unmodifiableList(this.tryBlocks);
        if (list == null) {
            MutableMethodImplementation.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    @Nonnull
    public Iterable<? extends DebugItem> getDebugItems() {
        if (this.fixInstructions) {
            this.fixInstructions();
        }
        Iterable<? extends DebugItem> iterable = Iterables.concat(Iterables.transform(this.instructionList, new Function<MethodLocation, Iterable<? extends DebugItem>>(){

            @Override
            @Nullable
            public Iterable<? extends DebugItem> apply(@Nullable MethodLocation input) {
                assert (input != null);
                if (MutableMethodImplementation.this.fixInstructions) {
                    throw new IllegalStateException("This iterator was invalidated by a change to this MutableMethodImplementation.");
                }
                return input.getDebugItems();
            }
        }));
        if (iterable == null) {
            MutableMethodImplementation.$$$reportNull$$$0(3);
        }
        return iterable;
    }

    public void addCatch(@Nullable TypeReference type, @Nonnull Label from, @Nonnull Label to, @Nonnull Label handler) {
        if (from == null) {
            MutableMethodImplementation.$$$reportNull$$$0(4);
        }
        if (to == null) {
            MutableMethodImplementation.$$$reportNull$$$0(5);
        }
        if (handler == null) {
            MutableMethodImplementation.$$$reportNull$$$0(6);
        }
        this.tryBlocks.add(new BuilderTryBlock(from, to, type, handler));
    }

    public void addCatch(@Nullable String type, @Nonnull Label from, @Nonnull Label to, @Nonnull Label handler) {
        if (from == null) {
            MutableMethodImplementation.$$$reportNull$$$0(7);
        }
        if (to == null) {
            MutableMethodImplementation.$$$reportNull$$$0(8);
        }
        if (handler == null) {
            MutableMethodImplementation.$$$reportNull$$$0(9);
        }
        this.tryBlocks.add(new BuilderTryBlock(from, to, type, handler));
    }

    public void addCatch(@Nonnull Label from, @Nonnull Label to, @Nonnull Label handler) {
        if (from == null) {
            MutableMethodImplementation.$$$reportNull$$$0(10);
        }
        if (to == null) {
            MutableMethodImplementation.$$$reportNull$$$0(11);
        }
        if (handler == null) {
            MutableMethodImplementation.$$$reportNull$$$0(12);
        }
        this.tryBlocks.add(new BuilderTryBlock(from, to, handler));
    }

    public void addInstruction(int index, BuilderInstruction instruction) {
        if (index >= this.instructionList.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (index == this.instructionList.size() - 1) {
            this.addInstruction(instruction);
            return;
        }
        int codeAddress = this.instructionList.get(index).getCodeAddress();
        MethodLocation newLoc = new MethodLocation(instruction, codeAddress, index);
        this.instructionList.add(index, newLoc);
        instruction.location = newLoc;
        codeAddress += instruction.getCodeUnits();
        for (int i = index + 1; i < this.instructionList.size(); ++i) {
            MethodLocation location = this.instructionList.get(i);
            ++location.index;
            location.codeAddress = codeAddress;
            if (location.instruction != null) {
                codeAddress += location.instruction.getCodeUnits();
                continue;
            }
            assert (i == this.instructionList.size() - 1);
        }
        this.fixInstructions = true;
    }

    public void addInstruction(@Nonnull BuilderInstruction instruction) {
        if (instruction == null) {
            MutableMethodImplementation.$$$reportNull$$$0(13);
        }
        MethodLocation last = this.instructionList.get(this.instructionList.size() - 1);
        last.instruction = instruction;
        instruction.location = last;
        int nextCodeAddress = last.codeAddress + instruction.getCodeUnits();
        this.instructionList.add(new MethodLocation(null, nextCodeAddress, this.instructionList.size()));
        this.fixInstructions = true;
    }

    public void replaceInstruction(int index, @Nonnull BuilderInstruction replacementInstruction) {
        MethodLocation replaceLocation;
        if (replacementInstruction == null) {
            MutableMethodImplementation.$$$reportNull$$$0(14);
        }
        if (index >= this.instructionList.size() - 1) {
            throw new IndexOutOfBoundsException();
        }
        replacementInstruction.location = replaceLocation = this.instructionList.get(index);
        BuilderInstruction old = replaceLocation.instruction;
        assert (old != null);
        old.location = null;
        replaceLocation.instruction = replacementInstruction;
        int codeAddress = replaceLocation.codeAddress + replaceLocation.instruction.getCodeUnits();
        for (int i = index + 1; i < this.instructionList.size(); ++i) {
            MethodLocation location = this.instructionList.get(i);
            location.codeAddress = codeAddress;
            Instruction instruction = location.getInstruction();
            if (instruction != null) {
                codeAddress += instruction.getCodeUnits();
                continue;
            }
            assert (i == this.instructionList.size() - 1);
        }
        this.fixInstructions = true;
    }

    public void removeInstruction(int index) {
        if (index >= this.instructionList.size() - 1) {
            throw new IndexOutOfBoundsException();
        }
        MethodLocation toRemove = this.instructionList.get(index);
        toRemove.instruction = null;
        MethodLocation next = this.instructionList.get(index + 1);
        toRemove.mergeInto(next);
        this.instructionList.remove(index);
        int codeAddress = toRemove.codeAddress;
        for (int i = index; i < this.instructionList.size(); ++i) {
            MethodLocation location = this.instructionList.get(i);
            location.index = i;
            location.codeAddress = codeAddress;
            Instruction instruction = location.getInstruction();
            if (instruction != null) {
                codeAddress += instruction.getCodeUnits();
                continue;
            }
            assert (i == this.instructionList.size() - 1);
        }
        this.fixInstructions = true;
    }

    public void swapInstructions(int index1, int index2) {
        if (index1 >= this.instructionList.size() - 1 || index2 >= this.instructionList.size() - 1) {
            throw new IndexOutOfBoundsException();
        }
        MethodLocation first = this.instructionList.get(index1);
        MethodLocation second = this.instructionList.get(index2);
        assert (first.instruction != null);
        assert (second.instruction != null);
        first.instruction.location = second;
        second.instruction.location = first;
        BuilderInstruction tmp = second.instruction;
        second.instruction = first.instruction;
        first.instruction = tmp;
        if (index2 < index1) {
            int tmp2 = index2;
            index2 = index1;
            index1 = tmp2;
        }
        int codeAddress = first.codeAddress + first.instruction.getCodeUnits();
        for (int i = index1 + 1; i <= index2; ++i) {
            MethodLocation location = this.instructionList.get(i);
            location.codeAddress = codeAddress;
            BuilderInstruction instruction = location.instruction;
            assert (instruction != null);
            codeAddress += location.instruction.getCodeUnits();
        }
        this.fixInstructions = true;
    }

    @Nullable
    private BuilderInstruction getFirstNonNop(int startIndex) {
        for (int i = startIndex; i < this.instructionList.size() - 1; ++i) {
            BuilderInstruction instruction = this.instructionList.get((int)i).instruction;
            assert (instruction != null);
            if (instruction.getOpcode() == Opcode.NOP) continue;
            return instruction;
        }
        return null;
    }

    private void fixInstructions() {
        boolean madeChanges;
        HashSet<MethodLocation> payloadLocations = Sets.newHashSet();
        for (MethodLocation location : this.instructionList) {
            BuilderInstruction instruction = location.instruction;
            if (instruction == null) continue;
            switch (instruction.getOpcode()) {
                case SPARSE_SWITCH: 
                case PACKED_SWITCH: {
                    MethodLocation targetLocation = ((BuilderOffsetInstruction)instruction).getTarget().getLocation();
                    BuilderInstruction targetInstruction = targetLocation.instruction;
                    if (targetInstruction == null) {
                        throw new IllegalStateException(String.format("Switch instruction at address/index 0x%x/%d points to the end of the method.", location.codeAddress, location.index));
                    }
                    if (targetInstruction.getOpcode() == Opcode.NOP) {
                        targetInstruction = this.getFirstNonNop(targetLocation.index + 1);
                    }
                    if (targetInstruction == null || !(targetInstruction instanceof BuilderSwitchPayload)) {
                        throw new IllegalStateException(String.format("Switch instruction at address/index 0x%x/%d does not refer to a payload instruction.", location.codeAddress, location.index));
                    }
                    if (instruction.opcode == Opcode.PACKED_SWITCH && targetInstruction.getOpcode() != Opcode.PACKED_SWITCH_PAYLOAD || instruction.opcode == Opcode.SPARSE_SWITCH && targetInstruction.getOpcode() != Opcode.SPARSE_SWITCH_PAYLOAD) {
                        throw new IllegalStateException(String.format("Switch instruction at address/index 0x%x/%d refers to the wrong type of payload instruction.", location.codeAddress, location.index));
                    }
                    if (!payloadLocations.add(targetLocation)) {
                        throw new IllegalStateException("Multiple switch instructions refer to the same payload. This is not currently supported. Please file a bug :)");
                    }
                    ((BuilderSwitchPayload)targetInstruction).referrer = location;
                    break;
                }
            }
        }
        do {
            madeChanges = false;
            block11: for (int index = 0; index < this.instructionList.size(); ++index) {
                MethodLocation location = this.instructionList.get(index);
                BuilderInstruction instruction = location.instruction;
                if (instruction == null) continue;
                switch (instruction.getOpcode()) {
                    case GOTO: {
                        int offset = ((BuilderOffsetInstruction)instruction).internalGetCodeOffset();
                        if (offset >= -128 && offset <= 127) continue block11;
                        BuilderOffsetInstruction replacement = offset < Short.MIN_VALUE || offset > Short.MAX_VALUE ? new BuilderInstruction30t(Opcode.GOTO_32, ((BuilderOffsetInstruction)instruction).getTarget()) : new BuilderInstruction20t(Opcode.GOTO_16, ((BuilderOffsetInstruction)instruction).getTarget());
                        this.replaceInstruction(location.index, replacement);
                        madeChanges = true;
                        continue block11;
                    }
                    case GOTO_16: {
                        int offset = ((BuilderOffsetInstruction)instruction).internalGetCodeOffset();
                        if (offset >= Short.MIN_VALUE && offset <= Short.MAX_VALUE) continue block11;
                        BuilderOffsetInstruction replacement = new BuilderInstruction30t(Opcode.GOTO_32, ((BuilderOffsetInstruction)instruction).getTarget());
                        this.replaceInstruction(location.index, replacement);
                        madeChanges = true;
                        continue block11;
                    }
                    case SPARSE_SWITCH_PAYLOAD: 
                    case PACKED_SWITCH_PAYLOAD: {
                        if (((BuilderSwitchPayload)instruction).referrer == null) {
                            this.removeInstruction(index);
                            --index;
                            madeChanges = true;
                            continue block11;
                        }
                    }
                    case ARRAY_PAYLOAD: {
                        if ((location.codeAddress & 1) == 0) continue block11;
                        int previousIndex = location.index - 1;
                        MethodLocation previousLocation = this.instructionList.get(previousIndex);
                        BuilderInstruction previousInstruction = previousLocation.instruction;
                        assert (previousInstruction != null);
                        if (previousInstruction.getOpcode() == Opcode.NOP) {
                            this.removeInstruction(previousIndex);
                            --index;
                        } else {
                            this.addInstruction(location.index, new BuilderInstruction10x(Opcode.NOP));
                            ++index;
                        }
                        madeChanges = true;
                    }
                }
            }
        } while (madeChanges);
        this.fixInstructions = false;
    }

    private int mapCodeAddressToIndex(@Nonnull int[] codeAddressToIndex, int codeAddress) {
        int index;
        if (codeAddressToIndex == null) {
            MutableMethodImplementation.$$$reportNull$$$0(15);
        }
        while ((index = codeAddressToIndex[codeAddress]) < 0) {
            --codeAddress;
        }
        return index;
    }

    private int mapCodeAddressToIndex(int codeAddress) {
        float avgCodeUnitsPerInstruction = 1.9f;
        int index = (int)((float)codeAddress / avgCodeUnitsPerInstruction);
        if (index >= this.instructionList.size()) {
            index = this.instructionList.size() - 1;
        }
        MethodLocation guessedLocation = this.instructionList.get(index);
        if (guessedLocation.codeAddress == codeAddress) {
            return index;
        }
        if (guessedLocation.codeAddress > codeAddress) {
            while (this.instructionList.get((int)(--index)).codeAddress > codeAddress) {
            }
            return index;
        }
        while (++index < this.instructionList.size() && this.instructionList.get((int)index).codeAddress <= codeAddress) {
        }
        return index - 1;
    }

    @Nonnull
    public Label newLabelForAddress(int codeAddress) {
        if (codeAddress < 0 || codeAddress > this.instructionList.get((int)(this.instructionList.size() - 1)).codeAddress) {
            throw new IndexOutOfBoundsException(String.format("codeAddress %d out of bounds", codeAddress));
        }
        MethodLocation referent = this.instructionList.get(this.mapCodeAddressToIndex(codeAddress));
        Label label = referent.addNewLabel();
        if (label == null) {
            MutableMethodImplementation.$$$reportNull$$$0(16);
        }
        return label;
    }

    @Nonnull
    public Label newLabelForIndex(int instructionIndex) {
        if (instructionIndex < 0 || instructionIndex >= this.instructionList.size()) {
            throw new IndexOutOfBoundsException(String.format("instruction index %d out of bounds", instructionIndex));
        }
        MethodLocation referent = this.instructionList.get(instructionIndex);
        Label label = referent.addNewLabel();
        if (label == null) {
            MutableMethodImplementation.$$$reportNull$$$0(17);
        }
        return label;
    }

    @Nonnull
    private Label newLabel(@Nonnull int[] codeAddressToIndex, int codeAddress) {
        if (codeAddressToIndex == null) {
            MutableMethodImplementation.$$$reportNull$$$0(18);
        }
        MethodLocation referent = this.instructionList.get(this.mapCodeAddressToIndex(codeAddressToIndex, codeAddress));
        Label label = referent.addNewLabel();
        if (label == null) {
            MutableMethodImplementation.$$$reportNull$$$0(19);
        }
        return label;
    }

    @Nonnull
    public Label newSwitchPayloadReferenceLabel(@Nonnull MethodLocation switchLocation, @Nonnull int[] codeAddressToIndex, int codeAddress) {
        if (switchLocation == null) {
            MutableMethodImplementation.$$$reportNull$$$0(20);
        }
        if (codeAddressToIndex == null) {
            MutableMethodImplementation.$$$reportNull$$$0(21);
        }
        MethodLocation referent = this.instructionList.get(this.mapCodeAddressToIndex(codeAddressToIndex, codeAddress));
        SwitchPayloadReferenceLabel label = new SwitchPayloadReferenceLabel();
        label.switchLocation = switchLocation;
        referent.getLabels().add(label);
        SwitchPayloadReferenceLabel switchPayloadReferenceLabel = label;
        if (switchPayloadReferenceLabel == null) {
            MutableMethodImplementation.$$$reportNull$$$0(22);
        }
        return switchPayloadReferenceLabel;
    }

    private void setInstruction(@Nonnull MethodLocation location, @Nonnull BuilderInstruction instruction) {
        if (location == null) {
            MutableMethodImplementation.$$$reportNull$$$0(23);
        }
        if (instruction == null) {
            MutableMethodImplementation.$$$reportNull$$$0(24);
        }
        location.instruction = instruction;
        instruction.location = location;
    }

    private void convertAndSetInstruction(@Nonnull MethodLocation location, int[] codeAddressToIndex, @Nonnull Instruction instruction) {
        if (location == null) {
            MutableMethodImplementation.$$$reportNull$$$0(25);
        }
        if (instruction == null) {
            MutableMethodImplementation.$$$reportNull$$$0(26);
        }
        switch (instruction.getOpcode().format) {
            case Format10t: {
                this.setInstruction(location, this.newBuilderInstruction10t(location.codeAddress, codeAddressToIndex, (Instruction10t)instruction));
                return;
            }
            case Format10x: {
                this.setInstruction(location, this.newBuilderInstruction10x((Instruction10x)instruction));
                return;
            }
            case Format11n: {
                this.setInstruction(location, this.newBuilderInstruction11n((Instruction11n)instruction));
                return;
            }
            case Format11x: {
                this.setInstruction(location, this.newBuilderInstruction11x((Instruction11x)instruction));
                return;
            }
            case Format12x: {
                this.setInstruction(location, this.newBuilderInstruction12x((Instruction12x)instruction));
                return;
            }
            case Format20bc: {
                this.setInstruction(location, this.newBuilderInstruction20bc((Instruction20bc)instruction));
                return;
            }
            case Format20t: {
                this.setInstruction(location, this.newBuilderInstruction20t(location.codeAddress, codeAddressToIndex, (Instruction20t)instruction));
                return;
            }
            case Format21c: {
                this.setInstruction(location, this.newBuilderInstruction21c((Instruction21c)instruction));
                return;
            }
            case Format21ih: {
                this.setInstruction(location, this.newBuilderInstruction21ih((Instruction21ih)instruction));
                return;
            }
            case Format21lh: {
                this.setInstruction(location, this.newBuilderInstruction21lh((Instruction21lh)instruction));
                return;
            }
            case Format21s: {
                this.setInstruction(location, this.newBuilderInstruction21s((Instruction21s)instruction));
                return;
            }
            case Format21t: {
                this.setInstruction(location, this.newBuilderInstruction21t(location.codeAddress, codeAddressToIndex, (Instruction21t)instruction));
                return;
            }
            case Format22b: {
                this.setInstruction(location, this.newBuilderInstruction22b((Instruction22b)instruction));
                return;
            }
            case Format22c: {
                this.setInstruction(location, this.newBuilderInstruction22c((Instruction22c)instruction));
                return;
            }
            case Format22s: {
                this.setInstruction(location, this.newBuilderInstruction22s((Instruction22s)instruction));
                return;
            }
            case Format22t: {
                this.setInstruction(location, this.newBuilderInstruction22t(location.codeAddress, codeAddressToIndex, (Instruction22t)instruction));
                return;
            }
            case Format22x: {
                this.setInstruction(location, this.newBuilderInstruction22x((Instruction22x)instruction));
                return;
            }
            case Format23x: {
                this.setInstruction(location, this.newBuilderInstruction23x((Instruction23x)instruction));
                return;
            }
            case Format30t: {
                this.setInstruction(location, this.newBuilderInstruction30t(location.codeAddress, codeAddressToIndex, (Instruction30t)instruction));
                return;
            }
            case Format31c: {
                this.setInstruction(location, this.newBuilderInstruction31c((Instruction31c)instruction));
                return;
            }
            case Format31i: {
                this.setInstruction(location, this.newBuilderInstruction31i((Instruction31i)instruction));
                return;
            }
            case Format31t: {
                this.setInstruction(location, this.newBuilderInstruction31t(location, codeAddressToIndex, (Instruction31t)instruction));
                return;
            }
            case Format32x: {
                this.setInstruction(location, this.newBuilderInstruction32x((Instruction32x)instruction));
                return;
            }
            case Format35c: {
                this.setInstruction(location, this.newBuilderInstruction35c((Instruction35c)instruction));
                return;
            }
            case Format3rc: {
                this.setInstruction(location, this.newBuilderInstruction3rc((Instruction3rc)instruction));
                return;
            }
            case Format51l: {
                this.setInstruction(location, this.newBuilderInstruction51l((Instruction51l)instruction));
                return;
            }
            case PackedSwitchPayload: {
                this.setInstruction(location, this.newBuilderPackedSwitchPayload(location, codeAddressToIndex, (PackedSwitchPayload)instruction));
                return;
            }
            case SparseSwitchPayload: {
                this.setInstruction(location, this.newBuilderSparseSwitchPayload(location, codeAddressToIndex, (SparseSwitchPayload)instruction));
                return;
            }
            case ArrayPayload: {
                this.setInstruction(location, this.newBuilderArrayPayload((ArrayPayload)instruction));
                return;
            }
        }
        throw new ExceptionWithContext("Instruction format %s not supported", new Object[]{instruction.getOpcode().format});
    }

    @Nonnull
    private BuilderInstruction10t newBuilderInstruction10t(int codeAddress, int[] codeAddressToIndex, @Nonnull Instruction10t instruction) {
        if (instruction == null) {
            MutableMethodImplementation.$$$reportNull$$$0(27);
        }
        BuilderInstruction10t builderInstruction10t = new BuilderInstruction10t(instruction.getOpcode(), this.newLabel(codeAddressToIndex, codeAddress + instruction.getCodeOffset()));
        if (builderInstruction10t == null) {
            MutableMethodImplementation.$$$reportNull$$$0(28);
        }
        return builderInstruction10t;
    }

    @Nonnull
    private BuilderInstruction10x newBuilderInstruction10x(@Nonnull Instruction10x instruction) {
        if (instruction == null) {
            MutableMethodImplementation.$$$reportNull$$$0(29);
        }
        BuilderInstruction10x builderInstruction10x = new BuilderInstruction10x(instruction.getOpcode());
        if (builderInstruction10x == null) {
            MutableMethodImplementation.$$$reportNull$$$0(30);
        }
        return builderInstruction10x;
    }

    @Nonnull
    private BuilderInstruction11n newBuilderInstruction11n(@Nonnull Instruction11n instruction) {
        if (instruction == null) {
            MutableMethodImplementation.$$$reportNull$$$0(31);
        }
        BuilderInstruction11n builderInstruction11n = new BuilderInstruction11n(instruction.getOpcode(), instruction.getRegisterA(), instruction.getNarrowLiteral());
        if (builderInstruction11n == null) {
            MutableMethodImplementation.$$$reportNull$$$0(32);
        }
        return builderInstruction11n;
    }

    @Nonnull
    private BuilderInstruction11x newBuilderInstruction11x(@Nonnull Instruction11x instruction) {
        if (instruction == null) {
            MutableMethodImplementation.$$$reportNull$$$0(33);
        }
        BuilderInstruction11x builderInstruction11x = new BuilderInstruction11x(instruction.getOpcode(), instruction.getRegisterA());
        if (builderInstruction11x == null) {
            MutableMethodImplementation.$$$reportNull$$$0(34);
        }
        return builderInstruction11x;
    }

    @Nonnull
    private BuilderInstruction12x newBuilderInstruction12x(@Nonnull Instruction12x instruction) {
        if (instruction == null) {
            MutableMethodImplementation.$$$reportNull$$$0(35);
        }
        BuilderInstruction12x builderInstruction12x = new BuilderInstruction12x(instruction.getOpcode(), instruction.getRegisterA(), instruction.getRegisterB());
        if (builderInstruction12x == null) {
            MutableMethodImplementation.$$$reportNull$$$0(36);
        }
        return builderInstruction12x;
    }

    @Nonnull
    private BuilderInstruction20bc newBuilderInstruction20bc(@Nonnull Instruction20bc instruction) {
        if (instruction == null) {
            MutableMethodImplementation.$$$reportNull$$$0(37);
        }
        BuilderInstruction20bc builderInstruction20bc = new BuilderInstruction20bc(instruction.getOpcode(), instruction.getVerificationError(), instruction.getReference());
        if (builderInstruction20bc == null) {
            MutableMethodImplementation.$$$reportNull$$$0(38);
        }
        return builderInstruction20bc;
    }

    @Nonnull
    private BuilderInstruction20t newBuilderInstruction20t(int codeAddress, int[] codeAddressToIndex, @Nonnull Instruction20t instruction) {
        if (instruction == null) {
            MutableMethodImplementation.$$$reportNull$$$0(39);
        }
        BuilderInstruction20t builderInstruction20t = new BuilderInstruction20t(instruction.getOpcode(), this.newLabel(codeAddressToIndex, codeAddress + instruction.getCodeOffset()));
        if (builderInstruction20t == null) {
            MutableMethodImplementation.$$$reportNull$$$0(40);
        }
        return builderInstruction20t;
    }

    @Nonnull
    private BuilderInstruction21c newBuilderInstruction21c(@Nonnull Instruction21c instruction) {
        if (instruction == null) {
            MutableMethodImplementation.$$$reportNull$$$0(41);
        }
        BuilderInstruction21c builderInstruction21c = new BuilderInstruction21c(instruction.getOpcode(), instruction.getRegisterA(), instruction.getReference());
        if (builderInstruction21c == null) {
            MutableMethodImplementation.$$$reportNull$$$0(42);
        }
        return builderInstruction21c;
    }

    @Nonnull
    private BuilderInstruction21ih newBuilderInstruction21ih(@Nonnull Instruction21ih instruction) {
        if (instruction == null) {
            MutableMethodImplementation.$$$reportNull$$$0(43);
        }
        BuilderInstruction21ih builderInstruction21ih = new BuilderInstruction21ih(instruction.getOpcode(), instruction.getRegisterA(), instruction.getNarrowLiteral());
        if (builderInstruction21ih == null) {
            MutableMethodImplementation.$$$reportNull$$$0(44);
        }
        return builderInstruction21ih;
    }

    @Nonnull
    private BuilderInstruction21lh newBuilderInstruction21lh(@Nonnull Instruction21lh instruction) {
        if (instruction == null) {
            MutableMethodImplementation.$$$reportNull$$$0(45);
        }
        BuilderInstruction21lh builderInstruction21lh = new BuilderInstruction21lh(instruction.getOpcode(), instruction.getRegisterA(), instruction.getWideLiteral());
        if (builderInstruction21lh == null) {
            MutableMethodImplementation.$$$reportNull$$$0(46);
        }
        return builderInstruction21lh;
    }

    @Nonnull
    private BuilderInstruction21s newBuilderInstruction21s(@Nonnull Instruction21s instruction) {
        if (instruction == null) {
            MutableMethodImplementation.$$$reportNull$$$0(47);
        }
        BuilderInstruction21s builderInstruction21s = new BuilderInstruction21s(instruction.getOpcode(), instruction.getRegisterA(), instruction.getNarrowLiteral());
        if (builderInstruction21s == null) {
            MutableMethodImplementation.$$$reportNull$$$0(48);
        }
        return builderInstruction21s;
    }

    @Nonnull
    private BuilderInstruction21t newBuilderInstruction21t(int codeAddress, int[] codeAddressToIndex, @Nonnull Instruction21t instruction) {
        if (instruction == null) {
            MutableMethodImplementation.$$$reportNull$$$0(49);
        }
        BuilderInstruction21t builderInstruction21t = new BuilderInstruction21t(instruction.getOpcode(), instruction.getRegisterA(), this.newLabel(codeAddressToIndex, codeAddress + instruction.getCodeOffset()));
        if (builderInstruction21t == null) {
            MutableMethodImplementation.$$$reportNull$$$0(50);
        }
        return builderInstruction21t;
    }

    @Nonnull
    private BuilderInstruction22b newBuilderInstruction22b(@Nonnull Instruction22b instruction) {
        if (instruction == null) {
            MutableMethodImplementation.$$$reportNull$$$0(51);
        }
        BuilderInstruction22b builderInstruction22b = new BuilderInstruction22b(instruction.getOpcode(), instruction.getRegisterA(), instruction.getRegisterB(), instruction.getNarrowLiteral());
        if (builderInstruction22b == null) {
            MutableMethodImplementation.$$$reportNull$$$0(52);
        }
        return builderInstruction22b;
    }

    @Nonnull
    private BuilderInstruction22c newBuilderInstruction22c(@Nonnull Instruction22c instruction) {
        if (instruction == null) {
            MutableMethodImplementation.$$$reportNull$$$0(53);
        }
        BuilderInstruction22c builderInstruction22c = new BuilderInstruction22c(instruction.getOpcode(), instruction.getRegisterA(), instruction.getRegisterB(), instruction.getReference());
        if (builderInstruction22c == null) {
            MutableMethodImplementation.$$$reportNull$$$0(54);
        }
        return builderInstruction22c;
    }

    @Nonnull
    private BuilderInstruction22s newBuilderInstruction22s(@Nonnull Instruction22s instruction) {
        if (instruction == null) {
            MutableMethodImplementation.$$$reportNull$$$0(55);
        }
        BuilderInstruction22s builderInstruction22s = new BuilderInstruction22s(instruction.getOpcode(), instruction.getRegisterA(), instruction.getRegisterB(), instruction.getNarrowLiteral());
        if (builderInstruction22s == null) {
            MutableMethodImplementation.$$$reportNull$$$0(56);
        }
        return builderInstruction22s;
    }

    @Nonnull
    private BuilderInstruction22t newBuilderInstruction22t(int codeAddress, int[] codeAddressToIndex, @Nonnull Instruction22t instruction) {
        if (instruction == null) {
            MutableMethodImplementation.$$$reportNull$$$0(57);
        }
        BuilderInstruction22t builderInstruction22t = new BuilderInstruction22t(instruction.getOpcode(), instruction.getRegisterA(), instruction.getRegisterB(), this.newLabel(codeAddressToIndex, codeAddress + instruction.getCodeOffset()));
        if (builderInstruction22t == null) {
            MutableMethodImplementation.$$$reportNull$$$0(58);
        }
        return builderInstruction22t;
    }

    @Nonnull
    private BuilderInstruction22x newBuilderInstruction22x(@Nonnull Instruction22x instruction) {
        if (instruction == null) {
            MutableMethodImplementation.$$$reportNull$$$0(59);
        }
        BuilderInstruction22x builderInstruction22x = new BuilderInstruction22x(instruction.getOpcode(), instruction.getRegisterA(), instruction.getRegisterB());
        if (builderInstruction22x == null) {
            MutableMethodImplementation.$$$reportNull$$$0(60);
        }
        return builderInstruction22x;
    }

    @Nonnull
    private BuilderInstruction23x newBuilderInstruction23x(@Nonnull Instruction23x instruction) {
        if (instruction == null) {
            MutableMethodImplementation.$$$reportNull$$$0(61);
        }
        BuilderInstruction23x builderInstruction23x = new BuilderInstruction23x(instruction.getOpcode(), instruction.getRegisterA(), instruction.getRegisterB(), instruction.getRegisterC());
        if (builderInstruction23x == null) {
            MutableMethodImplementation.$$$reportNull$$$0(62);
        }
        return builderInstruction23x;
    }

    @Nonnull
    private BuilderInstruction30t newBuilderInstruction30t(int codeAddress, int[] codeAddressToIndex, @Nonnull Instruction30t instruction) {
        if (instruction == null) {
            MutableMethodImplementation.$$$reportNull$$$0(63);
        }
        BuilderInstruction30t builderInstruction30t = new BuilderInstruction30t(instruction.getOpcode(), this.newLabel(codeAddressToIndex, codeAddress + instruction.getCodeOffset()));
        if (builderInstruction30t == null) {
            MutableMethodImplementation.$$$reportNull$$$0(64);
        }
        return builderInstruction30t;
    }

    @Nonnull
    private BuilderInstruction31c newBuilderInstruction31c(@Nonnull Instruction31c instruction) {
        if (instruction == null) {
            MutableMethodImplementation.$$$reportNull$$$0(65);
        }
        BuilderInstruction31c builderInstruction31c = new BuilderInstruction31c(instruction.getOpcode(), instruction.getRegisterA(), instruction.getReference());
        if (builderInstruction31c == null) {
            MutableMethodImplementation.$$$reportNull$$$0(66);
        }
        return builderInstruction31c;
    }

    @Nonnull
    private BuilderInstruction31i newBuilderInstruction31i(@Nonnull Instruction31i instruction) {
        if (instruction == null) {
            MutableMethodImplementation.$$$reportNull$$$0(67);
        }
        BuilderInstruction31i builderInstruction31i = new BuilderInstruction31i(instruction.getOpcode(), instruction.getRegisterA(), instruction.getNarrowLiteral());
        if (builderInstruction31i == null) {
            MutableMethodImplementation.$$$reportNull$$$0(68);
        }
        return builderInstruction31i;
    }

    @Nonnull
    private BuilderInstruction31t newBuilderInstruction31t(@Nonnull MethodLocation location, int[] codeAddressToIndex, @Nonnull Instruction31t instruction) {
        if (location == null) {
            MutableMethodImplementation.$$$reportNull$$$0(69);
        }
        if (instruction == null) {
            MutableMethodImplementation.$$$reportNull$$$0(70);
        }
        int codeAddress = location.getCodeAddress();
        Label newLabel = instruction.getOpcode() != Opcode.FILL_ARRAY_DATA ? this.newSwitchPayloadReferenceLabel(location, codeAddressToIndex, codeAddress + instruction.getCodeOffset()) : this.newLabel(codeAddressToIndex, codeAddress + instruction.getCodeOffset());
        BuilderInstruction31t builderInstruction31t = new BuilderInstruction31t(instruction.getOpcode(), instruction.getRegisterA(), newLabel);
        if (builderInstruction31t == null) {
            MutableMethodImplementation.$$$reportNull$$$0(71);
        }
        return builderInstruction31t;
    }

    @Nonnull
    private BuilderInstruction32x newBuilderInstruction32x(@Nonnull Instruction32x instruction) {
        if (instruction == null) {
            MutableMethodImplementation.$$$reportNull$$$0(72);
        }
        BuilderInstruction32x builderInstruction32x = new BuilderInstruction32x(instruction.getOpcode(), instruction.getRegisterA(), instruction.getRegisterB());
        if (builderInstruction32x == null) {
            MutableMethodImplementation.$$$reportNull$$$0(73);
        }
        return builderInstruction32x;
    }

    @Nonnull
    private BuilderInstruction35c newBuilderInstruction35c(@Nonnull Instruction35c instruction) {
        if (instruction == null) {
            MutableMethodImplementation.$$$reportNull$$$0(74);
        }
        BuilderInstruction35c builderInstruction35c = new BuilderInstruction35c(instruction.getOpcode(), instruction.getRegisterCount(), instruction.getRegisterC(), instruction.getRegisterD(), instruction.getRegisterE(), instruction.getRegisterF(), instruction.getRegisterG(), instruction.getReference());
        if (builderInstruction35c == null) {
            MutableMethodImplementation.$$$reportNull$$$0(75);
        }
        return builderInstruction35c;
    }

    @Nonnull
    private BuilderInstruction3rc newBuilderInstruction3rc(@Nonnull Instruction3rc instruction) {
        if (instruction == null) {
            MutableMethodImplementation.$$$reportNull$$$0(76);
        }
        BuilderInstruction3rc builderInstruction3rc = new BuilderInstruction3rc(instruction.getOpcode(), instruction.getStartRegister(), instruction.getRegisterCount(), instruction.getReference());
        if (builderInstruction3rc == null) {
            MutableMethodImplementation.$$$reportNull$$$0(77);
        }
        return builderInstruction3rc;
    }

    @Nonnull
    private BuilderInstruction51l newBuilderInstruction51l(@Nonnull Instruction51l instruction) {
        if (instruction == null) {
            MutableMethodImplementation.$$$reportNull$$$0(78);
        }
        BuilderInstruction51l builderInstruction51l = new BuilderInstruction51l(instruction.getOpcode(), instruction.getRegisterA(), instruction.getWideLiteral());
        if (builderInstruction51l == null) {
            MutableMethodImplementation.$$$reportNull$$$0(79);
        }
        return builderInstruction51l;
    }

    @Nullable
    private MethodLocation findSwitchForPayload(@Nonnull MethodLocation payloadLocation) {
        if (payloadLocation == null) {
            MutableMethodImplementation.$$$reportNull$$$0(80);
        }
        MethodLocation location = payloadLocation;
        MethodLocation switchLocation = null;
        do {
            for (Label label : location.getLabels()) {
                if (!(label instanceof SwitchPayloadReferenceLabel)) continue;
                if (switchLocation != null) {
                    throw new IllegalStateException("Multiple switch instructions refer to the same payload. This is not currently supported. Please file a bug :)");
                }
                switchLocation = ((SwitchPayloadReferenceLabel)label).switchLocation;
            }
            if (location.index == 0) {
                return switchLocation;
            }
            location = this.instructionList.get(location.index - 1);
        } while (location.instruction != null && location.instruction.getOpcode() == Opcode.NOP);
        return switchLocation;
    }

    @Nonnull
    private BuilderPackedSwitchPayload newBuilderPackedSwitchPayload(@Nonnull MethodLocation location, @Nonnull int[] codeAddressToIndex, @Nonnull PackedSwitchPayload instruction) {
        List<? extends SwitchElement> switchElements;
        if (location == null) {
            MutableMethodImplementation.$$$reportNull$$$0(81);
        }
        if (codeAddressToIndex == null) {
            MutableMethodImplementation.$$$reportNull$$$0(82);
        }
        if (instruction == null) {
            MutableMethodImplementation.$$$reportNull$$$0(83);
        }
        if ((switchElements = instruction.getSwitchElements()).size() == 0) {
            BuilderPackedSwitchPayload builderPackedSwitchPayload = new BuilderPackedSwitchPayload(0, null);
            if (builderPackedSwitchPayload == null) {
                MutableMethodImplementation.$$$reportNull$$$0(84);
            }
            return builderPackedSwitchPayload;
        }
        MethodLocation switchLocation = this.findSwitchForPayload(location);
        int baseAddress = switchLocation == null ? 0 : switchLocation.codeAddress;
        ArrayList<Label> labels = Lists.newArrayList();
        for (SwitchElement switchElement : switchElements) {
            labels.add(this.newLabel(codeAddressToIndex, switchElement.getOffset() + baseAddress));
        }
        BuilderPackedSwitchPayload builderPackedSwitchPayload = new BuilderPackedSwitchPayload(switchElements.get(0).getKey(), labels);
        if (builderPackedSwitchPayload == null) {
            MutableMethodImplementation.$$$reportNull$$$0(85);
        }
        return builderPackedSwitchPayload;
    }

    @Nonnull
    private BuilderSparseSwitchPayload newBuilderSparseSwitchPayload(@Nonnull MethodLocation location, @Nonnull int[] codeAddressToIndex, @Nonnull SparseSwitchPayload instruction) {
        List<? extends SwitchElement> switchElements;
        if (location == null) {
            MutableMethodImplementation.$$$reportNull$$$0(86);
        }
        if (codeAddressToIndex == null) {
            MutableMethodImplementation.$$$reportNull$$$0(87);
        }
        if (instruction == null) {
            MutableMethodImplementation.$$$reportNull$$$0(88);
        }
        if ((switchElements = instruction.getSwitchElements()).size() == 0) {
            BuilderSparseSwitchPayload builderSparseSwitchPayload = new BuilderSparseSwitchPayload(null);
            if (builderSparseSwitchPayload == null) {
                MutableMethodImplementation.$$$reportNull$$$0(89);
            }
            return builderSparseSwitchPayload;
        }
        MethodLocation switchLocation = this.findSwitchForPayload(location);
        int baseAddress = switchLocation == null ? 0 : switchLocation.codeAddress;
        ArrayList<SwitchLabelElement> labelElements = Lists.newArrayList();
        for (SwitchElement switchElement : switchElements) {
            labelElements.add(new SwitchLabelElement(switchElement.getKey(), this.newLabel(codeAddressToIndex, switchElement.getOffset() + baseAddress)));
        }
        BuilderSparseSwitchPayload builderSparseSwitchPayload = new BuilderSparseSwitchPayload(labelElements);
        if (builderSparseSwitchPayload == null) {
            MutableMethodImplementation.$$$reportNull$$$0(90);
        }
        return builderSparseSwitchPayload;
    }

    @Nonnull
    private BuilderArrayPayload newBuilderArrayPayload(@Nonnull ArrayPayload instruction) {
        if (instruction == null) {
            MutableMethodImplementation.$$$reportNull$$$0(91);
        }
        BuilderArrayPayload builderArrayPayload = new BuilderArrayPayload(instruction.getElementWidth(), instruction.getArrayElements());
        if (builderArrayPayload == null) {
            MutableMethodImplementation.$$$reportNull$$$0(92);
        }
        return builderArrayPayload;
    }

    @Nonnull
    private BuilderDebugItem convertDebugItem(@Nonnull DebugItem debugItem) {
        if (debugItem == null) {
            MutableMethodImplementation.$$$reportNull$$$0(93);
        }
        switch (debugItem.getDebugItemType()) {
            case 3: {
                StartLocal startLocal = (StartLocal)debugItem;
                BuilderStartLocal builderStartLocal = new BuilderStartLocal(startLocal.getRegister(), startLocal.getNameReference(), startLocal.getTypeReference(), startLocal.getSignatureReference());
                if (builderStartLocal == null) {
                    MutableMethodImplementation.$$$reportNull$$$0(94);
                }
                return builderStartLocal;
            }
            case 5: {
                EndLocal endLocal = (EndLocal)debugItem;
                BuilderEndLocal builderEndLocal = new BuilderEndLocal(endLocal.getRegister());
                if (builderEndLocal == null) {
                    MutableMethodImplementation.$$$reportNull$$$0(95);
                }
                return builderEndLocal;
            }
            case 6: {
                RestartLocal restartLocal = (RestartLocal)debugItem;
                BuilderRestartLocal builderRestartLocal = new BuilderRestartLocal(restartLocal.getRegister());
                if (builderRestartLocal == null) {
                    MutableMethodImplementation.$$$reportNull$$$0(96);
                }
                return builderRestartLocal;
            }
            case 7: {
                BuilderPrologueEnd builderPrologueEnd = new BuilderPrologueEnd();
                if (builderPrologueEnd == null) {
                    MutableMethodImplementation.$$$reportNull$$$0(97);
                }
                return builderPrologueEnd;
            }
            case 8: {
                BuilderEpilogueBegin builderEpilogueBegin = new BuilderEpilogueBegin();
                if (builderEpilogueBegin == null) {
                    MutableMethodImplementation.$$$reportNull$$$0(98);
                }
                return builderEpilogueBegin;
            }
            case 10: {
                LineNumber lineNumber = (LineNumber)debugItem;
                BuilderLineNumber builderLineNumber = new BuilderLineNumber(lineNumber.getLineNumber());
                if (builderLineNumber == null) {
                    MutableMethodImplementation.$$$reportNull$$$0(99);
                }
                return builderLineNumber;
            }
            case 9: {
                SetSourceFile setSourceFile = (SetSourceFile)debugItem;
                BuilderSetSourceFile builderSetSourceFile = new BuilderSetSourceFile(setSourceFile.getSourceFileReference());
                if (builderSetSourceFile == null) {
                    MutableMethodImplementation.$$$reportNull$$$0(100);
                }
                return builderSetSourceFile;
            }
        }
        throw new ExceptionWithContext("Invalid debug item type: " + debugItem.getDebugItemType(), new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 16: 
            case 17: 
            case 19: 
            case 22: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 58: 
            case 60: 
            case 62: 
            case 64: 
            case 66: 
            case 68: 
            case 71: 
            case 73: 
            case 75: 
            case 77: 
            case 79: 
            case 84: 
            case 85: 
            case 89: 
            case 90: 
            case 92: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 16: 
            case 17: 
            case 19: 
            case 22: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 58: 
            case 60: 
            case 62: 
            case 64: 
            case 66: 
            case 68: 
            case 71: 
            case 73: 
            case 75: 
            case 77: 
            case 79: 
            case 84: 
            case 85: 
            case 89: 
            case 90: 
            case 92: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodImplementation";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 16: 
            case 17: 
            case 19: 
            case 22: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 58: 
            case 60: 
            case 62: 
            case 64: 
            case 66: 
            case 68: 
            case 71: 
            case 73: 
            case 75: 
            case 77: 
            case 79: 
            case 84: 
            case 85: 
            case 89: 
            case 90: 
            case 92: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jf/dexlib2/builder/MutableMethodImplementation";
                break;
            }
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 13: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 53: 
            case 55: 
            case 57: 
            case 59: 
            case 61: 
            case 63: 
            case 65: 
            case 67: 
            case 70: 
            case 72: 
            case 74: 
            case 76: 
            case 78: 
            case 83: 
            case 88: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacementInstruction";
                break;
            }
            case 15: 
            case 18: 
            case 21: 
            case 82: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeAddressToIndex";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchLocation";
                break;
            }
            case 23: 
            case 25: 
            case 69: 
            case 81: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "payloadLocation";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugItem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jf/dexlib2/builder/MutableMethodImplementation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstructions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTryBlocks";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugItems";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "newLabelForAddress";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "newLabelForIndex";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "newLabel";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "newSwitchPayloadReferenceLabel";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "newBuilderInstruction10t";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "newBuilderInstruction10x";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "newBuilderInstruction11n";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "newBuilderInstruction11x";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "newBuilderInstruction12x";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "newBuilderInstruction20bc";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "newBuilderInstruction20t";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "newBuilderInstruction21c";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "newBuilderInstruction21ih";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "newBuilderInstruction21lh";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "newBuilderInstruction21s";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "newBuilderInstruction21t";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "newBuilderInstruction22b";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "newBuilderInstruction22c";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "newBuilderInstruction22s";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "newBuilderInstruction22t";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "newBuilderInstruction22x";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "newBuilderInstruction23x";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "newBuilderInstruction30t";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "newBuilderInstruction31c";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "newBuilderInstruction31i";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "newBuilderInstruction31t";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "newBuilderInstruction32x";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "newBuilderInstruction35c";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "newBuilderInstruction3rc";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "newBuilderInstruction51l";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "newBuilderPackedSwitchPayload";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "newBuilderSparseSwitchPayload";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "newBuilderArrayPayload";
                break;
            }
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: {
                objectArray = objectArray2;
                objectArray2[1] = "convertDebugItem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 16: 
            case 17: 
            case 19: 
            case 22: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 58: 
            case 60: 
            case 62: 
            case 64: 
            case 66: 
            case 68: 
            case 71: 
            case 73: 
            case 75: 
            case 77: 
            case 79: 
            case 84: 
            case 85: 
            case 89: 
            case 90: 
            case 92: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addCatch";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addInstruction";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "replaceInstruction";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "mapCodeAddressToIndex";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "newLabel";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "newSwitchPayloadReferenceLabel";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setInstruction";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "convertAndSetInstruction";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "newBuilderInstruction10t";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "newBuilderInstruction10x";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "newBuilderInstruction11n";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "newBuilderInstruction11x";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "newBuilderInstruction12x";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "newBuilderInstruction20bc";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "newBuilderInstruction20t";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "newBuilderInstruction21c";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "newBuilderInstruction21ih";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "newBuilderInstruction21lh";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "newBuilderInstruction21s";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "newBuilderInstruction21t";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "newBuilderInstruction22b";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "newBuilderInstruction22c";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "newBuilderInstruction22s";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "newBuilderInstruction22t";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "newBuilderInstruction22x";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "newBuilderInstruction23x";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "newBuilderInstruction30t";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "newBuilderInstruction31c";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "newBuilderInstruction31i";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "newBuilderInstruction31t";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "newBuilderInstruction32x";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "newBuilderInstruction35c";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "newBuilderInstruction3rc";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "newBuilderInstruction51l";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "findSwitchForPayload";
                break;
            }
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "newBuilderPackedSwitchPayload";
                break;
            }
            case 86: 
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "newBuilderSparseSwitchPayload";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "newBuilderArrayPayload";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "convertDebugItem";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 16: 
            case 17: 
            case 19: 
            case 22: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 58: 
            case 60: 
            case 62: 
            case 64: 
            case 66: 
            case 68: 
            case 71: 
            case 73: 
            case 75: 
            case 77: 
            case 79: 
            case 84: 
            case 85: 
            case 89: 
            case 90: 
            case 92: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SwitchPayloadReferenceLabel
    extends Label {
        @Nonnull
        public MethodLocation switchLocation;

        private SwitchPayloadReferenceLabel() {
        }
    }

    private static interface Task {
        public void perform();
    }
}

