/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.builder;

import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.builder.BuilderInstruction;
import org.jf.dexlib2.builder.Label;
import org.jf.dexlib2.builder.MethodLocation;
import org.jf.dexlib2.builder.MutableMethodImplementation;
import org.jf.dexlib2.iface.MethodImplementation;
import org.jf.dexlib2.iface.reference.StringReference;
import org.jf.dexlib2.iface.reference.TypeReference;

public class MethodImplementationBuilder {
    private final HashMap<String, Label> labels = new HashMap();
    @Nonnull
    private final MutableMethodImplementation impl;
    private MethodLocation currentLocation;

    public MethodImplementationBuilder(int registerCount) {
        this.impl = new MutableMethodImplementation(registerCount);
        this.currentLocation = this.impl.instructionList.get(0);
    }

    public MethodImplementation getMethodImplementation() {
        return this.impl;
    }

    @Nonnull
    public Label addLabel(@Nonnull String name) {
        Label label;
        if (name == null) {
            MethodImplementationBuilder.$$$reportNull$$$0(0);
        }
        if ((label = this.labels.get(name)) != null) {
            if (label.isPlaced()) {
                throw new IllegalArgumentException("There is already a label with that name.");
            }
            this.currentLocation.getLabels().add(label);
        } else {
            label = this.currentLocation.addNewLabel();
            this.labels.put(name, label);
        }
        Label label2 = label;
        if (label2 == null) {
            MethodImplementationBuilder.$$$reportNull$$$0(1);
        }
        return label2;
    }

    @Nonnull
    public Label getLabel(@Nonnull String name) {
        Label label;
        if (name == null) {
            MethodImplementationBuilder.$$$reportNull$$$0(2);
        }
        if ((label = this.labels.get(name)) == null) {
            label = new Label();
            this.labels.put(name, label);
        }
        Label label2 = label;
        if (label2 == null) {
            MethodImplementationBuilder.$$$reportNull$$$0(3);
        }
        return label2;
    }

    public void addCatch(@Nullable TypeReference type, @Nonnull Label from, @Nonnull Label to, @Nonnull Label handler) {
        if (from == null) {
            MethodImplementationBuilder.$$$reportNull$$$0(4);
        }
        if (to == null) {
            MethodImplementationBuilder.$$$reportNull$$$0(5);
        }
        if (handler == null) {
            MethodImplementationBuilder.$$$reportNull$$$0(6);
        }
        this.impl.addCatch(type, from, to, handler);
    }

    public void addCatch(@Nullable String type, @Nonnull Label from, @Nonnull Label to, @Nonnull Label handler) {
        if (from == null) {
            MethodImplementationBuilder.$$$reportNull$$$0(7);
        }
        if (to == null) {
            MethodImplementationBuilder.$$$reportNull$$$0(8);
        }
        if (handler == null) {
            MethodImplementationBuilder.$$$reportNull$$$0(9);
        }
        this.impl.addCatch(type, from, to, handler);
    }

    public void addCatch(@Nonnull Label from, @Nonnull Label to, @Nonnull Label handler) {
        if (from == null) {
            MethodImplementationBuilder.$$$reportNull$$$0(10);
        }
        if (to == null) {
            MethodImplementationBuilder.$$$reportNull$$$0(11);
        }
        if (handler == null) {
            MethodImplementationBuilder.$$$reportNull$$$0(12);
        }
        this.impl.addCatch(from, to, handler);
    }

    public void addLineNumber(int lineNumber) {
        this.currentLocation.addLineNumber(lineNumber);
    }

    public void addStartLocal(int registerNumber, @Nullable StringReference name, @Nullable TypeReference type, @Nullable StringReference signature) {
        this.currentLocation.addStartLocal(registerNumber, name, type, signature);
    }

    public void addEndLocal(int registerNumber) {
        this.currentLocation.addEndLocal(registerNumber);
    }

    public void addRestartLocal(int registerNumber) {
        this.currentLocation.addRestartLocal(registerNumber);
    }

    public void addPrologue() {
        this.currentLocation.addPrologue();
    }

    public void addEpilogue() {
        this.currentLocation.addEpilogue();
    }

    public void addSetSourceFile(@Nullable StringReference sourceFile) {
        this.currentLocation.addSetSourceFile(sourceFile);
    }

    public void addInstruction(@Nullable BuilderInstruction instruction) {
        this.impl.addInstruction(instruction);
        this.currentLocation = this.impl.instructionList.get(this.impl.instructionList.size() - 1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jf/dexlib2/builder/MethodImplementationBuilder";
                break;
            }
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jf/dexlib2/builder/MethodImplementationBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "addLabel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addLabel";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLabel";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addCatch";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

