/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.analysis.reflection;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.analysis.reflection.ReflectionConstructor;
import org.jf.dexlib2.analysis.reflection.ReflectionField;
import org.jf.dexlib2.analysis.reflection.ReflectionMethod;
import org.jf.dexlib2.analysis.reflection.util.ReflectionUtils;
import org.jf.dexlib2.base.reference.BaseTypeReference;
import org.jf.dexlib2.iface.Annotation;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.Method;

public class ReflectionClassDef
extends BaseTypeReference
implements ClassDef {
    private final Class cls;
    private static final int DIRECT_MODIFIERS = 10;

    public ReflectionClassDef(Class cls) {
        this.cls = cls;
    }

    @Override
    public int getAccessFlags() {
        return this.cls.getModifiers();
    }

    @Override
    @Nullable
    public String getSuperclass() {
        if (Modifier.isInterface(this.cls.getModifiers())) {
            return "Ljava/lang/Object;";
        }
        Class superClass = this.cls.getSuperclass();
        if (superClass == null) {
            return null;
        }
        return ReflectionUtils.javaToDexName(superClass.getName());
    }

    @Override
    @Nonnull
    public List<String> getInterfaces() {
        ImmutableList<String> immutableList = ImmutableList.copyOf(Iterators.transform(Iterators.forArray(this.cls.getInterfaces()), new Function<Class, String>(){

            @Override
            @Nullable
            public String apply(@Nullable Class input) {
                if (input == null) {
                    return null;
                }
                return ReflectionUtils.javaToDexName(input.getName());
            }
        }));
        if (immutableList == null) {
            ReflectionClassDef.$$$reportNull$$$0(0);
        }
        return immutableList;
    }

    @Override
    @Nullable
    public String getSourceFile() {
        return null;
    }

    @Override
    @Nonnull
    public Set<? extends Annotation> getAnnotations() {
        ImmutableSet immutableSet = ImmutableSet.of();
        if (immutableSet == null) {
            ReflectionClassDef.$$$reportNull$$$0(1);
        }
        return immutableSet;
    }

    @Override
    @Nonnull
    public Iterable<? extends org.jf.dexlib2.iface.Field> getStaticFields() {
        Iterable<org.jf.dexlib2.iface.Field> iterable = new Iterable<org.jf.dexlib2.iface.Field>(){

            @Override
            @Nonnull
            public Iterator<org.jf.dexlib2.iface.Field> iterator() {
                UnmodifiableIterator<Field> staticFields = Iterators.filter(Iterators.forArray(ReflectionClassDef.this.cls.getDeclaredFields()), new Predicate<Field>(){

                    @Override
                    public boolean apply(@Nullable Field input) {
                        return input != null && Modifier.isStatic(input.getModifiers());
                    }
                });
                Iterator<org.jf.dexlib2.iface.Field> iterator = Iterators.transform(staticFields, new Function<Field, org.jf.dexlib2.iface.Field>(){

                    @Override
                    @Nullable
                    public org.jf.dexlib2.iface.Field apply(@Nullable Field input) {
                        return new ReflectionField(input);
                    }
                });
                if (iterator == null) {
                    2.$$$reportNull$$$0(0);
                }
                return iterator;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@Nonnull method %s.%s must not return null", "org/jf/dexlib2/analysis/reflection/ReflectionClassDef$2", "iterator"));
            }
        };
        if (iterable == null) {
            ReflectionClassDef.$$$reportNull$$$0(2);
        }
        return iterable;
    }

    @Override
    @Nonnull
    public Iterable<? extends org.jf.dexlib2.iface.Field> getInstanceFields() {
        Iterable<org.jf.dexlib2.iface.Field> iterable = new Iterable<org.jf.dexlib2.iface.Field>(){

            @Override
            @Nonnull
            public Iterator<org.jf.dexlib2.iface.Field> iterator() {
                UnmodifiableIterator<Field> staticFields = Iterators.filter(Iterators.forArray(ReflectionClassDef.this.cls.getDeclaredFields()), new Predicate<Field>(){

                    @Override
                    public boolean apply(@Nullable Field input) {
                        return input != null && !Modifier.isStatic(input.getModifiers());
                    }
                });
                Iterator<org.jf.dexlib2.iface.Field> iterator = Iterators.transform(staticFields, new Function<Field, org.jf.dexlib2.iface.Field>(){

                    @Override
                    @Nullable
                    public org.jf.dexlib2.iface.Field apply(@Nullable Field input) {
                        return new ReflectionField(input);
                    }
                });
                if (iterator == null) {
                    3.$$$reportNull$$$0(0);
                }
                return iterator;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@Nonnull method %s.%s must not return null", "org/jf/dexlib2/analysis/reflection/ReflectionClassDef$3", "iterator"));
            }
        };
        if (iterable == null) {
            ReflectionClassDef.$$$reportNull$$$0(3);
        }
        return iterable;
    }

    @Nonnull
    public Set<? extends org.jf.dexlib2.iface.Field> getFields() {
        AbstractSet<org.jf.dexlib2.iface.Field> abstractSet = new AbstractSet<org.jf.dexlib2.iface.Field>(){

            @Override
            @Nonnull
            public Iterator<org.jf.dexlib2.iface.Field> iterator() {
                Iterator<org.jf.dexlib2.iface.Field> iterator = Iterators.transform(Iterators.forArray(ReflectionClassDef.this.cls.getDeclaredFields()), new Function<Field, org.jf.dexlib2.iface.Field>(){

                    @Override
                    @Nullable
                    public org.jf.dexlib2.iface.Field apply(@Nullable Field input) {
                        return new ReflectionField(input);
                    }
                });
                if (iterator == null) {
                    4.$$$reportNull$$$0(0);
                }
                return iterator;
            }

            @Override
            public int size() {
                return ReflectionClassDef.this.cls.getDeclaredFields().length;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@Nonnull method %s.%s must not return null", "org/jf/dexlib2/analysis/reflection/ReflectionClassDef$4", "iterator"));
            }
        };
        if (abstractSet == null) {
            ReflectionClassDef.$$$reportNull$$$0(4);
        }
        return abstractSet;
    }

    @Override
    @Nonnull
    public Iterable<? extends Method> getDirectMethods() {
        Iterable<Method> iterable = new Iterable<Method>(){

            @Override
            @Nonnull
            public Iterator<Method> iterator() {
                Iterator<Method> constructorIterator = Iterators.transform(Iterators.forArray(ReflectionClassDef.this.cls.getDeclaredConstructors()), new Function<Constructor, Method>(){

                    @Override
                    @Nullable
                    public Method apply(@Nullable Constructor input) {
                        return new ReflectionConstructor(input);
                    }
                });
                UnmodifiableIterator<java.lang.reflect.Method> directMethods = Iterators.filter(Iterators.forArray(ReflectionClassDef.this.cls.getDeclaredMethods()), new Predicate<java.lang.reflect.Method>(){

                    @Override
                    public boolean apply(@Nullable java.lang.reflect.Method input) {
                        return input != null && (input.getModifiers() & 0xA) != 0;
                    }
                });
                Iterator<Method> methodIterator = Iterators.transform(directMethods, new Function<java.lang.reflect.Method, Method>(){

                    @Override
                    @Nullable
                    public Method apply(@Nullable java.lang.reflect.Method input) {
                        return new ReflectionMethod(input);
                    }
                });
                Iterator<Method> iterator = Iterators.concat(constructorIterator, methodIterator);
                if (iterator == null) {
                    5.$$$reportNull$$$0(0);
                }
                return iterator;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@Nonnull method %s.%s must not return null", "org/jf/dexlib2/analysis/reflection/ReflectionClassDef$5", "iterator"));
            }
        };
        if (iterable == null) {
            ReflectionClassDef.$$$reportNull$$$0(5);
        }
        return iterable;
    }

    @Override
    @Nonnull
    public Iterable<? extends Method> getVirtualMethods() {
        Iterable<Method> iterable = new Iterable<Method>(){

            @Override
            @Nonnull
            public Iterator<Method> iterator() {
                UnmodifiableIterator<java.lang.reflect.Method> directMethods = Iterators.filter(Iterators.forArray(ReflectionClassDef.this.cls.getDeclaredMethods()), new Predicate<java.lang.reflect.Method>(){

                    @Override
                    public boolean apply(@Nullable java.lang.reflect.Method input) {
                        return input != null && (input.getModifiers() & 0xA) == 0;
                    }
                });
                Iterator<Method> iterator = Iterators.transform(directMethods, new Function<java.lang.reflect.Method, Method>(){

                    @Override
                    @Nullable
                    public Method apply(@Nullable java.lang.reflect.Method input) {
                        return new ReflectionMethod(input);
                    }
                });
                if (iterator == null) {
                    6.$$$reportNull$$$0(0);
                }
                return iterator;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@Nonnull method %s.%s must not return null", "org/jf/dexlib2/analysis/reflection/ReflectionClassDef$6", "iterator"));
            }
        };
        if (iterable == null) {
            ReflectionClassDef.$$$reportNull$$$0(6);
        }
        return iterable;
    }

    @Nonnull
    public Set<? extends Method> getMethods() {
        AbstractSet<Method> abstractSet = new AbstractSet<Method>(){

            @Override
            @Nonnull
            public Iterator<Method> iterator() {
                Iterator<Method> constructorIterator = Iterators.transform(Iterators.forArray(ReflectionClassDef.this.cls.getDeclaredConstructors()), new Function<Constructor, Method>(){

                    @Override
                    @Nullable
                    public Method apply(@Nullable Constructor input) {
                        return new ReflectionConstructor(input);
                    }
                });
                Iterator<Method> methodIterator = Iterators.transform(Iterators.forArray(ReflectionClassDef.this.cls.getDeclaredMethods()), new Function<java.lang.reflect.Method, Method>(){

                    @Override
                    @Nullable
                    public Method apply(@Nullable java.lang.reflect.Method input) {
                        return new ReflectionMethod(input);
                    }
                });
                Iterator<Method> iterator = Iterators.concat(constructorIterator, methodIterator);
                if (iterator == null) {
                    7.$$$reportNull$$$0(0);
                }
                return iterator;
            }

            @Override
            public int size() {
                return ReflectionClassDef.this.cls.getDeclaredMethods().length + ReflectionClassDef.this.cls.getDeclaredConstructors().length;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@Nonnull method %s.%s must not return null", "org/jf/dexlib2/analysis/reflection/ReflectionClassDef$7", "iterator"));
            }
        };
        if (abstractSet == null) {
            ReflectionClassDef.$$$reportNull$$$0(7);
        }
        return abstractSet;
    }

    @Override
    @Nonnull
    public String getType() {
        String string = ReflectionUtils.javaToDexName(this.cls.getName());
        if (string == null) {
            ReflectionClassDef.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jf/dexlib2/analysis/reflection/ReflectionClassDef";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterfaces";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotations";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStaticFields";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstanceFields";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFields";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectMethods";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualMethods";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethods";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        throw new IllegalStateException(String.format("@Nonnull method %s.%s must not return null", objectArray));
    }
}

