/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.analysis;

import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.jf.dexlib2.analysis.AnalyzedInstruction;
import org.jf.dexlib2.analysis.ClassPath;
import org.jf.dexlib2.analysis.ClassProto;
import org.jf.dexlib2.analysis.InlineMethodResolver;
import org.jf.dexlib2.analysis.TypeProto;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.Method;
import org.jf.dexlib2.iface.instruction.InlineIndexInstruction;
import org.jf.dexlib2.immutable.ImmutableMethod;
import org.jf.dexlib2.immutable.ImmutableMethodParameter;
import org.jf.dexlib2.immutable.reference.ImmutableMethodReference;
import org.jf.dexlib2.immutable.util.ParamUtil;

public class CustomInlineMethodResolver
extends InlineMethodResolver {
    @Nonnull
    private final ClassPath classPath;
    @Nonnull
    private final Method[] inlineMethods;
    private static final Pattern longMethodPattern = Pattern.compile("(L[^;]+;)->([^(]+)\\(([^)]*)\\)(.+)");

    public CustomInlineMethodResolver(@Nonnull ClassPath classPath, @Nonnull String inlineTable) {
        if (classPath == null) {
            CustomInlineMethodResolver.$$$reportNull$$$0(0);
        }
        if (inlineTable == null) {
            CustomInlineMethodResolver.$$$reportNull$$$0(1);
        }
        this.classPath = classPath;
        StringReader reader = new StringReader(inlineTable);
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader br = new BufferedReader(reader);
        try {
            String line = br.readLine();
            while (line != null) {
                if (line.length() > 0) {
                    lines.add(line);
                }
                line = br.readLine();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Error while parsing inline table", ex);
        }
        this.inlineMethods = new Method[lines.size()];
        for (int i = 0; i < this.inlineMethods.length; ++i) {
            this.inlineMethods[i] = this.parseAndResolveInlineMethod((String)lines.get(i));
        }
    }

    public CustomInlineMethodResolver(@Nonnull ClassPath classPath, @Nonnull File inlineTable) throws IOException {
        if (classPath == null) {
            CustomInlineMethodResolver.$$$reportNull$$$0(2);
        }
        if (inlineTable == null) {
            CustomInlineMethodResolver.$$$reportNull$$$0(3);
        }
        this(classPath, Files.toString(inlineTable, Charset.forName("UTF-8")));
    }

    @Override
    @Nonnull
    public Method resolveExecuteInline(@Nonnull AnalyzedInstruction analyzedInstruction) {
        InlineIndexInstruction instruction;
        int methodIndex;
        if (analyzedInstruction == null) {
            CustomInlineMethodResolver.$$$reportNull$$$0(4);
        }
        if ((methodIndex = (instruction = (InlineIndexInstruction)analyzedInstruction.instruction).getInlineIndex()) < 0 || methodIndex >= this.inlineMethods.length) {
            throw new RuntimeException("Invalid method index: " + methodIndex);
        }
        Method method = this.inlineMethods[methodIndex];
        if (method == null) {
            CustomInlineMethodResolver.$$$reportNull$$$0(5);
        }
        return method;
    }

    @Nonnull
    private Method parseAndResolveInlineMethod(@Nonnull String inlineMethod) {
        Matcher m;
        if (inlineMethod == null) {
            CustomInlineMethodResolver.$$$reportNull$$$0(6);
        }
        if (!(m = longMethodPattern.matcher(inlineMethod)).matches()) {
            assert (false);
            throw new RuntimeException("Invalid method descriptor: " + inlineMethod);
        }
        String className = m.group(1);
        String methodName = m.group(2);
        Iterable<ImmutableMethodParameter> methodParams = ParamUtil.parseParamString(m.group(3));
        String methodRet = m.group(4);
        ImmutableMethodReference methodRef = new ImmutableMethodReference(className, methodName, methodParams, methodRet);
        int accessFlags = 0;
        boolean resolved = false;
        TypeProto typeProto = this.classPath.getClass(className);
        if (typeProto instanceof ClassProto) {
            ClassDef classDef = ((ClassProto)typeProto).getClassDef();
            for (Method method : classDef.getMethods()) {
                if (!method.equals(methodRef)) continue;
                resolved = true;
                accessFlags = method.getAccessFlags();
                break;
            }
        }
        if (!resolved) {
            throw new RuntimeException("Cannot resolve inline method: " + inlineMethod);
        }
        ImmutableMethod immutableMethod = new ImmutableMethod(className, methodName, methodParams, methodRet, accessFlags, null, null);
        if (immutableMethod == null) {
            CustomInlineMethodResolver.$$$reportNull$$$0(7);
        }
        return immutableMethod;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classPath";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inlineTable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "analyzedInstruction";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jf/dexlib2/analysis/CustomInlineMethodResolver";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inlineMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jf/dexlib2/analysis/CustomInlineMethodResolver";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveExecuteInline";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "parseAndResolveInlineMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolveExecuteInline";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseAndResolveInlineMethod";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

