/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.AccessFlags;
import org.jf.dexlib2.analysis.AnalyzedMethodUtil;
import org.jf.dexlib2.analysis.ClassPath;
import org.jf.dexlib2.analysis.TypeProto;
import org.jf.dexlib2.analysis.UnresolvedClassException;
import org.jf.dexlib2.analysis.util.TypeProtoUtils;
import org.jf.dexlib2.base.reference.BaseMethodReference;
import org.jf.dexlib2.iface.Annotation;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.Field;
import org.jf.dexlib2.iface.Method;
import org.jf.dexlib2.iface.MethodImplementation;
import org.jf.dexlib2.iface.MethodParameter;
import org.jf.dexlib2.iface.reference.FieldReference;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.util.MethodUtil;
import org.jf.util.AlignmentUtils;
import org.jf.util.ExceptionWithContext;
import org.jf.util.SparseArray;

public class ClassProto
implements TypeProto {
    private static final byte REFERENCE = 0;
    private static final byte WIDE = 1;
    private static final byte OTHER = 2;
    @Nonnull
    protected final ClassPath classPath;
    @Nonnull
    protected final String type;
    protected boolean vtableFullyResolved;
    protected boolean interfacesFullyResolved;
    protected Set<String> unresolvedInterfaces;
    @Nonnull
    private final Supplier<ClassDef> classDefSupplier;
    @Nonnull
    private final Supplier<LinkedHashMap<String, ClassDef>> preDefaultMethodInterfaceSupplier;
    @Nonnull
    private final Supplier<LinkedHashMap<String, ClassDef>> postDefaultMethodInterfaceSupplier;
    @Nonnull
    private final Supplier<SparseArray<FieldReference>> dalvikInstanceFieldsSupplier;
    @Nonnull
    private final Supplier<SparseArray<FieldReference>> artInstanceFieldsSupplier;
    @Nonnull
    private final Supplier<List<Method>> preDefaultMethodVtableSupplier;
    @Nonnull
    private final Supplier<List<Method>> buggyPostDefaultMethodVtableSupplier;
    @Nonnull
    private final Supplier<List<Method>> postDefaultMethodVtableSupplier;

    public ClassProto(@Nonnull ClassPath classPath, @Nonnull String type) {
        if (classPath == null) {
            ClassProto.$$$reportNull$$$0(0);
        }
        if (type == null) {
            ClassProto.$$$reportNull$$$0(1);
        }
        this.vtableFullyResolved = true;
        this.interfacesFullyResolved = true;
        this.unresolvedInterfaces = null;
        this.classDefSupplier = Suppliers.memoize(new Supplier<ClassDef>(){

            @Override
            public ClassDef get() {
                return ClassProto.this.classPath.getClassDef(ClassProto.this.type);
            }
        });
        this.preDefaultMethodInterfaceSupplier = Suppliers.memoize(new Supplier<LinkedHashMap<String, ClassDef>>(){

            @Override
            public LinkedHashMap<String, ClassDef> get() {
                HashSet<String> unresolvedInterfaces = new HashSet<String>(0);
                LinkedHashMap<String, ClassDef> interfaces = Maps.newLinkedHashMap();
                try {
                    for (String interfaceType : ClassProto.this.getClassDef().getInterfaces()) {
                        if (interfaces.containsKey(interfaceType)) continue;
                        try {
                            ClassDef interfaceDef = ClassProto.this.classPath.getClassDef(interfaceType);
                            interfaces.put(interfaceType, interfaceDef);
                        }
                        catch (UnresolvedClassException ex) {
                            interfaces.put(interfaceType, null);
                            unresolvedInterfaces.add(interfaceType);
                            ClassProto.this.interfacesFullyResolved = false;
                        }
                        ClassProto interfaceProto = (ClassProto)ClassProto.this.classPath.getClass(interfaceType);
                        for (String superInterface : interfaceProto.getInterfaces().keySet()) {
                            if (interfaces.containsKey(superInterface)) continue;
                            interfaces.put(superInterface, interfaceProto.getInterfaces().get(superInterface));
                        }
                        if (interfaceProto.interfacesFullyResolved) continue;
                        unresolvedInterfaces.addAll(interfaceProto.getUnresolvedInterfaces());
                        ClassProto.this.interfacesFullyResolved = false;
                    }
                }
                catch (UnresolvedClassException ex) {
                    interfaces.put(ClassProto.this.type, null);
                    unresolvedInterfaces.add(ClassProto.this.type);
                    ClassProto.this.interfacesFullyResolved = false;
                }
                if (ClassProto.this.isInterface() && !interfaces.containsKey(ClassProto.this.getType())) {
                    interfaces.put(ClassProto.this.getType(), null);
                }
                String superclass = ClassProto.this.getSuperclass();
                try {
                    if (superclass != null) {
                        ClassProto superclassProto = (ClassProto)ClassProto.this.classPath.getClass(superclass);
                        for (String superclassInterface : superclassProto.getInterfaces().keySet()) {
                            if (interfaces.containsKey(superclassInterface)) continue;
                            interfaces.put(superclassInterface, null);
                        }
                        if (!superclassProto.interfacesFullyResolved) {
                            unresolvedInterfaces.addAll(superclassProto.getUnresolvedInterfaces());
                            ClassProto.this.interfacesFullyResolved = false;
                        }
                    }
                }
                catch (UnresolvedClassException ex) {
                    unresolvedInterfaces.add(superclass);
                    ClassProto.this.interfacesFullyResolved = false;
                }
                if (unresolvedInterfaces.size() > 0) {
                    ClassProto.this.unresolvedInterfaces = unresolvedInterfaces;
                }
                return interfaces;
            }
        });
        this.postDefaultMethodInterfaceSupplier = Suppliers.memoize(new Supplier<LinkedHashMap<String, ClassDef>>(){

            @Override
            public LinkedHashMap<String, ClassDef> get() {
                HashSet<String> unresolvedInterfaces = new HashSet<String>(0);
                LinkedHashMap<String, ClassDef> interfaces = Maps.newLinkedHashMap();
                String superclass = ClassProto.this.getSuperclass();
                if (superclass != null) {
                    ClassProto superclassProto = (ClassProto)ClassProto.this.classPath.getClass(superclass);
                    for (String superclassInterface : superclassProto.getInterfaces().keySet()) {
                        interfaces.put(superclassInterface, null);
                    }
                    if (!superclassProto.interfacesFullyResolved) {
                        unresolvedInterfaces.addAll(superclassProto.getUnresolvedInterfaces());
                        ClassProto.this.interfacesFullyResolved = false;
                    }
                }
                try {
                    for (String interfaceType : ClassProto.this.getClassDef().getInterfaces()) {
                        if (interfaces.containsKey(interfaceType)) continue;
                        ClassProto interfaceProto = (ClassProto)ClassProto.this.classPath.getClass(interfaceType);
                        try {
                            for (Map.Entry<String, ClassDef> entry : interfaceProto.getInterfaces().entrySet()) {
                                if (interfaces.containsKey(entry.getKey())) continue;
                                interfaces.put(entry.getKey(), entry.getValue());
                            }
                        }
                        catch (UnresolvedClassException ex) {
                            interfaces.put(interfaceType, null);
                            unresolvedInterfaces.add(interfaceType);
                            ClassProto.this.interfacesFullyResolved = false;
                        }
                        if (!interfaceProto.interfacesFullyResolved) {
                            unresolvedInterfaces.addAll(interfaceProto.getUnresolvedInterfaces());
                            ClassProto.this.interfacesFullyResolved = false;
                        }
                        try {
                            ClassDef interfaceDef = ClassProto.this.classPath.getClassDef(interfaceType);
                            interfaces.put(interfaceType, interfaceDef);
                        }
                        catch (UnresolvedClassException ex) {
                            interfaces.put(interfaceType, null);
                            unresolvedInterfaces.add(interfaceType);
                            ClassProto.this.interfacesFullyResolved = false;
                        }
                    }
                }
                catch (UnresolvedClassException ex) {
                    interfaces.put(ClassProto.this.type, null);
                    unresolvedInterfaces.add(ClassProto.this.type);
                    ClassProto.this.interfacesFullyResolved = false;
                }
                if (unresolvedInterfaces.size() > 0) {
                    ClassProto.this.unresolvedInterfaces = unresolvedInterfaces;
                }
                return interfaces;
            }
        });
        this.dalvikInstanceFieldsSupplier = Suppliers.memoize(new Supplier<SparseArray<FieldReference>>(){

            @Override
            public SparseArray<FieldReference> get() {
                int fieldOffset;
                int front;
                ArrayList<Field> fields = this.getSortedInstanceFields(ClassProto.this.getClassDef());
                int fieldCount = fields.size();
                byte[] fieldTypes = new byte[fields.size()];
                for (int i = 0; i < fieldCount; ++i) {
                    fieldTypes[i] = ClassProto.getFieldType(fields.get(i));
                }
                int back = fields.size() - 1;
                for (front = 0; front < fieldCount; ++front) {
                    if (fieldTypes[front] != 0) {
                        while (back > front) {
                            if (fieldTypes[back] == 0) {
                                this.swap(fieldTypes, fields, front, back--);
                                break;
                            }
                            --back;
                        }
                    }
                    if (fieldTypes[front] != 0) break;
                }
                int startFieldOffset = 8;
                String superclassType = ClassProto.this.getSuperclass();
                ClassProto superclass = null;
                if (superclassType != null) {
                    superclass = (ClassProto)ClassProto.this.classPath.getClass(superclassType);
                    startFieldOffset = superclass.getNextFieldOffset();
                }
                int fieldIndexMod = startFieldOffset % 8 == 0 ? 0 : 1;
                if (front < fieldCount && front % 2 != fieldIndexMod) {
                    if (fieldTypes[front] == 1) {
                        for (back = fieldCount - 1; back > front; --back) {
                            if (fieldTypes[back] != 2) continue;
                            this.swap(fieldTypes, fields, front++, back);
                            break;
                        }
                    } else {
                        ++front;
                    }
                }
                back = fieldCount - 1;
                while (front < fieldCount) {
                    if (fieldTypes[front] != 1) {
                        while (back > front) {
                            if (fieldTypes[back] == 1) {
                                this.swap(fieldTypes, fields, front, back--);
                                break;
                            }
                            --back;
                        }
                    }
                    if (fieldTypes[front] != 1) break;
                    ++front;
                }
                SparseArray<FieldReference> superFields = superclass != null ? superclass.getInstanceFields() : new SparseArray();
                int superFieldCount = superFields.size();
                int totalFieldCount = superFieldCount + fieldCount;
                SparseArray<FieldReference> instanceFields = new SparseArray<FieldReference>(totalFieldCount);
                if (superclass != null && superFieldCount > 0) {
                    for (int i = 0; i < superFieldCount; ++i) {
                        instanceFields.append(superFields.keyAt(i), superFields.valueAt(i));
                    }
                    fieldOffset = instanceFields.keyAt(superFieldCount - 1);
                    FieldReference lastSuperField = superFields.valueAt(superFieldCount - 1);
                    char fieldType = lastSuperField.getType().charAt(0);
                    fieldOffset = fieldType == 'J' || fieldType == 'D' ? (fieldOffset += 8) : (fieldOffset += 4);
                } else {
                    fieldOffset = 8;
                }
                boolean gotDouble = false;
                for (int i = 0; i < fieldCount; ++i) {
                    FieldReference field = fields.get(i);
                    if (fieldTypes[i] == 1 && !gotDouble) {
                        if (fieldOffset % 8 != 0) {
                            assert (fieldOffset % 8 == 4);
                            fieldOffset += 4;
                        }
                        gotDouble = true;
                    }
                    instanceFields.append(fieldOffset, field);
                    if (fieldTypes[i] == 1) {
                        fieldOffset += 8;
                        continue;
                    }
                    fieldOffset += 4;
                }
                return instanceFields;
            }

            @Nonnull
            private ArrayList<Field> getSortedInstanceFields(@Nonnull ClassDef classDef) {
                if (classDef == null) {
                    4.$$$reportNull$$$0(0);
                }
                ArrayList<Field> fields = Lists.newArrayList(classDef.getInstanceFields());
                Collections.sort(fields);
                ArrayList<Field> arrayList = fields;
                if (arrayList == null) {
                    4.$$$reportNull$$$0(1);
                }
                return arrayList;
            }

            private void swap(byte[] fieldTypes, List<Field> fields, int position1, int position2) {
                byte tempType = fieldTypes[position1];
                fieldTypes[position1] = fieldTypes[position2];
                fieldTypes[position2] = tempType;
                Field tempField = fields.set(position1, fields.get(position2));
                fields.set(position2, tempField);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@Nonnull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "classDef";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jf/dexlib2/analysis/ClassProto$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jf/dexlib2/analysis/ClassProto$4";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSortedInstanceFields";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getSortedInstanceFields";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        this.artInstanceFieldsSupplier = Suppliers.memoize(new Supplier<SparseArray<FieldReference>>(){

            @Override
            public SparseArray<FieldReference> get() {
                PriorityQueue<FieldGap> gaps = new PriorityQueue<FieldGap>();
                SparseArray<FieldReference> linkedFields = new SparseArray<FieldReference>();
                ArrayList<Field> fields = this.getSortedInstanceFields(ClassProto.this.getClassDef());
                int fieldOffset = 0;
                String superclassType = ClassProto.this.getSuperclass();
                if (superclassType != null) {
                    ClassProto superclass = (ClassProto)ClassProto.this.classPath.getClass(superclassType);
                    SparseArray<FieldReference> superFields = superclass.getInstanceFields();
                    FieldReference field = null;
                    int lastOffset = 0;
                    for (int i = 0; i < superFields.size(); ++i) {
                        int offset = superFields.keyAt(i);
                        field = superFields.valueAt(i);
                        linkedFields.put(offset, field);
                        lastOffset = offset;
                    }
                    if (field != null) {
                        fieldOffset = lastOffset + this.getFieldSize(field);
                    }
                }
                for (Field field : fields) {
                    FieldGap gap;
                    int fieldSize = this.getFieldSize(field);
                    if (!AlignmentUtils.isAligned(fieldOffset, fieldSize)) {
                        int oldOffset = fieldOffset;
                        fieldOffset = AlignmentUtils.alignOffset(fieldOffset, fieldSize);
                        this.addFieldGap(oldOffset, fieldOffset, gaps);
                    }
                    if ((gap = (FieldGap)gaps.peek()) != null && gap.size >= fieldSize) {
                        gaps.poll();
                        linkedFields.put(gap.offset, field);
                        if (gap.size <= fieldSize) continue;
                        this.addFieldGap(gap.offset + fieldSize, gap.offset + gap.size, gaps);
                        continue;
                    }
                    linkedFields.append(fieldOffset, field);
                    fieldOffset += fieldSize;
                }
                return linkedFields;
            }

            private void addFieldGap(int gapStart, int gapEnd, @Nonnull PriorityQueue<FieldGap> gaps) {
                if (gaps == null) {
                    5.$$$reportNull$$$0(0);
                }
                int offset = gapStart;
                while (offset < gapEnd) {
                    int remaining = gapEnd - offset;
                    if (remaining >= 4 && offset % 4 == 0) {
                        gaps.add(FieldGap.newFieldGap(offset, 4, ClassProto.this.classPath.oatVersion));
                        offset += 4;
                        continue;
                    }
                    if (remaining >= 2 && offset % 2 == 0) {
                        gaps.add(FieldGap.newFieldGap(offset, 2, ClassProto.this.classPath.oatVersion));
                        offset += 2;
                        continue;
                    }
                    gaps.add(FieldGap.newFieldGap(offset, 1, ClassProto.this.classPath.oatVersion));
                    ++offset;
                }
            }

            @Nonnull
            private ArrayList<Field> getSortedInstanceFields(@Nonnull ClassDef classDef) {
                if (classDef == null) {
                    5.$$$reportNull$$$0(1);
                }
                ArrayList<Field> fields = Lists.newArrayList(classDef.getInstanceFields());
                Collections.sort(fields, new Comparator<Field>(){

                    @Override
                    public int compare(Field field1, Field field2) {
                        int result = Ints.compare(this.getFieldSortOrder(field1), this.getFieldSortOrder(field2));
                        if (result != 0) {
                            return result;
                        }
                        result = field1.getName().compareTo(field2.getName());
                        if (result != 0) {
                            return result;
                        }
                        return field1.getType().compareTo(field2.getType());
                    }
                });
                ArrayList<Field> arrayList = fields;
                if (arrayList == null) {
                    5.$$$reportNull$$$0(2);
                }
                return arrayList;
            }

            private int getFieldSortOrder(@Nonnull FieldReference field) {
                if (field == null) {
                    5.$$$reportNull$$$0(3);
                }
                switch (field.getType().charAt(0)) {
                    case 'L': 
                    case '[': {
                        return 0;
                    }
                    case 'J': {
                        return 1;
                    }
                    case 'D': {
                        return 2;
                    }
                    case 'I': {
                        return 3;
                    }
                    case 'F': {
                        return 4;
                    }
                    case 'C': {
                        return 5;
                    }
                    case 'S': {
                        return 6;
                    }
                    case 'Z': {
                        return 7;
                    }
                    case 'B': {
                        return 8;
                    }
                }
                throw new ExceptionWithContext("Invalid field type: %s", field.getType());
            }

            private int getFieldSize(@Nonnull FieldReference field) {
                if (field == null) {
                    5.$$$reportNull$$$0(4);
                }
                return ClassProto.getTypeSize(field.getType().charAt(0));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@Nonnull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "gaps";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "classDef";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jf/dexlib2/analysis/ClassProto$5";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "field";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jf/dexlib2/analysis/ClassProto$5";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSortedInstanceFields";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "addFieldGap";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getSortedInstanceFields";
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "getFieldSortOrder";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "getFieldSize";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        this.preDefaultMethodVtableSupplier = Suppliers.memoize(new Supplier<List<Method>>(){

            @Override
            public List<Method> get() {
                String superclassType;
                ArrayList<Method> vtable = Lists.newArrayList();
                try {
                    superclassType = ClassProto.this.getSuperclass();
                }
                catch (UnresolvedClassException ex) {
                    vtable.addAll(((ClassProto)ClassProto.this.classPath.getClass("Ljava/lang/Object;")).getVtable());
                    ClassProto.this.vtableFullyResolved = false;
                    return vtable;
                }
                if (superclassType != null) {
                    ClassProto superclass = (ClassProto)ClassProto.this.classPath.getClass(superclassType);
                    vtable.addAll(superclass.getVtable());
                    if (!superclass.vtableFullyResolved) {
                        ClassProto.this.vtableFullyResolved = false;
                        return vtable;
                    }
                }
                if (!ClassProto.this.isInterface()) {
                    ClassProto.this.addToVtable(ClassProto.this.getClassDef().getVirtualMethods(), vtable, true, true);
                    Iterable<ClassDef> interfaces = ClassProto.this.getDirectInterfaces();
                    for (ClassDef interfaceDef : interfaces) {
                        ArrayList<ReparentedMethod> interfaceMethods = Lists.newArrayList();
                        for (Method method : interfaceDef.getVirtualMethods()) {
                            interfaceMethods.add(new ReparentedMethod(method, ClassProto.this.type));
                        }
                        ClassProto.this.addToVtable(interfaceMethods, vtable, false, true);
                    }
                }
                return vtable;
            }
        });
        this.buggyPostDefaultMethodVtableSupplier = Suppliers.memoize(new Supplier<List<Method>>(){

            @Override
            public List<Method> get() {
                String superclassType;
                ArrayList<Method> vtable = Lists.newArrayList();
                try {
                    superclassType = ClassProto.this.getSuperclass();
                }
                catch (UnresolvedClassException ex) {
                    vtable.addAll(((ClassProto)ClassProto.this.classPath.getClass("Ljava/lang/Object;")).getVtable());
                    ClassProto.this.vtableFullyResolved = false;
                    return vtable;
                }
                if (superclassType != null) {
                    ClassProto superclass = (ClassProto)ClassProto.this.classPath.getClass(superclassType);
                    vtable.addAll(superclass.getVtable());
                    if (!superclass.vtableFullyResolved) {
                        ClassProto.this.vtableFullyResolved = false;
                        return vtable;
                    }
                }
                if (!ClassProto.this.isInterface()) {
                    ClassProto.this.addToVtable(ClassProto.this.getClassDef().getVirtualMethods(), vtable, true, true);
                    ArrayList<String> interfaces = Lists.newArrayList(ClassProto.this.getInterfaces().keySet());
                    ArrayList<Method> defaultMethods = Lists.newArrayList();
                    ArrayList<Method> defaultConflictMethods = Lists.newArrayList();
                    ArrayList<Method> mirandaMethods = Lists.newArrayList();
                    final HashMap<Method, Integer> methodOrder = Maps.newHashMap();
                    for (int i = interfaces.size() - 1; i >= 0; --i) {
                        String interfaceType = (String)interfaces.get(i);
                        ClassDef interfaceDef = ClassProto.this.classPath.getClassDef(interfaceType);
                        for (Method method : interfaceDef.getVirtualMethods()) {
                            int vtableIndex = ClassProto.this.findMethodIndexInVtableReverse(vtable, method);
                            Method oldVtableMethod = null;
                            if (vtableIndex >= 0) {
                                oldVtableMethod = (Method)vtable.get(vtableIndex);
                            }
                            for (int j = 0; j < vtable.size(); ++j) {
                                Method candidate = (Method)vtable.get(j);
                                if (!MethodUtil.methodSignaturesMatch(candidate, method) || ClassProto.this.classPath.shouldCheckPackagePrivateAccess() && !AnalyzedMethodUtil.canAccess(ClassProto.this, candidate, true, false, false) || !ClassProto.this.interfaceMethodOverrides(method, candidate)) continue;
                                vtable.set(j, method);
                            }
                            if (vtableIndex >= 0 && !ClassProto.this.isOverridableByDefaultMethod((Method)vtable.get(vtableIndex))) continue;
                            int defaultMethodIndex = ClassProto.this.findMethodIndexInVtable(defaultMethods, method);
                            if (defaultMethodIndex >= 0) {
                                ClassProto existingInterface;
                                if (AccessFlags.ABSTRACT.isSet(method.getAccessFlags()) || (existingInterface = (ClassProto)ClassProto.this.classPath.getClass(((Method)defaultMethods.get(defaultMethodIndex)).getDefiningClass())).implementsInterface(method.getDefiningClass())) continue;
                                Method removedMethod = (Method)defaultMethods.remove(defaultMethodIndex);
                                defaultConflictMethods.add(removedMethod);
                                continue;
                            }
                            int defaultConflictMethodIndex = ClassProto.this.findMethodIndexInVtable(defaultConflictMethods, method);
                            if (defaultConflictMethodIndex >= 0) continue;
                            int mirandaMethodIndex = ClassProto.this.findMethodIndexInVtable(mirandaMethods, method);
                            if (mirandaMethodIndex >= 0) {
                                ClassProto existingInterface;
                                if (AccessFlags.ABSTRACT.isSet(method.getAccessFlags()) || (existingInterface = (ClassProto)ClassProto.this.classPath.getClass(((Method)mirandaMethods.get(mirandaMethodIndex)).getDefiningClass())).implementsInterface(method.getDefiningClass())) continue;
                                Method oldMethod = (Method)mirandaMethods.remove(mirandaMethodIndex);
                                int methodOrderValue = (Integer)methodOrder.get(oldMethod);
                                methodOrder.put(method, methodOrderValue);
                                defaultMethods.add(method);
                                continue;
                            }
                            if (!AccessFlags.ABSTRACT.isSet(method.getAccessFlags())) {
                                if (oldVtableMethod != null && !ClassProto.this.interfaceMethodOverrides(method, oldVtableMethod)) continue;
                                defaultMethods.add(method);
                                methodOrder.put(method, methodOrder.size());
                                continue;
                            }
                            if (oldVtableMethod != null) continue;
                            mirandaMethods.add(method);
                            methodOrder.put(method, methodOrder.size());
                        }
                    }
                    Comparator<MethodReference> comparator = new Comparator<MethodReference>(){

                        @Override
                        public int compare(MethodReference o1, MethodReference o2) {
                            return Ints.compare((Integer)methodOrder.get(o1), (Integer)methodOrder.get(o2));
                        }
                    };
                    Collections.sort(mirandaMethods, comparator);
                    Collections.sort(defaultMethods, comparator);
                    Collections.sort(defaultConflictMethods, comparator);
                    vtable.addAll(mirandaMethods);
                    vtable.addAll(defaultMethods);
                    vtable.addAll(defaultConflictMethods);
                }
                return vtable;
            }
        });
        this.postDefaultMethodVtableSupplier = Suppliers.memoize(new Supplier<List<Method>>(){

            @Override
            public List<Method> get() {
                String superclassType;
                ArrayList<Method> vtable = Lists.newArrayList();
                try {
                    superclassType = ClassProto.this.getSuperclass();
                }
                catch (UnresolvedClassException ex) {
                    vtable.addAll(((ClassProto)ClassProto.this.classPath.getClass("Ljava/lang/Object;")).getVtable());
                    ClassProto.this.vtableFullyResolved = false;
                    return vtable;
                }
                if (superclassType != null) {
                    ClassProto superclass = (ClassProto)ClassProto.this.classPath.getClass(superclassType);
                    vtable.addAll(superclass.getVtable());
                    if (!superclass.vtableFullyResolved) {
                        ClassProto.this.vtableFullyResolved = false;
                        return vtable;
                    }
                }
                if (!ClassProto.this.isInterface()) {
                    ClassProto.this.addToVtable(ClassProto.this.getClassDef().getVirtualMethods(), vtable, true, true);
                    List<ClassDef> interfaces = Lists.reverse(Lists.newArrayList(ClassProto.this.getDirectInterfaces()));
                    ArrayList<Method> defaultMethods = Lists.newArrayList();
                    ArrayList<Method> defaultConflictMethods = Lists.newArrayList();
                    ArrayList<Method> mirandaMethods = Lists.newArrayList();
                    final HashMap<Method, Integer> methodOrder = Maps.newHashMap();
                    for (ClassDef interfaceDef : interfaces) {
                        for (Method method : interfaceDef.getVirtualMethods()) {
                            int vtableIndex = ClassProto.this.findMethodIndexInVtable(vtable, method);
                            if (vtableIndex >= 0) {
                                if (!ClassProto.this.interfaceMethodOverrides(method, (Method)vtable.get(vtableIndex))) continue;
                                vtable.set(vtableIndex, method);
                                continue;
                            }
                            int defaultMethodIndex = ClassProto.this.findMethodIndexInVtable(defaultMethods, method);
                            if (defaultMethodIndex >= 0) {
                                ClassProto existingInterface;
                                if (AccessFlags.ABSTRACT.isSet(method.getAccessFlags()) || (existingInterface = (ClassProto)ClassProto.this.classPath.getClass(((Method)defaultMethods.get(defaultMethodIndex)).getDefiningClass())).implementsInterface(method.getDefiningClass())) continue;
                                Method removedMethod = (Method)defaultMethods.remove(defaultMethodIndex);
                                defaultConflictMethods.add(removedMethod);
                                continue;
                            }
                            int defaultConflictMethodIndex = ClassProto.this.findMethodIndexInVtable(defaultConflictMethods, method);
                            if (defaultConflictMethodIndex >= 0) continue;
                            int mirandaMethodIndex = ClassProto.this.findMethodIndexInVtable(mirandaMethods, method);
                            if (mirandaMethodIndex >= 0) {
                                ClassProto existingInterface;
                                if (AccessFlags.ABSTRACT.isSet(method.getAccessFlags()) || (existingInterface = (ClassProto)ClassProto.this.classPath.getClass(((Method)mirandaMethods.get(mirandaMethodIndex)).getDefiningClass())).implementsInterface(method.getDefiningClass())) continue;
                                Method oldMethod = (Method)mirandaMethods.remove(mirandaMethodIndex);
                                int methodOrderValue = (Integer)methodOrder.get(oldMethod);
                                methodOrder.put(method, methodOrderValue);
                                defaultMethods.add(method);
                                continue;
                            }
                            if (!AccessFlags.ABSTRACT.isSet(method.getAccessFlags())) {
                                defaultMethods.add(method);
                                methodOrder.put(method, methodOrder.size());
                                continue;
                            }
                            mirandaMethods.add(method);
                            methodOrder.put(method, methodOrder.size());
                        }
                    }
                    Comparator<MethodReference> comparator = new Comparator<MethodReference>(){

                        @Override
                        public int compare(MethodReference o1, MethodReference o2) {
                            return Ints.compare((Integer)methodOrder.get(o1), (Integer)methodOrder.get(o2));
                        }
                    };
                    Collections.sort(defaultMethods, comparator);
                    Collections.sort(defaultConflictMethods, comparator);
                    Collections.sort(mirandaMethods, comparator);
                    ClassProto.this.addToVtable(defaultMethods, vtable, false, false);
                    ClassProto.this.addToVtable(defaultConflictMethods, vtable, false, false);
                    ClassProto.this.addToVtable(mirandaMethods, vtable, false, false);
                }
                return vtable;
            }
        });
        if (type.charAt(0) != 'L') {
            throw new ExceptionWithContext("Cannot construct ClassProto for non reference type: %s", type);
        }
        this.classPath = classPath;
        this.type = type;
    }

    public String toString() {
        return this.type;
    }

    @Override
    @Nonnull
    public ClassPath getClassPath() {
        ClassPath classPath = this.classPath;
        if (classPath == null) {
            ClassProto.$$$reportNull$$$0(2);
        }
        return classPath;
    }

    @Override
    @Nonnull
    public String getType() {
        String string = this.type;
        if (string == null) {
            ClassProto.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nonnull
    public ClassDef getClassDef() {
        ClassDef classDef = this.classDefSupplier.get();
        if (classDef == null) {
            ClassProto.$$$reportNull$$$0(4);
        }
        return classDef;
    }

    @Override
    public boolean isInterface() {
        ClassDef classDef = this.getClassDef();
        return (classDef.getAccessFlags() & AccessFlags.INTERFACE.getValue()) != 0;
    }

    @Nonnull
    protected LinkedHashMap<String, ClassDef> getInterfaces() {
        if (!this.classPath.isArt() || this.classPath.oatVersion < 72) {
            LinkedHashMap<String, ClassDef> linkedHashMap = this.preDefaultMethodInterfaceSupplier.get();
            if (linkedHashMap == null) {
                ClassProto.$$$reportNull$$$0(5);
            }
            return linkedHashMap;
        }
        LinkedHashMap<String, ClassDef> linkedHashMap = this.postDefaultMethodInterfaceSupplier.get();
        if (linkedHashMap == null) {
            ClassProto.$$$reportNull$$$0(6);
        }
        return linkedHashMap;
    }

    @Nonnull
    protected Set<String> getUnresolvedInterfaces() {
        if (this.unresolvedInterfaces == null) {
            ImmutableSet<String> immutableSet = ImmutableSet.of();
            if (immutableSet == null) {
                ClassProto.$$$reportNull$$$0(7);
            }
            return immutableSet;
        }
        Set<String> set = this.unresolvedInterfaces;
        if (set == null) {
            ClassProto.$$$reportNull$$$0(8);
        }
        return set;
    }

    @Nonnull
    protected Iterable<ClassDef> getDirectInterfaces() {
        FluentIterable<ClassDef> directInterfaces = FluentIterable.from(this.getInterfaces().values()).filter(Predicates.notNull());
        if (!this.interfacesFullyResolved) {
            throw new UnresolvedClassException("Interfaces for class %s not fully resolved: %s", this.getType(), Joiner.on(',').join(this.getUnresolvedInterfaces()));
        }
        FluentIterable<ClassDef> fluentIterable = directInterfaces;
        if (fluentIterable == null) {
            ClassProto.$$$reportNull$$$0(9);
        }
        return fluentIterable;
    }

    @Override
    public boolean implementsInterface(@Nonnull String iface) {
        if (iface == null) {
            ClassProto.$$$reportNull$$$0(10);
        }
        if (this.getInterfaces().containsKey(iface)) {
            return true;
        }
        if (!this.interfacesFullyResolved) {
            throw new UnresolvedClassException("Interfaces for class %s not fully resolved", this.getType());
        }
        return false;
    }

    @Override
    @Nullable
    public String getSuperclass() {
        return this.getClassDef().getSuperclass();
    }

    private boolean checkInterface(@Nonnull ClassProto other) {
        block7: {
            if (other == null) {
                ClassProto.$$$reportNull$$$0(11);
            }
            boolean isResolved = true;
            boolean isInterface = true;
            try {
                isInterface = this.isInterface();
            }
            catch (UnresolvedClassException ex) {
                isResolved = false;
            }
            if (isInterface) {
                try {
                    if (other.implementsInterface(this.getType())) {
                        return true;
                    }
                }
                catch (UnresolvedClassException ex) {
                    if (!isResolved) break block7;
                    throw ex;
                }
            }
        }
        return false;
    }

    @Override
    @Nonnull
    public TypeProto getCommonSuperclass(@Nonnull TypeProto other) {
        boolean gotException;
        block21: {
            TypeProto typeProto;
            block20: {
                ClassProto classProto;
                if (other == null) {
                    ClassProto.$$$reportNull$$$0(12);
                }
                if (!(other instanceof ClassProto)) {
                    TypeProto typeProto2 = other.getCommonSuperclass(this);
                    if (typeProto2 == null) {
                        ClassProto.$$$reportNull$$$0(13);
                    }
                    return typeProto2;
                }
                if (this == other || this.getType().equals(other.getType())) {
                    ClassProto classProto2 = this;
                    if (classProto2 == null) {
                        ClassProto.$$$reportNull$$$0(14);
                    }
                    return classProto2;
                }
                if (this.getType().equals("Ljava/lang/Object;")) {
                    ClassProto classProto3 = this;
                    if (classProto3 == null) {
                        ClassProto.$$$reportNull$$$0(15);
                    }
                    return classProto3;
                }
                if (other.getType().equals("Ljava/lang/Object;")) {
                    TypeProto typeProto3 = other;
                    if (typeProto3 == null) {
                        ClassProto.$$$reportNull$$$0(16);
                    }
                    return typeProto3;
                }
                gotException = false;
                try {
                    if (!this.checkInterface((ClassProto)other)) break block20;
                    classProto = this;
                }
                catch (UnresolvedClassException ex) {
                    gotException = true;
                }
                if (classProto == null) {
                    ClassProto.$$$reportNull$$$0(17);
                }
                return classProto;
            }
            try {
                if (!((ClassProto)other).checkInterface(this)) break block21;
                typeProto = other;
            }
            catch (UnresolvedClassException ex) {
                gotException = true;
            }
            if (typeProto == null) {
                ClassProto.$$$reportNull$$$0(18);
            }
            return typeProto;
        }
        if (gotException) {
            TypeProto typeProto = this.classPath.getUnknownClass();
            if (typeProto == null) {
                ClassProto.$$$reportNull$$$0(19);
            }
            return typeProto;
        }
        List<TypeProto> thisChain = Lists.newArrayList(this);
        Iterables.addAll(thisChain, TypeProtoUtils.getSuperclassChain(this));
        List<TypeProto> otherChain = Lists.newArrayList(other);
        Iterables.addAll(otherChain, TypeProtoUtils.getSuperclassChain(other));
        thisChain = Lists.reverse(thisChain);
        otherChain = Lists.reverse(otherChain);
        for (int i = Math.min(thisChain.size(), otherChain.size()) - 1; i >= 0; --i) {
            TypeProto typeProto = thisChain.get(i);
            if (!typeProto.getType().equals(otherChain.get(i).getType())) continue;
            TypeProto typeProto4 = typeProto;
            if (typeProto4 == null) {
                ClassProto.$$$reportNull$$$0(20);
            }
            return typeProto4;
        }
        TypeProto typeProto = this.classPath.getUnknownClass();
        if (typeProto == null) {
            ClassProto.$$$reportNull$$$0(21);
        }
        return typeProto;
    }

    @Override
    @Nullable
    public FieldReference getFieldByOffset(int fieldOffset) {
        if (this.getInstanceFields().size() == 0) {
            return null;
        }
        return this.getInstanceFields().get(fieldOffset);
    }

    @Override
    @Nullable
    public Method getMethodByVtableIndex(int vtableIndex) {
        List<Method> vtable = this.getVtable();
        if (vtableIndex < 0 || vtableIndex >= vtable.size()) {
            return null;
        }
        return vtable.get(vtableIndex);
    }

    @Override
    public int findMethodIndexInVtable(@Nonnull MethodReference method) {
        if (method == null) {
            ClassProto.$$$reportNull$$$0(22);
        }
        return this.findMethodIndexInVtable(this.getVtable(), method);
    }

    private int findMethodIndexInVtable(@Nonnull List<Method> vtable, MethodReference method) {
        if (vtable == null) {
            ClassProto.$$$reportNull$$$0(23);
        }
        for (int i = 0; i < vtable.size(); ++i) {
            Method candidate = vtable.get(i);
            if (!MethodUtil.methodSignaturesMatch(candidate, method) || this.classPath.shouldCheckPackagePrivateAccess() && !AnalyzedMethodUtil.canAccess(this, candidate, true, false, false)) continue;
            return i;
        }
        return -1;
    }

    private int findMethodIndexInVtableReverse(@Nonnull List<Method> vtable, MethodReference method) {
        if (vtable == null) {
            ClassProto.$$$reportNull$$$0(24);
        }
        for (int i = vtable.size() - 1; i >= 0; --i) {
            Method candidate = vtable.get(i);
            if (!MethodUtil.methodSignaturesMatch(candidate, method) || this.classPath.shouldCheckPackagePrivateAccess() && !AnalyzedMethodUtil.canAccess(this, candidate, true, false, false)) continue;
            return i;
        }
        return -1;
    }

    @Nonnull
    public SparseArray<FieldReference> getInstanceFields() {
        if (this.classPath.isArt()) {
            SparseArray<FieldReference> sparseArray = this.artInstanceFieldsSupplier.get();
            if (sparseArray == null) {
                ClassProto.$$$reportNull$$$0(25);
            }
            return sparseArray;
        }
        SparseArray<FieldReference> sparseArray = this.dalvikInstanceFieldsSupplier.get();
        if (sparseArray == null) {
            ClassProto.$$$reportNull$$$0(26);
        }
        return sparseArray;
    }

    private int getNextFieldOffset() {
        SparseArray<FieldReference> instanceFields = this.getInstanceFields();
        if (instanceFields.size() == 0) {
            return this.classPath.isArt() ? 0 : 8;
        }
        int lastItemIndex = instanceFields.size() - 1;
        int fieldOffset = instanceFields.keyAt(lastItemIndex);
        FieldReference lastField = instanceFields.valueAt(lastItemIndex);
        if (this.classPath.isArt()) {
            return fieldOffset + ClassProto.getTypeSize(lastField.getType().charAt(0));
        }
        switch (lastField.getType().charAt(0)) {
            case 'D': 
            case 'J': {
                return fieldOffset + 8;
            }
        }
        return fieldOffset + 4;
    }

    private static int getTypeSize(char type) {
        switch (type) {
            case 'D': 
            case 'J': {
                return 8;
            }
            case 'F': 
            case 'I': 
            case 'L': 
            case '[': {
                return 4;
            }
            case 'C': 
            case 'S': {
                return 2;
            }
            case 'B': 
            case 'Z': {
                return 1;
            }
        }
        throw new ExceptionWithContext("Invalid type: %s", Character.valueOf(type));
    }

    @Nonnull
    public List<Method> getVtable() {
        if (!this.classPath.isArt() || this.classPath.oatVersion < 72) {
            List<Method> list = this.preDefaultMethodVtableSupplier.get();
            if (list == null) {
                ClassProto.$$$reportNull$$$0(27);
            }
            return list;
        }
        if (this.classPath.oatVersion < 87) {
            List<Method> list = this.buggyPostDefaultMethodVtableSupplier.get();
            if (list == null) {
                ClassProto.$$$reportNull$$$0(28);
            }
            return list;
        }
        List<Method> list = this.postDefaultMethodVtableSupplier.get();
        if (list == null) {
            ClassProto.$$$reportNull$$$0(29);
        }
        return list;
    }

    private void addToVtable(@Nonnull Iterable<? extends Method> localMethods, @Nonnull List<Method> vtable, boolean replaceExisting, boolean sort) {
        if (localMethods == null) {
            ClassProto.$$$reportNull$$$0(30);
        }
        if (vtable == null) {
            ClassProto.$$$reportNull$$$0(31);
        }
        if (sort) {
            ArrayList<? extends Method> methods = Lists.newArrayList(localMethods);
            Collections.sort(methods);
            localMethods = methods;
        }
        for (Method method : localMethods) {
            int vtableIndex = this.findMethodIndexInVtable(vtable, method);
            if (vtableIndex >= 0) {
                if (!replaceExisting) continue;
                vtable.set(vtableIndex, method);
                continue;
            }
            vtable.add(method);
        }
    }

    private static byte getFieldType(@Nonnull FieldReference field) {
        if (field == null) {
            ClassProto.$$$reportNull$$$0(32);
        }
        switch (field.getType().charAt(0)) {
            case 'L': 
            case '[': {
                return 0;
            }
            case 'D': 
            case 'J': {
                return 1;
            }
        }
        return 2;
    }

    private boolean isOverridableByDefaultMethod(@Nonnull Method method) {
        if (method == null) {
            ClassProto.$$$reportNull$$$0(33);
        }
        ClassProto classProto = (ClassProto)this.classPath.getClass(method.getDefiningClass());
        return classProto.isInterface();
    }

    private boolean interfaceMethodOverrides(@Nonnull Method method, @Nonnull Method method2) {
        ClassProto classProto;
        if (method == null) {
            ClassProto.$$$reportNull$$$0(34);
        }
        if (method2 == null) {
            ClassProto.$$$reportNull$$$0(35);
        }
        if ((classProto = (ClassProto)this.classPath.getClass(method2.getDefiningClass())).isInterface()) {
            ClassProto targetClassProto = (ClassProto)this.classPath.getClass(method.getDefiningClass());
            return targetClassProto.implementsInterface(method2.getDefiningClass());
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jf/dexlib2/analysis/ClassProto";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iface";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 22: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 23: 
            case 24: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vtable";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localMethods";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jf/dexlib2/analysis/ClassProto";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassDef";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterfaces";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedInterfaces";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectInterfaces";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonSuperclass";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstanceFields";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getVtable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "implementsInterface";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkInterface";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getCommonSuperclass";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findMethodIndexInVtable";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findMethodIndexInVtableReverse";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "addToVtable";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getFieldType";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isOverridableByDefaultMethod";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "interfaceMethodOverrides";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ReparentedMethod
    extends BaseMethodReference
    implements Method {
        private final Method method;
        private final String definingClass;

        public ReparentedMethod(Method method, String definingClass) {
            this.method = method;
            this.definingClass = definingClass;
        }

        @Override
        @Nonnull
        public String getDefiningClass() {
            String string = this.definingClass;
            if (string == null) {
                ReparentedMethod.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @Nonnull
        public String getName() {
            String string = this.method.getName();
            if (string == null) {
                ReparentedMethod.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @Nonnull
        public List<? extends CharSequence> getParameterTypes() {
            List<? extends CharSequence> list = this.method.getParameterTypes();
            if (list == null) {
                ReparentedMethod.$$$reportNull$$$0(2);
            }
            return list;
        }

        @Override
        @Nonnull
        public String getReturnType() {
            String string = this.method.getReturnType();
            if (string == null) {
                ReparentedMethod.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @Nonnull
        public List<? extends MethodParameter> getParameters() {
            List<? extends MethodParameter> list = this.method.getParameters();
            if (list == null) {
                ReparentedMethod.$$$reportNull$$$0(4);
            }
            return list;
        }

        @Override
        public int getAccessFlags() {
            return this.method.getAccessFlags();
        }

        @Override
        @Nonnull
        public Set<? extends Annotation> getAnnotations() {
            Set<? extends Annotation> set = this.method.getAnnotations();
            if (set == null) {
                ReparentedMethod.$$$reportNull$$$0(5);
            }
            return set;
        }

        @Override
        @Nullable
        public MethodImplementation getImplementation() {
            return this.method.getImplementation();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "org/jf/dexlib2/analysis/ClassProto$ReparentedMethod";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefiningClass";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParameterTypes";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReturnType";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParameters";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAnnotations";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@Nonnull method %s.%s must not return null", objectArray));
        }
    }

    private static abstract class FieldGap
    implements Comparable<FieldGap> {
        public final int offset;
        public final int size;

        public static FieldGap newFieldGap(int offset, int size, int oatVersion) {
            if (oatVersion >= 67) {
                return new FieldGap(offset, size){

                    @Override
                    public int compareTo(@Nonnull FieldGap o) {
                        int result;
                        if (o == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if ((result = Ints.compare(o.size, this.size)) != 0) {
                            return result;
                        }
                        return Ints.compare(this.offset, o.offset);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", "o", "org/jf/dexlib2/analysis/ClassProto$FieldGap$1", "compareTo"));
                    }
                };
            }
            return new FieldGap(offset, size){

                @Override
                public int compareTo(@Nonnull FieldGap o) {
                    int result;
                    if (o == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if ((result = Ints.compare(this.size, o.size)) != 0) {
                        return result;
                    }
                    return Ints.compare(o.offset, this.offset);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", "o", "org/jf/dexlib2/analysis/ClassProto$FieldGap$2", "compareTo"));
                }
            };
        }

        private FieldGap(int offset, int size) {
            this.offset = offset;
            this.size = size;
        }
    }
}

