/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.analysis;

import com.beust.jcommander.internal.Sets;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.DexFileFactory;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.analysis.ClassProvider;
import org.jf.dexlib2.analysis.DexClassProvider;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.DexBackedOdexFile;
import org.jf.dexlib2.dexbacked.OatFile;
import org.jf.dexlib2.iface.DexFile;
import org.jf.dexlib2.iface.MultiDexContainer;

public class ClassPathResolver {
    private final Iterable<String> classPathDirs;
    private final Opcodes opcodes;
    private final Set<File> loadedFiles;
    private final List<ClassProvider> classProviders;

    public ClassPathResolver(@Nonnull List<String> bootClassPathDirs, @Nonnull List<String> bootClassPathEntries, @Nonnull List<String> extraClassPathEntries, @Nonnull DexFile dexFile) throws IOException {
        if (bootClassPathDirs == null) {
            ClassPathResolver.$$$reportNull$$$0(0);
        }
        if (bootClassPathEntries == null) {
            ClassPathResolver.$$$reportNull$$$0(1);
        }
        if (extraClassPathEntries == null) {
            ClassPathResolver.$$$reportNull$$$0(2);
        }
        if (dexFile == null) {
            ClassPathResolver.$$$reportNull$$$0(3);
        }
        this(bootClassPathDirs, bootClassPathEntries, extraClassPathEntries, dexFile, true);
    }

    public ClassPathResolver(@Nonnull List<String> bootClassPathDirs, @Nonnull List<String> extraClassPathEntries, @Nonnull DexFile dexFile) throws IOException {
        if (bootClassPathDirs == null) {
            ClassPathResolver.$$$reportNull$$$0(4);
        }
        if (extraClassPathEntries == null) {
            ClassPathResolver.$$$reportNull$$$0(5);
        }
        if (dexFile == null) {
            ClassPathResolver.$$$reportNull$$$0(6);
        }
        this(bootClassPathDirs, null, extraClassPathEntries, dexFile, true);
    }

    private ClassPathResolver(@Nonnull List<String> bootClassPathDirs, @Nullable List<String> bootClassPathEntries, @Nonnull List<String> extraClassPathEntries, @Nonnull DexFile dexFile, boolean unused) throws IOException {
        if (bootClassPathDirs == null) {
            ClassPathResolver.$$$reportNull$$$0(7);
        }
        if (extraClassPathEntries == null) {
            ClassPathResolver.$$$reportNull$$$0(8);
        }
        if (dexFile == null) {
            ClassPathResolver.$$$reportNull$$$0(9);
        }
        this.loadedFiles = Sets.newHashSet();
        this.classProviders = Lists.newArrayList();
        this.classPathDirs = bootClassPathDirs;
        this.opcodes = dexFile.getOpcodes();
        if (bootClassPathEntries == null) {
            bootClassPathEntries = ClassPathResolver.getDefaultBootClassPath(dexFile, this.opcodes.api);
        }
        for (String entry : bootClassPathEntries) {
            try {
                this.loadLocalOrDeviceBootClassPathEntry(entry);
            }
            catch (NoDexException ex) {
                if (entry.endsWith(".jar")) {
                    String odexEntry = entry.substring(0, entry.length() - 4) + ".odex";
                    try {
                        this.loadLocalOrDeviceBootClassPathEntry(odexEntry);
                        continue;
                    }
                    catch (NoDexException ex2) {
                        throw new ResolveException("Neither %s nor %s contain a dex file", entry, odexEntry);
                    }
                    catch (NotFoundException ex2) {
                        throw new ResolveException(ex);
                    }
                }
                throw new ResolveException(ex);
            }
            catch (NotFoundException ex) {
                if (entry.endsWith(".odex")) {
                    String jarEntry = entry.substring(0, entry.length() - 5) + ".jar";
                    try {
                        this.loadLocalOrDeviceBootClassPathEntry(jarEntry);
                        continue;
                    }
                    catch (NoDexException ex2) {
                        throw new ResolveException("Neither %s nor %s contain a dex file", entry, jarEntry);
                    }
                    catch (NotFoundException ex2) {
                        throw new ResolveException(ex);
                    }
                }
                throw new ResolveException(ex);
            }
        }
        for (String entry : extraClassPathEntries) {
            try {
                this.loadLocalClassPathEntry(entry);
            }
            catch (NoDexException ex) {
                throw new ResolveException(ex);
            }
        }
        if (dexFile instanceof MultiDexContainer.MultiDexFile) {
            MultiDexContainer<? extends MultiDexContainer.MultiDexFile> container = ((MultiDexContainer.MultiDexFile)dexFile).getContainer();
            for (String entry : container.getDexEntryNames()) {
                this.classProviders.add(new DexClassProvider(container.getEntry(entry)));
            }
        } else {
            this.classProviders.add(new DexClassProvider(dexFile));
        }
    }

    @Nonnull
    public List<ClassProvider> getResolvedClassProviders() {
        List<ClassProvider> list = this.classProviders;
        if (list == null) {
            ClassPathResolver.$$$reportNull$$$0(10);
        }
        return list;
    }

    private boolean loadLocalClassPathEntry(@Nonnull String entry) throws NoDexException, IOException {
        File entryFile;
        if (entry == null) {
            ClassPathResolver.$$$reportNull$$$0(11);
        }
        if ((entryFile = new File(entry)).exists() && entryFile.isFile()) {
            try {
                this.loadEntry(entryFile, true);
                return true;
            }
            catch (DexFileFactory.UnsupportedFileTypeException ex) {
                throw new ResolveException(ex, "Couldn't load classpath entry %s", entry);
            }
        }
        return false;
    }

    private void loadLocalOrDeviceBootClassPathEntry(@Nonnull String entry) throws IOException, NoDexException, NotFoundException {
        if (entry == null) {
            ClassPathResolver.$$$reportNull$$$0(12);
        }
        if (this.loadLocalClassPathEntry(entry)) {
            return;
        }
        List<String> pathComponents = ClassPathResolver.splitDevicePath(entry);
        Joiner pathJoiner = Joiner.on(File.pathSeparatorChar);
        for (String directory : this.classPathDirs) {
            File directoryFile = new File(directory);
            if (!directoryFile.exists()) continue;
            for (int i = 0; i < pathComponents.size(); ++i) {
                String partialPath = pathJoiner.join(pathComponents.subList(i, pathComponents.size()));
                File entryFile = new File(directoryFile, partialPath);
                if (!entryFile.exists() || !entryFile.isFile()) continue;
                this.loadEntry(entryFile, true);
                return;
            }
        }
        throw new NotFoundException("Could not find classpath entry %s", entry);
    }

    private void loadEntry(@Nonnull File entryFile, boolean loadOatDependencies) throws IOException, NoDexException {
        List<String> oatDependencies;
        MultiDexContainer<? extends DexBackedDexFile> container;
        if (entryFile == null) {
            ClassPathResolver.$$$reportNull$$$0(13);
        }
        if (this.loadedFiles.contains(entryFile)) {
            return;
        }
        try {
            container = DexFileFactory.loadDexContainer(entryFile, this.opcodes);
        }
        catch (DexFileFactory.UnsupportedFileTypeException ex) {
            throw new ResolveException(ex);
        }
        List<String> entryNames = container.getDexEntryNames();
        if (entryNames.size() == 0) {
            throw new NoDexException("%s contains no dex file", new Object[0]);
        }
        this.loadedFiles.add(entryFile);
        for (String entryName : entryNames) {
            this.classProviders.add(new DexClassProvider(container.getEntry(entryName)));
        }
        if (loadOatDependencies && container instanceof OatFile && !(oatDependencies = ((OatFile)container).getBootClassPath()).isEmpty()) {
            try {
                this.loadOatDependencies(entryFile.getParentFile(), oatDependencies);
            }
            catch (NotFoundException ex) {
                throw new ResolveException(ex, "Error while loading oat file %s", entryFile);
            }
            catch (NoDexException ex) {
                throw new ResolveException(ex, "Error while loading dependencies for oat file %s", entryFile);
            }
        }
    }

    @Nonnull
    private static List<String> splitDevicePath(@Nonnull String path) {
        if (path == null) {
            ClassPathResolver.$$$reportNull$$$0(14);
        }
        ArrayList<String> arrayList = Lists.newArrayList(Splitter.on('/').split(path));
        if (arrayList == null) {
            ClassPathResolver.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    private void loadOatDependencies(@Nonnull File directory, @Nonnull List<String> oatDependencies) throws IOException, NoDexException, NotFoundException {
        if (directory == null) {
            ClassPathResolver.$$$reportNull$$$0(16);
        }
        if (oatDependencies == null) {
            ClassPathResolver.$$$reportNull$$$0(17);
        }
        for (String oatDependency : oatDependencies) {
            String oatDependencyName = this.getFilenameForOatDependency(oatDependency);
            File file = new File(directory, oatDependencyName);
            if (!file.exists()) {
                throw new NotFoundException("Cannot find dependency %s in %s", oatDependencyName, directory);
            }
            this.loadEntry(file, false);
        }
    }

    @Nonnull
    private String getFilenameForOatDependency(String oatDependency) {
        int index = oatDependency.lastIndexOf(47);
        String dependencyLeaf = oatDependency.substring(index + 1);
        if (dependencyLeaf.endsWith(".art")) {
            String string = dependencyLeaf.substring(0, dependencyLeaf.length() - 4) + ".oat";
            if (string == null) {
                ClassPathResolver.$$$reportNull$$$0(18);
            }
            return string;
        }
        String string = dependencyLeaf;
        if (string == null) {
            ClassPathResolver.$$$reportNull$$$0(19);
        }
        return string;
    }

    @Nonnull
    private static List<String> getDefaultBootClassPath(@Nonnull DexFile dexFile, int apiLevel) {
        if (dexFile == null) {
            ClassPathResolver.$$$reportNull$$$0(20);
        }
        if (dexFile instanceof OatFile.OatDexFile) {
            List<String> bcp = ((OatFile.OatDexFile)dexFile).getContainer().getBootClassPath();
            if (!bcp.isEmpty()) {
                for (int i = 0; i < bcp.size(); ++i) {
                    String entry = bcp.get(i);
                    if (!entry.endsWith(".art")) continue;
                    bcp.set(i, entry.substring(0, entry.length() - 4) + ".oat");
                }
                List<String> list = bcp;
                if (list == null) {
                    ClassPathResolver.$$$reportNull$$$0(21);
                }
                return list;
            }
            ArrayList<String> arrayList = Lists.newArrayList("boot.oat");
            if (arrayList == null) {
                ClassPathResolver.$$$reportNull$$$0(22);
            }
            return arrayList;
        }
        if (dexFile instanceof DexBackedOdexFile) {
            List<String> list = ((DexBackedOdexFile)dexFile).getDependencies();
            if (list == null) {
                ClassPathResolver.$$$reportNull$$$0(23);
            }
            return list;
        }
        if (apiLevel <= 8) {
            ArrayList<String> arrayList = Lists.newArrayList("/system/framework/core.jar", "/system/framework/ext.jar", "/system/framework/framework.jar", "/system/framework/android.policy.jar", "/system/framework/services.jar");
            if (arrayList == null) {
                ClassPathResolver.$$$reportNull$$$0(24);
            }
            return arrayList;
        }
        if (apiLevel <= 11) {
            ArrayList<String> arrayList = Lists.newArrayList("/system/framework/core.jar", "/system/framework/bouncycastle.jar", "/system/framework/ext.jar", "/system/framework/framework.jar", "/system/framework/android.policy.jar", "/system/framework/services.jar", "/system/framework/core-junit.jar");
            if (arrayList == null) {
                ClassPathResolver.$$$reportNull$$$0(25);
            }
            return arrayList;
        }
        if (apiLevel <= 13) {
            ArrayList<String> arrayList = Lists.newArrayList("/system/framework/core.jar", "/system/framework/apache-xml.jar", "/system/framework/bouncycastle.jar", "/system/framework/ext.jar", "/system/framework/framework.jar", "/system/framework/android.policy.jar", "/system/framework/services.jar", "/system/framework/core-junit.jar");
            if (arrayList == null) {
                ClassPathResolver.$$$reportNull$$$0(26);
            }
            return arrayList;
        }
        if (apiLevel <= 15) {
            ArrayList<String> arrayList = Lists.newArrayList("/system/framework/core.jar", "/system/framework/core-junit.jar", "/system/framework/bouncycastle.jar", "/system/framework/ext.jar", "/system/framework/framework.jar", "/system/framework/android.policy.jar", "/system/framework/services.jar", "/system/framework/apache-xml.jar", "/system/framework/filterfw.jar");
            if (arrayList == null) {
                ClassPathResolver.$$$reportNull$$$0(27);
            }
            return arrayList;
        }
        if (apiLevel <= 17) {
            ArrayList<String> arrayList = Lists.newArrayList("/system/framework/core.jar", "/system/framework/core-junit.jar", "/system/framework/bouncycastle.jar", "/system/framework/ext.jar", "/system/framework/framework.jar", "/system/framework/telephony-common.jar", "/system/framework/mms-common.jar", "/system/framework/android.policy.jar", "/system/framework/services.jar", "/system/framework/apache-xml.jar");
            if (arrayList == null) {
                ClassPathResolver.$$$reportNull$$$0(28);
            }
            return arrayList;
        }
        if (apiLevel <= 18) {
            ArrayList<String> arrayList = Lists.newArrayList("/system/framework/core.jar", "/system/framework/core-junit.jar", "/system/framework/bouncycastle.jar", "/system/framework/ext.jar", "/system/framework/framework.jar", "/system/framework/telephony-common.jar", "/system/framework/voip-common.jar", "/system/framework/mms-common.jar", "/system/framework/android.policy.jar", "/system/framework/services.jar", "/system/framework/apache-xml.jar");
            if (arrayList == null) {
                ClassPathResolver.$$$reportNull$$$0(29);
            }
            return arrayList;
        }
        if (apiLevel <= 19) {
            ArrayList<String> arrayList = Lists.newArrayList("/system/framework/core.jar", "/system/framework/conscrypt.jar", "/system/framework/core-junit.jar", "/system/framework/bouncycastle.jar", "/system/framework/ext.jar", "/system/framework/framework.jar", "/system/framework/framework2.jar", "/system/framework/telephony-common.jar", "/system/framework/voip-common.jar", "/system/framework/mms-common.jar", "/system/framework/android.policy.jar", "/system/framework/services.jar", "/system/framework/apache-xml.jar", "/system/framework/webviewchromium.jar");
            if (arrayList == null) {
                ClassPathResolver.$$$reportNull$$$0(30);
            }
            return arrayList;
        }
        if (apiLevel <= 22) {
            ArrayList<String> arrayList = Lists.newArrayList("/system/framework/core-libart.jar", "/system/framework/conscrypt.jar", "/system/framework/okhttp.jar", "/system/framework/core-junit.jar", "/system/framework/bouncycastle.jar", "/system/framework/ext.jar", "/system/framework/framework.jar", "/system/framework/telephony-common.jar", "/system/framework/voip-common.jar", "/system/framework/ims-common.jar", "/system/framework/mms-common.jar", "/system/framework/android.policy.jar", "/system/framework/apache-xml.jar");
            if (arrayList == null) {
                ClassPathResolver.$$$reportNull$$$0(31);
            }
            return arrayList;
        }
        if (apiLevel <= 23) {
            ArrayList<String> arrayList = Lists.newArrayList("/system/framework/core-libart.jar", "/system/framework/conscrypt.jar", "/system/framework/okhttp.jar", "/system/framework/core-junit.jar", "/system/framework/bouncycastle.jar", "/system/framework/ext.jar", "/system/framework/framework.jar", "/system/framework/telephony-common.jar", "/system/framework/voip-common.jar", "/system/framework/ims-common.jar", "/system/framework/apache-xml.jar", "/system/framework/org.apache.http.legacy.boot.jar");
            if (arrayList == null) {
                ClassPathResolver.$$$reportNull$$$0(32);
            }
            return arrayList;
        }
        ArrayList<String> arrayList = Lists.newArrayList("/system/framework/core-oj.jar", "/system/framework/core-libart.jar", "/system/framework/conscrypt.jar", "/system/framework/okhttp.jar", "/system/framework/core-junit.jar", "/system/framework/bouncycastle.jar", "/system/framework/ext.jar", "/system/framework/framework.jar", "/system/framework/telephony-common.jar", "/system/framework/voip-common.jar", "/system/framework/ims-common.jar", "/system/framework/apache-xml.jar", "/system/framework/org.apache.http.legacy.boot.jar");
        if (arrayList == null) {
            ClassPathResolver.$$$reportNull$$$0(33);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 15: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 15: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bootClassPathDirs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bootClassPathEntries";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraClassPathEntries";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dexFile";
                break;
            }
            case 10: 
            case 15: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jf/dexlib2/analysis/ClassPathResolver";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryFile";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oatDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jf/dexlib2/analysis/ClassPathResolver";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedClassProviders";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "splitDevicePath";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilenameForOatDependency";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultBootClassPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: 
            case 15: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "loadLocalClassPathEntry";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "loadLocalOrDeviceBootClassPathEntry";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "loadEntry";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "splitDevicePath";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "loadOatDependencies";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultBootClassPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 15: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ResolveException
    extends RuntimeException {
        public ResolveException(String message, Object ... formatArgs) {
            super(String.format(message, formatArgs));
        }

        public ResolveException(Throwable cause) {
            super(cause);
        }

        public ResolveException(Throwable cause, String message, Object ... formatArgs) {
            super(String.format(message, formatArgs), cause);
        }
    }

    private static class NoDexException
    extends Exception {
        public NoDexException(String message, Object ... formatArgs) {
            super(String.format(message, formatArgs));
        }
    }

    private static class NotFoundException
    extends Exception {
        public NotFoundException(String message, Object ... formatArgs) {
            super(String.format(message, formatArgs));
        }
    }
}

