/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.analysis;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.analysis.ArrayProto;
import org.jf.dexlib2.analysis.ClassProto;
import org.jf.dexlib2.analysis.ClassProvider;
import org.jf.dexlib2.analysis.DexClassProvider;
import org.jf.dexlib2.analysis.OdexedFieldInstructionMapper;
import org.jf.dexlib2.analysis.PrimitiveProto;
import org.jf.dexlib2.analysis.TypeProto;
import org.jf.dexlib2.analysis.UnknownClassProto;
import org.jf.dexlib2.analysis.UnresolvedClassException;
import org.jf.dexlib2.analysis.reflection.ReflectionClassDef;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.immutable.ImmutableDexFile;

public class ClassPath {
    @Nonnull
    private final TypeProto unknownClass;
    @Nonnull
    private List<ClassProvider> classProviders;
    private final boolean checkPackagePrivateAccess;
    public final int oatVersion;
    public static final int NOT_ART = -1;
    private final CacheLoader<String, TypeProto> classLoader;
    @Nonnull
    private LoadingCache<String, TypeProto> loadedClasses;
    private final Supplier<OdexedFieldInstructionMapper> fieldInstructionMapperSupplier;

    public ClassPath(ClassProvider ... classProviders) throws IOException {
        this(Arrays.asList(classProviders), false, -1);
    }

    public ClassPath(Iterable<ClassProvider> classProviders) throws IOException {
        this(classProviders, false, -1);
    }

    public ClassPath(@Nonnull Iterable<? extends ClassProvider> classProviders, boolean checkPackagePrivateAccess, int oatVersion) {
        if (classProviders == null) {
            ClassPath.$$$reportNull$$$0(0);
        }
        this.classLoader = new CacheLoader<String, TypeProto>(){

            @Override
            public TypeProto load(String type) throws Exception {
                if (type.charAt(0) == '[') {
                    return new ArrayProto(ClassPath.this, type);
                }
                return new ClassProto(ClassPath.this, type);
            }
        };
        this.loadedClasses = CacheBuilder.newBuilder().build(this.classLoader);
        this.fieldInstructionMapperSupplier = Suppliers.memoize(new Supplier<OdexedFieldInstructionMapper>(){

            @Override
            public OdexedFieldInstructionMapper get() {
                return new OdexedFieldInstructionMapper(ClassPath.this.isArt());
            }
        });
        this.unknownClass = new UnknownClassProto(this);
        this.loadedClasses.put(this.unknownClass.getType(), this.unknownClass);
        this.checkPackagePrivateAccess = checkPackagePrivateAccess;
        this.oatVersion = oatVersion;
        this.loadPrimitiveType("Z");
        this.loadPrimitiveType("B");
        this.loadPrimitiveType("S");
        this.loadPrimitiveType("C");
        this.loadPrimitiveType("I");
        this.loadPrimitiveType("J");
        this.loadPrimitiveType("F");
        this.loadPrimitiveType("D");
        this.loadPrimitiveType("L");
        this.classProviders = Lists.newArrayList(classProviders);
        this.classProviders.add(ClassPath.getBasicClasses());
    }

    private void loadPrimitiveType(String type) {
        this.loadedClasses.put(type, new PrimitiveProto(this, type));
    }

    private static ClassProvider getBasicClasses() {
        return new DexClassProvider(new ImmutableDexFile(Opcodes.getDefault(), (Collection<? extends ClassDef>)ImmutableSet.of(new ReflectionClassDef(Class.class), new ReflectionClassDef(Cloneable.class), new ReflectionClassDef(Object.class), new ReflectionClassDef(Serializable.class), new ReflectionClassDef(String.class), new ReflectionClassDef(Throwable.class), new ReflectionClassDef[0])));
    }

    public boolean isArt() {
        return this.oatVersion != -1;
    }

    @Nonnull
    public TypeProto getClass(@Nonnull CharSequence type) {
        if (type == null) {
            ClassPath.$$$reportNull$$$0(1);
        }
        TypeProto typeProto = this.loadedClasses.getUnchecked(type.toString());
        if (typeProto == null) {
            ClassPath.$$$reportNull$$$0(2);
        }
        return typeProto;
    }

    @Nonnull
    public ClassDef getClassDef(String type) {
        for (ClassProvider provider : this.classProviders) {
            ClassDef classDef = provider.getClassDef(type);
            if (classDef == null) continue;
            ClassDef classDef2 = classDef;
            if (classDef2 == null) {
                ClassPath.$$$reportNull$$$0(3);
            }
            return classDef2;
        }
        throw new UnresolvedClassException("Could not resolve class %s", type);
    }

    @Nonnull
    public TypeProto getUnknownClass() {
        TypeProto typeProto = this.unknownClass;
        if (typeProto == null) {
            ClassPath.$$$reportNull$$$0(4);
        }
        return typeProto;
    }

    public boolean shouldCheckPackagePrivateAccess() {
        return this.checkPackagePrivateAccess;
    }

    @Nonnull
    public OdexedFieldInstructionMapper getFieldInstructionMapper() {
        OdexedFieldInstructionMapper odexedFieldInstructionMapper = this.fieldInstructionMapperSupplier.get();
        if (odexedFieldInstructionMapper == null) {
            ClassPath.$$$reportNull$$$0(5);
        }
        return odexedFieldInstructionMapper;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classProviders";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jf/dexlib2/analysis/ClassPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jf/dexlib2/analysis/ClassPath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getClass";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassDef";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnknownClass";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldInstructionMapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getClass";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

