/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.analysis;

import com.google.common.base.Strings;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.analysis.ClassPath;
import org.jf.dexlib2.analysis.ClassProto;
import org.jf.dexlib2.analysis.TypeProto;
import org.jf.dexlib2.analysis.UnresolvedClassException;
import org.jf.dexlib2.iface.Method;
import org.jf.dexlib2.iface.reference.FieldReference;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.immutable.reference.ImmutableFieldReference;
import org.jf.dexlib2.util.TypeUtils;
import org.jf.util.ExceptionWithContext;

public class ArrayProto
implements TypeProto {
    protected final ClassPath classPath;
    protected final int dimensions;
    protected final String elementType;
    private static final String BRACKETS = Strings.repeat("[", 256);

    public ArrayProto(@Nonnull ClassPath classPath, @Nonnull String type) {
        if (classPath == null) {
            ArrayProto.$$$reportNull$$$0(0);
        }
        if (type == null) {
            ArrayProto.$$$reportNull$$$0(1);
        }
        this.classPath = classPath;
        int i = 0;
        while (type.charAt(i) == '[') {
            if (++i != type.length()) continue;
            throw new ExceptionWithContext("Invalid array type: %s", type);
        }
        if (i == 0) {
            throw new ExceptionWithContext("Invalid array type: %s", type);
        }
        this.dimensions = i;
        this.elementType = type.substring(i);
    }

    public String toString() {
        return this.getType();
    }

    @Override
    @Nonnull
    public ClassPath getClassPath() {
        ClassPath classPath = this.classPath;
        if (classPath == null) {
            ArrayProto.$$$reportNull$$$0(2);
        }
        return classPath;
    }

    @Override
    @Nonnull
    public String getType() {
        String string = ArrayProto.makeArrayType(this.elementType, this.dimensions);
        if (string == null) {
            ArrayProto.$$$reportNull$$$0(3);
        }
        return string;
    }

    public int getDimensions() {
        return this.dimensions;
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Nonnull
    public String getElementType() {
        String string = this.elementType;
        if (string == null) {
            ArrayProto.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nonnull
    public String getImmediateElementType() {
        if (this.dimensions > 1) {
            String string = ArrayProto.makeArrayType(this.elementType, this.dimensions - 1);
            if (string == null) {
                ArrayProto.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = this.elementType;
        if (string == null) {
            ArrayProto.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    public boolean implementsInterface(@Nonnull String iface) {
        if (iface == null) {
            ArrayProto.$$$reportNull$$$0(7);
        }
        return iface.equals("Ljava/lang/Cloneable;") || iface.equals("Ljava/io/Serializable;");
    }

    @Override
    @Nullable
    public String getSuperclass() {
        return "Ljava/lang/Object;";
    }

    @Override
    @Nonnull
    public TypeProto getCommonSuperclass(@Nonnull TypeProto other) {
        if (other == null) {
            ArrayProto.$$$reportNull$$$0(8);
        }
        if (other instanceof ArrayProto) {
            if (TypeUtils.isPrimitiveType(this.getElementType()) || TypeUtils.isPrimitiveType(((ArrayProto)other).getElementType())) {
                if (this.dimensions == ((ArrayProto)other).dimensions && this.getElementType().equals(((ArrayProto)other).getElementType())) {
                    ArrayProto arrayProto = this;
                    if (arrayProto == null) {
                        ArrayProto.$$$reportNull$$$0(9);
                    }
                    return arrayProto;
                }
                TypeProto typeProto = this.classPath.getClass("Ljava/lang/Object;");
                if (typeProto == null) {
                    ArrayProto.$$$reportNull$$$0(10);
                }
                return typeProto;
            }
            if (this.dimensions == ((ArrayProto)other).dimensions) {
                TypeProto otherClass;
                TypeProto mergedClass;
                TypeProto thisClass = this.classPath.getClass(this.elementType);
                if (thisClass == (mergedClass = thisClass.getCommonSuperclass(otherClass = this.classPath.getClass(((ArrayProto)other).elementType)))) {
                    ArrayProto arrayProto = this;
                    if (arrayProto == null) {
                        ArrayProto.$$$reportNull$$$0(11);
                    }
                    return arrayProto;
                }
                if (otherClass == mergedClass) {
                    TypeProto typeProto = other;
                    if (typeProto == null) {
                        ArrayProto.$$$reportNull$$$0(12);
                    }
                    return typeProto;
                }
                TypeProto typeProto = this.classPath.getClass(ArrayProto.makeArrayType(mergedClass.getType(), this.dimensions));
                if (typeProto == null) {
                    ArrayProto.$$$reportNull$$$0(13);
                }
                return typeProto;
            }
            int dimensions = Math.min(this.dimensions, ((ArrayProto)other).dimensions);
            TypeProto typeProto = this.classPath.getClass(ArrayProto.makeArrayType("Ljava/lang/Object;", dimensions));
            if (typeProto == null) {
                ArrayProto.$$$reportNull$$$0(14);
            }
            return typeProto;
        }
        if (other instanceof ClassProto) {
            block19: {
                TypeProto typeProto;
                try {
                    if (!other.isInterface() || !this.implementsInterface(other.getType())) break block19;
                    typeProto = other;
                }
                catch (UnresolvedClassException unresolvedClassException) {
                    // empty catch block
                }
                if (typeProto == null) {
                    ArrayProto.$$$reportNull$$$0(15);
                }
                return typeProto;
            }
            TypeProto typeProto = this.classPath.getClass("Ljava/lang/Object;");
            if (typeProto == null) {
                ArrayProto.$$$reportNull$$$0(16);
            }
            return typeProto;
        }
        TypeProto typeProto = other.getCommonSuperclass(this);
        if (typeProto == null) {
            ArrayProto.$$$reportNull$$$0(17);
        }
        return typeProto;
    }

    @Nonnull
    private static String makeArrayType(@Nonnull String elementType, int dimensions) {
        if (elementType == null) {
            ArrayProto.$$$reportNull$$$0(18);
        }
        String string = BRACKETS.substring(0, dimensions) + elementType;
        if (string == null) {
            ArrayProto.$$$reportNull$$$0(19);
        }
        return string;
    }

    @Override
    @Nullable
    public FieldReference getFieldByOffset(int fieldOffset) {
        if (fieldOffset == 8) {
            return new ImmutableFieldReference(this.getType(), "length", "int");
        }
        return null;
    }

    @Override
    @Nullable
    public Method getMethodByVtableIndex(int vtableIndex) {
        return this.classPath.getClass("Ljava/lang/Object;").getMethodByVtableIndex(vtableIndex);
    }

    @Override
    public int findMethodIndexInVtable(@Nonnull MethodReference method) {
        if (method == null) {
            ArrayProto.$$$reportNull$$$0(20);
        }
        return this.classPath.getClass("Ljava/lang/Object;").findMethodIndexInVtable(method);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jf/dexlib2/analysis/ArrayProto";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iface";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jf/dexlib2/analysis/ArrayProto";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementType";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getImmediateElementType";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonSuperclass";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "makeArrayType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "implementsInterface";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCommonSuperclass";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "makeArrayType";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findMethodIndexInVtable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

