/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.analysis;

import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import java.util.BitSet;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.analysis.MethodAnalyzer;
import org.jf.dexlib2.analysis.RegisterType;
import org.jf.dexlib2.iface.instruction.FiveRegisterInstruction;
import org.jf.dexlib2.iface.instruction.Instruction;
import org.jf.dexlib2.iface.instruction.OneRegisterInstruction;
import org.jf.dexlib2.iface.instruction.ReferenceInstruction;
import org.jf.dexlib2.iface.instruction.RegisterRangeInstruction;
import org.jf.dexlib2.iface.instruction.formats.Instruction22c;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.iface.reference.Reference;
import org.jf.util.ExceptionWithContext;

public class AnalyzedInstruction
implements Comparable<AnalyzedInstruction> {
    @Nonnull
    protected final MethodAnalyzer methodAnalyzer;
    @Nonnull
    protected Instruction instruction;
    protected final int instructionIndex;
    @Nonnull
    protected final TreeSet<AnalyzedInstruction> predecessors;
    @Nonnull
    protected final LinkedList<AnalyzedInstruction> successors;
    @Nonnull
    protected final RegisterType[] preRegisterMap;
    @Nonnull
    protected final RegisterType[] postRegisterMap;
    @Nullable
    protected Map<PredecessorOverrideKey, RegisterType> predecessorRegisterOverrides;
    protected final Instruction originalInstruction;

    public AnalyzedInstruction(@Nonnull MethodAnalyzer methodAnalyzer, @Nonnull Instruction instruction, int instructionIndex, int registerCount) {
        if (methodAnalyzer == null) {
            AnalyzedInstruction.$$$reportNull$$$0(0);
        }
        if (instruction == null) {
            AnalyzedInstruction.$$$reportNull$$$0(1);
        }
        this.predecessors = new TreeSet();
        this.successors = new LinkedList();
        this.predecessorRegisterOverrides = null;
        this.methodAnalyzer = methodAnalyzer;
        this.instruction = instruction;
        this.originalInstruction = instruction;
        this.instructionIndex = instructionIndex;
        this.postRegisterMap = new RegisterType[registerCount];
        this.preRegisterMap = new RegisterType[registerCount];
        RegisterType unknown = RegisterType.getRegisterType((byte)0, null);
        for (int i = 0; i < registerCount; ++i) {
            this.preRegisterMap[i] = unknown;
            this.postRegisterMap[i] = unknown;
        }
    }

    public int getInstructionIndex() {
        return this.instructionIndex;
    }

    public int getPredecessorCount() {
        return this.predecessors.size();
    }

    public SortedSet<AnalyzedInstruction> getPredecessors() {
        return Collections.unmodifiableSortedSet(this.predecessors);
    }

    public RegisterType getPredecessorRegisterType(@Nonnull AnalyzedInstruction predecessor, int registerNumber) {
        RegisterType override;
        if (predecessor == null) {
            AnalyzedInstruction.$$$reportNull$$$0(2);
        }
        if (this.predecessorRegisterOverrides != null && (override = this.predecessorRegisterOverrides.get(new PredecessorOverrideKey(predecessor, registerNumber))) != null) {
            return override;
        }
        return predecessor.postRegisterMap[registerNumber];
    }

    protected boolean addPredecessor(AnalyzedInstruction predecessor) {
        return this.predecessors.add(predecessor);
    }

    protected void addSuccessor(AnalyzedInstruction successor) {
        this.successors.add(successor);
    }

    protected void setDeodexedInstruction(Instruction instruction) {
        assert (this.originalInstruction.getOpcode().odexOnly());
        this.instruction = instruction;
    }

    protected void restoreOdexedInstruction() {
        assert (this.originalInstruction.getOpcode().odexOnly());
        this.instruction = this.originalInstruction;
    }

    @Nonnull
    public List<AnalyzedInstruction> getSuccessors() {
        List<AnalyzedInstruction> list = Collections.unmodifiableList(this.successors);
        if (list == null) {
            AnalyzedInstruction.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nonnull
    public Instruction getInstruction() {
        Instruction instruction = this.instruction;
        if (instruction == null) {
            AnalyzedInstruction.$$$reportNull$$$0(4);
        }
        return instruction;
    }

    @Nonnull
    public Instruction getOriginalInstruction() {
        Instruction instruction = this.originalInstruction;
        if (instruction == null) {
            AnalyzedInstruction.$$$reportNull$$$0(5);
        }
        return instruction;
    }

    public boolean isBeginningInstruction() {
        if (this.predecessors.size() == 0) {
            return false;
        }
        return this.predecessors.first().instructionIndex == -1;
    }

    protected boolean mergeRegister(int registerNumber, RegisterType registerType, BitSet verifiedInstructions, boolean override) {
        RegisterType oldRegisterType;
        assert (registerNumber >= 0 && registerNumber < this.postRegisterMap.length);
        assert (registerType != null);
        RegisterType mergedRegisterType = override ? this.getMergedPreRegisterTypeFromPredecessors(registerNumber) : oldRegisterType.merge(registerType);
        if (mergedRegisterType.equals(oldRegisterType = this.preRegisterMap[registerNumber])) {
            return false;
        }
        this.preRegisterMap[registerNumber] = mergedRegisterType;
        verifiedInstructions.clear(this.instructionIndex);
        if (!this.setsRegister(registerNumber)) {
            this.postRegisterMap[registerNumber] = mergedRegisterType;
            return true;
        }
        return false;
    }

    @Nonnull
    protected RegisterType getMergedPreRegisterTypeFromPredecessors(int registerNumber) {
        RegisterType mergedRegisterType = null;
        for (AnalyzedInstruction predecessor : this.predecessors) {
            RegisterType predecessorRegisterType = this.getPredecessorRegisterType(predecessor, registerNumber);
            if (predecessorRegisterType == null) continue;
            if (mergedRegisterType == null) {
                mergedRegisterType = predecessorRegisterType;
                continue;
            }
            mergedRegisterType = predecessorRegisterType.merge(mergedRegisterType);
        }
        if (mergedRegisterType == null) {
            throw new IllegalStateException();
        }
        RegisterType registerType = mergedRegisterType;
        if (registerType == null) {
            AnalyzedInstruction.$$$reportNull$$$0(6);
        }
        return registerType;
    }

    protected boolean setPostRegisterType(int registerNumber, RegisterType registerType) {
        assert (registerNumber >= 0 && registerNumber < this.postRegisterMap.length);
        assert (registerType != null);
        RegisterType oldRegisterType = this.postRegisterMap[registerNumber];
        if (oldRegisterType.equals(registerType)) {
            return false;
        }
        this.postRegisterMap[registerNumber] = registerType;
        return true;
    }

    protected boolean overridePredecessorRegisterType(@Nonnull AnalyzedInstruction predecessor, int registerNumber, @Nonnull RegisterType registerType, BitSet verifiedInstructions) {
        if (predecessor == null) {
            AnalyzedInstruction.$$$reportNull$$$0(7);
        }
        if (registerType == null) {
            AnalyzedInstruction.$$$reportNull$$$0(8);
        }
        if (this.predecessorRegisterOverrides == null) {
            this.predecessorRegisterOverrides = Maps.newHashMap();
        }
        this.predecessorRegisterOverrides.put(new PredecessorOverrideKey(predecessor, registerNumber), registerType);
        RegisterType mergedType = this.getMergedPreRegisterTypeFromPredecessors(registerNumber);
        if (this.preRegisterMap[registerNumber].equals(mergedType)) {
            return false;
        }
        this.preRegisterMap[registerNumber] = mergedType;
        verifiedInstructions.clear(this.instructionIndex);
        if (!this.setsRegister(registerNumber) && !this.postRegisterMap[registerNumber].equals(mergedType)) {
            this.postRegisterMap[registerNumber] = mergedType;
            return true;
        }
        return false;
    }

    protected boolean isInvokeInit() {
        if (!this.instruction.getOpcode().canInitializeReference()) {
            return false;
        }
        ReferenceInstruction instruction = (ReferenceInstruction)this.instruction;
        Reference reference = instruction.getReference();
        if (reference instanceof MethodReference) {
            return ((MethodReference)reference).getName().equals("<init>");
        }
        return false;
    }

    public boolean setsRegister() {
        return this.instruction.getOpcode().setsRegister();
    }

    public boolean setsWideRegister() {
        return this.instruction.getOpcode().setsWideRegister();
    }

    public boolean setsRegister(int registerNumber) {
        AnalyzedInstruction previousInstruction;
        if (this.isInvokeInit()) {
            int destinationRegister;
            if (this.instruction instanceof FiveRegisterInstruction) {
                destinationRegister = ((FiveRegisterInstruction)this.instruction).getRegisterC();
            } else {
                assert (this.instruction instanceof RegisterRangeInstruction);
                RegisterRangeInstruction rangeInstruction = (RegisterRangeInstruction)this.instruction;
                assert (rangeInstruction.getRegisterCount() > 0);
                destinationRegister = rangeInstruction.getStartRegister();
            }
            if (registerNumber == destinationRegister) {
                return true;
            }
            RegisterType preInstructionDestRegisterType = this.getPreInstructionRegisterType(registerNumber);
            if (preInstructionDestRegisterType.category != 16 && preInstructionDestRegisterType.category != 17) {
                return false;
            }
            return this.getPreInstructionRegisterType(registerNumber).equals(preInstructionDestRegisterType);
        }
        if (this.getPredecessorCount() == 1 && (this.instruction.getOpcode() == Opcode.IF_EQZ || this.instruction.getOpcode() == Opcode.IF_NEZ) && (previousInstruction = this.getPreviousInstruction()) != null && previousInstruction.instruction.getOpcode() == Opcode.INSTANCE_OF && registerNumber == ((Instruction22c)previousInstruction.instruction).getRegisterB() && MethodAnalyzer.canPropogateTypeAfterInstanceOf(previousInstruction, this, this.methodAnalyzer.getClassPath())) {
            return true;
        }
        if (!this.setsRegister()) {
            return false;
        }
        int destinationRegister = this.getDestinationRegister();
        if (registerNumber == destinationRegister) {
            return true;
        }
        return this.setsWideRegister() && registerNumber == destinationRegister + 1;
    }

    @Nullable
    private AnalyzedInstruction getPreviousInstruction() {
        for (AnalyzedInstruction predecessor : this.predecessors) {
            if (predecessor.getInstructionIndex() != this.getInstructionIndex() - 1) continue;
            return predecessor;
        }
        return null;
    }

    public int getDestinationRegister() {
        if (!this.instruction.getOpcode().setsRegister()) {
            throw new ExceptionWithContext("Cannot call getDestinationRegister() for an instruction that doesn't store a value", new Object[0]);
        }
        return ((OneRegisterInstruction)this.instruction).getRegisterA();
    }

    public int getRegisterCount() {
        return this.postRegisterMap.length;
    }

    @Nonnull
    public RegisterType getPostInstructionRegisterType(int registerNumber) {
        RegisterType registerType = this.postRegisterMap[registerNumber];
        if (registerType == null) {
            AnalyzedInstruction.$$$reportNull$$$0(9);
        }
        return registerType;
    }

    @Nonnull
    public RegisterType getPreInstructionRegisterType(int registerNumber) {
        RegisterType registerType = this.preRegisterMap[registerNumber];
        if (registerType == null) {
            AnalyzedInstruction.$$$reportNull$$$0(10);
        }
        return registerType;
    }

    @Override
    public int compareTo(@Nonnull AnalyzedInstruction analyzedInstruction) {
        if (analyzedInstruction == null) {
            AnalyzedInstruction.$$$reportNull$$$0(11);
        }
        if (this.instructionIndex < analyzedInstruction.instructionIndex) {
            return -1;
        }
        if (this.instructionIndex == analyzedInstruction.instructionIndex) {
            return 0;
        }
        return 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodAnalyzer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predecessor";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jf/dexlib2/analysis/AnalyzedInstruction";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registerType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "analyzedInstruction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jf/dexlib2/analysis/AnalyzedInstruction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuccessors";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstruction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalInstruction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMergedPreRegisterTypeFromPredecessors";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPostInstructionRegisterType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreInstructionRegisterType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPredecessorRegisterType";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "overridePredecessorRegisterType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PredecessorOverrideKey {
        public final AnalyzedInstruction analyzedInstruction;
        public final int registerNumber;

        public PredecessorOverrideKey(AnalyzedInstruction analyzedInstruction, int registerNumber) {
            this.analyzedInstruction = analyzedInstruction;
            this.registerNumber = registerNumber;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PredecessorOverrideKey that = (PredecessorOverrideKey)o;
            return Objects.equal(this.registerNumber, that.registerNumber) && Objects.equal(this.analyzedInstruction, that.analyzedInstruction);
        }

        public int hashCode() {
            return Objects.hashCode(this.analyzedInstruction, this.registerNumber);
        }
    }
}

