/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2;

import com.google.common.collect.Maps;
import com.google.common.collect.RangeMap;
import java.util.EnumMap;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.VersionMap;

public class Opcodes {
    public final int api;
    public final int artVersion;
    @Nonnull
    private final Opcode[] opcodesByValue = new Opcode[255];
    @Nonnull
    private final EnumMap<Opcode, Short> opcodeValues;
    @Nonnull
    private final HashMap<String, Opcode> opcodesByName;

    @Nonnull
    public static Opcodes forApi(int api) {
        Opcodes opcodes = new Opcodes(api, -1);
        if (opcodes == null) {
            Opcodes.$$$reportNull$$$0(0);
        }
        return opcodes;
    }

    @Nonnull
    public static Opcodes forArtVersion(int artVersion) {
        Opcodes opcodes = new Opcodes(-1, artVersion);
        if (opcodes == null) {
            Opcodes.$$$reportNull$$$0(1);
        }
        return opcodes;
    }

    @Nonnull
    public static Opcodes getDefault() {
        Opcodes opcodes = Opcodes.forApi(20);
        if (opcodes == null) {
            Opcodes.$$$reportNull$$$0(2);
        }
        return opcodes;
    }

    private Opcodes(int api, int artVersion) {
        if (api >= 21) {
            this.api = api;
            this.artVersion = VersionMap.mapApiToArtVersion(api);
        } else if (artVersion >= 0 && artVersion < 39) {
            this.api = VersionMap.mapArtVersionToApi(artVersion);
            this.artVersion = artVersion;
        } else {
            this.api = api;
            this.artVersion = artVersion;
        }
        this.opcodeValues = new EnumMap(Opcode.class);
        this.opcodesByName = Maps.newHashMap();
        int version = this.isArt() ? this.artVersion : this.api;
        for (Opcode opcode : Opcode.values()) {
            RangeMap<Integer, Short> versionToValueMap = this.isArt() ? opcode.artVersionToValueMap : opcode.apiToValueMap;
            Short opcodeValue = versionToValueMap.get(version);
            if (opcodeValue == null) continue;
            if (!opcode.format.isPayloadFormat) {
                this.opcodesByValue[opcodeValue.shortValue()] = opcode;
            }
            this.opcodeValues.put(opcode, opcodeValue);
            this.opcodesByName.put(opcode.name.toLowerCase(), opcode);
        }
    }

    @Nullable
    public Opcode getOpcodeByName(@Nonnull String opcodeName) {
        if (opcodeName == null) {
            Opcodes.$$$reportNull$$$0(3);
        }
        return this.opcodesByName.get(opcodeName.toLowerCase());
    }

    @Nullable
    public Opcode getOpcodeByValue(int opcodeValue) {
        switch (opcodeValue) {
            case 256: {
                return Opcode.PACKED_SWITCH_PAYLOAD;
            }
            case 512: {
                return Opcode.SPARSE_SWITCH_PAYLOAD;
            }
            case 768: {
                return Opcode.ARRAY_PAYLOAD;
            }
        }
        if (opcodeValue >= 0 && opcodeValue < this.opcodesByValue.length) {
            return this.opcodesByValue[opcodeValue];
        }
        return null;
    }

    @Nullable
    public Short getOpcodeValue(@Nonnull Opcode opcode) {
        if (opcode == null) {
            Opcodes.$$$reportNull$$$0(4);
        }
        return this.opcodeValues.get((Object)opcode);
    }

    public boolean isArt() {
        return this.artVersion != -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jf/dexlib2/Opcodes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "opcodeName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "opcode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "forApi";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "forArtVersion";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefault";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jf/dexlib2/Opcodes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOpcodeByName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getOpcodeValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

