/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.DexBackedOdexFile;
import org.jf.dexlib2.dexbacked.OatFile;
import org.jf.dexlib2.dexbacked.ZipDexContainer;
import org.jf.dexlib2.iface.DexFile;
import org.jf.dexlib2.iface.MultiDexContainer;
import org.jf.dexlib2.writer.pool.DexPool;
import org.jf.util.ExceptionWithContext;

public final class DexFileFactory {
    @Nonnull
    public static DexBackedDexFile loadDexFile(@Nonnull String path, @Nonnull Opcodes opcodes) throws IOException {
        if (path == null) {
            DexFileFactory.$$$reportNull$$$0(0);
        }
        if (opcodes == null) {
            DexFileFactory.$$$reportNull$$$0(1);
        }
        DexBackedDexFile dexBackedDexFile = DexFileFactory.loadDexFile(new File(path), opcodes);
        if (dexBackedDexFile == null) {
            DexFileFactory.$$$reportNull$$$0(2);
        }
        return dexBackedDexFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Nonnull
    public static DexBackedDexFile loadDexFile(@Nonnull File file, @Nonnull Opcodes opcodes) throws IOException {
        DexBackedDexFile dexBackedDexFile;
        if (file == null) {
            DexFileFactory.$$$reportNull$$$0(3);
        }
        if (opcodes == null) {
            DexFileFactory.$$$reportNull$$$0(4);
        }
        if (!file.exists()) {
            throw new DexFileNotFoundException("%s does not exist", file.getName());
        }
        try {
            ZipDexContainer container = new ZipDexContainer(file, opcodes);
            dexBackedDexFile = new DexEntryFinder(file.getPath(), container).findEntry("classes.dex", true);
        }
        catch (ZipDexContainer.NotAZipFileException ex) {
            block21: {
                DexBackedDexFile dexBackedDexFile2;
                BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
                try {
                    dexBackedDexFile2 = DexBackedDexFile.fromInputStream(opcodes, inputStream);
                }
                catch (DexBackedDexFile.NotADexFile ex22222) {
                    DexBackedOdexFile ex22222 = DexBackedOdexFile.fromInputStream(opcodes, inputStream);
                    ((InputStream)inputStream).close();
                    DexBackedOdexFile dexBackedOdexFile = ex22222;
                    if (dexBackedOdexFile == null) {
                        DexFileFactory.$$$reportNull$$$0(7);
                    }
                    return dexBackedOdexFile;
                    {
                        catch (DexBackedOdexFile.NotAnOdexFile ex3) {
                            DexBackedDexFile dexBackedDexFile3;
                            try {
                                OatFile oatFile = null;
                                try {
                                    oatFile = OatFile.fromInputStream(inputStream);
                                }
                                catch (OatFile.NotAnOatFileException ex4) {
                                    // empty catch block
                                }
                                if (oatFile == null) break block21;
                                if (oatFile.isSupportedVersion() == 0) {
                                    throw new UnsupportedOatVersionException(oatFile);
                                }
                                List<OatFile.OatDexFile> oatDexFiles = oatFile.getDexFiles();
                                if (oatDexFiles.size() == 0) {
                                    throw new DexFileNotFoundException("Oat file %s contains no dex files", file.getName());
                                }
                                DexBackedDexFile dexBackedDexFile4 = oatDexFiles.get(0);
                                dexBackedDexFile3 = dexBackedDexFile4;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                ((InputStream)inputStream).close();
                            }
                            if (dexBackedDexFile3 == null) {
                                DexFileFactory.$$$reportNull$$$0(8);
                            }
                            return dexBackedDexFile3;
                        }
                    }
                }
                ((InputStream)inputStream).close();
                DexBackedDexFile dexBackedDexFile5 = dexBackedDexFile2;
                if (dexBackedDexFile5 == null) {
                    DexFileFactory.$$$reportNull$$$0(6);
                }
                return dexBackedDexFile5;
            }
            throw new UnsupportedFileTypeException("%s is not an apk, dex, odex or oat file.", file.getPath());
        }
        if (dexBackedDexFile == null) {
            DexFileFactory.$$$reportNull$$$0(5);
        }
        return dexBackedDexFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DexBackedDexFile loadDexEntry(@Nonnull File file, @Nonnull String dexEntry, boolean exactMatch, @Nonnull Opcodes opcodes) throws IOException {
        if (file == null) {
            DexFileFactory.$$$reportNull$$$0(9);
        }
        if (dexEntry == null) {
            DexFileFactory.$$$reportNull$$$0(10);
        }
        if (opcodes == null) {
            DexFileFactory.$$$reportNull$$$0(11);
        }
        if (!file.exists()) {
            throw new DexFileNotFoundException("Container file %s does not exist", file.getName());
        }
        try {
            ZipDexContainer container = new ZipDexContainer(file, opcodes);
            return new DexEntryFinder(file.getPath(), container).findEntry(dexEntry, exactMatch);
        }
        catch (ZipDexContainer.NotAZipFileException ex) {
            try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));){
                OatFile oatFile = null;
                try {
                    oatFile = OatFile.fromInputStream(inputStream);
                }
                catch (OatFile.NotAnOatFileException ex2) {
                    // empty catch block
                }
                if (oatFile != null) {
                    if (oatFile.isSupportedVersion() == 0) {
                        throw new UnsupportedOatVersionException(oatFile);
                    }
                    List<OatFile.OatDexFile> oatDexFiles = oatFile.getDexFiles();
                    if (oatDexFiles.size() == 0) {
                        throw new DexFileNotFoundException("Oat file %s contains no dex files", file.getName());
                    }
                    DexBackedDexFile dexBackedDexFile = new DexEntryFinder(file.getPath(), oatFile).findEntry(dexEntry, exactMatch);
                    return dexBackedDexFile;
                }
            }
            throw new UnsupportedFileTypeException("%s is not an apk or oat file.", file.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static MultiDexContainer<? extends DexBackedDexFile> loadDexContainer(@Nonnull File file, @Nonnull Opcodes opcodes) throws IOException {
        block16: {
            SingletonMultiDexContainer singletonMultiDexContainer;
            if (file == null) {
                DexFileFactory.$$$reportNull$$$0(12);
            }
            if (opcodes == null) {
                DexFileFactory.$$$reportNull$$$0(13);
            }
            if (!file.exists()) {
                throw new DexFileNotFoundException("%s does not exist", file.getName());
            }
            ZipDexContainer zipDexContainer = new ZipDexContainer(file, opcodes);
            if (zipDexContainer.isZipFile()) {
                return zipDexContainer;
            }
            BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
            try {
                DexBackedDexFile dexFile = DexBackedDexFile.fromInputStream(opcodes, inputStream);
                singletonMultiDexContainer = new SingletonMultiDexContainer(file.getPath(), dexFile);
            }
            catch (DexBackedDexFile.NotADexFile ex) {
                DexBackedOdexFile odexFile = DexBackedOdexFile.fromInputStream(opcodes, inputStream);
                SingletonMultiDexContainer singletonMultiDexContainer2 = new SingletonMultiDexContainer(file.getPath(), odexFile);
                ((InputStream)inputStream).close();
                return singletonMultiDexContainer2;
                {
                    catch (DexBackedOdexFile.NotAnOdexFile ex2) {
                        try {
                            OatFile oatFile = null;
                            try {
                                oatFile = OatFile.fromInputStream(inputStream);
                            }
                            catch (OatFile.NotAnOatFileException ex3) {
                                // empty catch block
                            }
                            if (oatFile != null) {
                                if (oatFile.isSupportedVersion() == 0) {
                                    throw new UnsupportedOatVersionException(oatFile);
                                }
                                OatFile oatFile2 = oatFile;
                                return oatFile2;
                            }
                            break block16;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            ((InputStream)inputStream).close();
                        }
                    }
                }
            }
            ((InputStream)inputStream).close();
            return singletonMultiDexContainer;
        }
        throw new UnsupportedFileTypeException("%s is not an apk, dex, odex or oat file.", file.getPath());
    }

    public static void writeDexFile(@Nonnull String path, @Nonnull DexFile dexFile) throws IOException {
        if (path == null) {
            DexFileFactory.$$$reportNull$$$0(14);
        }
        if (dexFile == null) {
            DexFileFactory.$$$reportNull$$$0(15);
        }
        DexPool.writeTo(path, dexFile);
    }

    private DexFileFactory() {
    }

    private static boolean fullEntryMatch(@Nonnull String entry, @Nonnull String targetEntry) {
        if (entry == null) {
            DexFileFactory.$$$reportNull$$$0(16);
        }
        if (targetEntry == null) {
            DexFileFactory.$$$reportNull$$$0(17);
        }
        if (entry.equals(targetEntry)) {
            return true;
        }
        if (entry.charAt(0) == '/') {
            entry = entry.substring(1);
        }
        if (targetEntry.charAt(0) == '/') {
            targetEntry = targetEntry.substring(1);
        }
        return entry.equals(targetEntry);
    }

    private static boolean partialEntryMatch(String entry, String targetEntry) {
        if (entry.equals(targetEntry)) {
            return true;
        }
        if (!entry.endsWith(targetEntry)) {
            return false;
        }
        char precedingChar = entry.charAt(entry.length() - targetEntry.length() - 1);
        char firstTargetChar = targetEntry.charAt(0);
        return firstTargetChar == ':' || firstTargetChar == '/' || precedingChar == ':' || precedingChar == '/';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 4: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "opcodes";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jf/dexlib2/DexFileFactory";
                break;
            }
            case 3: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dexEntry";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dexFile";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetEntry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jf/dexlib2/DexFileFactory";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDexFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadDexFile";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "loadDexEntry";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "loadDexContainer";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "writeDexFile";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "fullEntryMatch";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SingletonMultiDexContainer
    implements MultiDexContainer<DexBackedDexFile> {
        private final String entryName;
        private final DexBackedDexFile dexFile;

        public SingletonMultiDexContainer(@Nonnull String entryName, @Nonnull DexBackedDexFile dexFile) {
            if (entryName == null) {
                SingletonMultiDexContainer.$$$reportNull$$$0(0);
            }
            if (dexFile == null) {
                SingletonMultiDexContainer.$$$reportNull$$$0(1);
            }
            this.entryName = entryName;
            this.dexFile = dexFile;
        }

        @Override
        @Nonnull
        public List<String> getDexEntryNames() throws IOException {
            ImmutableList<String> immutableList = ImmutableList.of(this.entryName);
            if (immutableList == null) {
                SingletonMultiDexContainer.$$$reportNull$$$0(2);
            }
            return immutableList;
        }

        @Override
        @Nullable
        public DexBackedDexFile getEntry(@Nonnull String entryName) throws IOException {
            if (entryName == null) {
                SingletonMultiDexContainer.$$$reportNull$$$0(3);
            }
            if (entryName.equals(this.entryName)) {
                return this.dexFile;
            }
            return null;
        }

        @Override
        @Nonnull
        public Opcodes getOpcodes() {
            Opcodes opcodes = this.dexFile.getOpcodes();
            if (opcodes == null) {
                SingletonMultiDexContainer.$$$reportNull$$$0(4);
            }
            return opcodes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: {
                    string = "@Nonnull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entryName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dexFile";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jf/dexlib2/DexFileFactory$SingletonMultiDexContainer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jf/dexlib2/DexFileFactory$SingletonMultiDexContainer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDexEntryNames";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOpcodes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getEntry";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static class DexEntryFinder {
        private final String filename;
        private final MultiDexContainer<? extends DexBackedDexFile> dexContainer;

        public DexEntryFinder(@Nonnull String filename, @Nonnull MultiDexContainer<? extends DexBackedDexFile> dexContainer) {
            if (filename == null) {
                DexEntryFinder.$$$reportNull$$$0(0);
            }
            if (dexContainer == null) {
                DexEntryFinder.$$$reportNull$$$0(1);
            }
            this.filename = filename;
            this.dexContainer = dexContainer;
        }

        @Nonnull
        public DexBackedDexFile findEntry(@Nonnull String targetEntry, boolean exactMatch) throws IOException {
            if (targetEntry == null) {
                DexEntryFinder.$$$reportNull$$$0(2);
            }
            if (exactMatch) {
                DexBackedDexFile dexBackedDexFile;
                try {
                    DexBackedDexFile dexFile = this.dexContainer.getEntry(targetEntry);
                    if (dexFile == null) {
                        throw new DexFileNotFoundException("Could not find entry %s in %s.", targetEntry, this.filename);
                    }
                    dexBackedDexFile = dexFile;
                }
                catch (DexBackedDexFile.NotADexFile ex) {
                    throw new UnsupportedFileTypeException("Entry %s in %s is not a dex file", targetEntry, this.filename);
                }
                if (dexBackedDexFile == null) {
                    DexEntryFinder.$$$reportNull$$$0(3);
                }
                return dexBackedDexFile;
            }
            ArrayList<String> fullMatches = Lists.newArrayList();
            ArrayList<DexBackedDexFile> fullEntries = Lists.newArrayList();
            ArrayList<String> partialMatches = Lists.newArrayList();
            ArrayList<DexBackedDexFile> partialEntries = Lists.newArrayList();
            for (String entry : this.dexContainer.getDexEntryNames()) {
                if (DexFileFactory.fullEntryMatch(entry, targetEntry)) {
                    fullMatches.add(entry);
                    fullEntries.add(this.dexContainer.getEntry(entry));
                    continue;
                }
                if (!DexFileFactory.partialEntryMatch(entry, targetEntry)) continue;
                partialMatches.add(entry);
                partialEntries.add(this.dexContainer.getEntry(entry));
            }
            if (fullEntries.size() == 1) {
                DexBackedDexFile dexBackedDexFile;
                try {
                    DexBackedDexFile dexFile = (DexBackedDexFile)fullEntries.get(0);
                    assert (dexFile != null);
                    dexBackedDexFile = dexFile;
                }
                catch (DexBackedDexFile.NotADexFile ex) {
                    throw new UnsupportedFileTypeException("Entry %s in %s is not a dex file", fullMatches.get(0), this.filename);
                }
                if (dexBackedDexFile == null) {
                    DexEntryFinder.$$$reportNull$$$0(4);
                }
                return dexBackedDexFile;
            }
            if (fullEntries.size() > 1) {
                throw new MultipleMatchingDexEntriesException(String.format("Multiple entries in %s match %s: %s", this.filename, targetEntry, Joiner.on(", ").join(fullMatches)), new Object[0]);
            }
            if (partialEntries.size() == 0) {
                throw new DexFileNotFoundException("Could not find a dex entry in %s matching %s", this.filename, targetEntry);
            }
            if (partialEntries.size() > 1) {
                throw new MultipleMatchingDexEntriesException(String.format("Multiple dex entries in %s match %s: %s", this.filename, targetEntry, Joiner.on(", ").join(partialMatches)), new Object[0]);
            }
            DexBackedDexFile dexBackedDexFile = (DexBackedDexFile)partialEntries.get(0);
            if (dexBackedDexFile == null) {
                DexEntryFinder.$$$reportNull$$$0(5);
            }
            return dexBackedDexFile;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@Nonnull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filename";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dexContainer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetEntry";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jf/dexlib2/DexFileFactory$DexEntryFinder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jf/dexlib2/DexFileFactory$DexEntryFinder";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findEntry";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "findEntry";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class UnsupportedFileTypeException
    extends ExceptionWithContext {
        public UnsupportedFileTypeException(@Nonnull String message, Object ... formatArgs) {
            if (message == null) {
                UnsupportedFileTypeException.$$$reportNull$$$0(0);
            }
            super(String.format(message, formatArgs), new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", "message", "org/jf/dexlib2/DexFileFactory$UnsupportedFileTypeException", "<init>"));
        }
    }

    public static class MultipleMatchingDexEntriesException
    extends ExceptionWithContext {
        public MultipleMatchingDexEntriesException(@Nonnull String message, Object ... formatArgs) {
            if (message == null) {
                MultipleMatchingDexEntriesException.$$$reportNull$$$0(0);
            }
            super(String.format(message, formatArgs), new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", "message", "org/jf/dexlib2/DexFileFactory$MultipleMatchingDexEntriesException", "<init>"));
        }
    }

    public static class UnsupportedOatVersionException
    extends ExceptionWithContext {
        @Nonnull
        public final OatFile oatFile;

        public UnsupportedOatVersionException(@Nonnull OatFile oatFile) {
            if (oatFile == null) {
                UnsupportedOatVersionException.$$$reportNull$$$0(0);
            }
            super("Unsupported oat version: %d", oatFile.getOatVersion());
            this.oatFile = oatFile;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", "oatFile", "org/jf/dexlib2/DexFileFactory$UnsupportedOatVersionException", "<init>"));
        }
    }

    public static class DexFileNotFoundException
    extends ExceptionWithContext {
        public DexFileNotFoundException(@Nullable String message, Object ... formatArgs) {
            super(message, formatArgs);
        }
    }
}

