/*
 * Decompiled with CFR 0.152.
 */
package cn.fudan.libpecker.model;

import cn.fudan.analysis.dep.DepAnalysis;
import cn.fudan.analysis.profile.ClassProfile;
import cn.fudan.analysis.util.DexHelper;
import cn.fudan.common.Lib;
import cn.fudan.libpecker.analysis.ClassWeightAnalysis;
import cn.fudan.libpecker.analysis.RootPackageAnalysis;
import cn.fudan.libpecker.model.LibPackageProfile;
import cn.fudan.libpecker.model.SimpleClassProfile;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LibProfile {
    public Map<String, LibPackageProfile> packageProfileMap;
    public Map<String, List<String>> rootPackageMap;

    private LibProfile() {
    }

    public String getRootPackage(String packageName) {
        for (String rootPackageName : this.rootPackageMap.keySet()) {
            for (String pkg : this.rootPackageMap.get(rootPackageName)) {
                if (!pkg.equals(packageName)) continue;
                return rootPackageName;
            }
        }
        return null;
    }

    public List<String> getPackagesWithSameRoot(String packageName) {
        for (String rootPackageName : this.rootPackageMap.keySet()) {
            for (String pkg : this.rootPackageMap.get(rootPackageName)) {
                if (!pkg.equals(packageName)) continue;
                return this.rootPackageMap.get(rootPackageName);
            }
        }
        return null;
    }

    public static LibProfile create(Lib lib, Set<String> targetSdkClassNameSet) {
        LibProfile libProfile = new LibProfile();
        libProfile.rootPackageMap = RootPackageAnalysis.extractRootPackages(lib);
        Map<String, Integer> classBBWeightMap = ClassWeightAnalysis.getClassBBWeight(lib);
        DepAnalysis depAnalysis = new DepAnalysis(lib, (HashSet)targetSdkClassNameSet);
        Map<String, Integer> classDepWeightMap = ClassWeightAnalysis.getClassDepWeight(depAnalysis);
        Map<String, Set<SimpleClassProfile>> packageProfileMap = LibProfile.getClassProfilesGroupedByPackage(depAnalysis.allClassProfiles);
        libProfile.packageProfileMap = new HashMap<String, LibPackageProfile>();
        for (String packageName : packageProfileMap.keySet()) {
            libProfile.packageProfileMap.put(packageName, new LibPackageProfile(packageName, classBBWeightMap, classDepWeightMap, packageProfileMap.get(packageName)));
        }
        classBBWeightMap.clear();
        classDepWeightMap.clear();
        packageProfileMap.clear();
        return libProfile;
    }

    private static Map<String, Set<SimpleClassProfile>> getClassProfilesGroupedByPackage(Set<ClassProfile> classProfileSet) {
        HashMap<String, Set<SimpleClassProfile>> packageClassProfileMap = new HashMap<String, Set<SimpleClassProfile>>();
        for (ClassProfile classProfile : classProfileSet) {
            String packageName = DexHelper.getPackageName(classProfile.getClassName());
            if (!packageClassProfileMap.containsKey(packageName)) {
                packageClassProfileMap.put(packageName, new HashSet());
            }
            ((Set)packageClassProfileMap.get(packageName)).add(classProfile);
        }
        return packageClassProfileMap;
    }
}

