/*
 * Decompiled with CFR 0.152.
 */
package cn.fudan.libpecker.model;

import cn.fudan.analysis.profile.ClassProfile;
import cn.fudan.libpecker.model.CachedClassProfile;
import cn.fudan.libpecker.model.SimpleClassProfile;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LibPackageProfile
implements Serializable {
    static final long serialVersionUID = 179792987844872412L;
    public String packageName;
    public Map<String, Integer> classBBWeightMap;
    public Map<String, Integer> classDepWeightMap;
    public Map<String, SimpleClassProfile> classProfileMap;
    public int includeClassNum;
    private Map<String, Double> classWeights = null;
    private double packageWeight = 0.0;

    public LibPackageProfile(String packageName, Map<String, Integer> classBBWeightMap, Map<String, Integer> classDepWeightMap, Set<SimpleClassProfile> simpleLibClassProfiles) {
        this.packageName = packageName;
        this.classBBWeightMap = new HashMap<String, Integer>();
        this.classDepWeightMap = new HashMap<String, Integer>();
        this.classProfileMap = new HashMap<String, SimpleClassProfile>();
        for (SimpleClassProfile classProfile : simpleLibClassProfiles) {
            this.classBBWeightMap.put(classProfile.getClassName(), classBBWeightMap.get(classProfile.getClassName()));
            this.classDepWeightMap.put(classProfile.getClassName(), classDepWeightMap.get(classProfile.getClassName()));
            this.classProfileMap.put(classProfile.getClassName(), classProfile);
        }
        this.includeClassNum = this.classProfileMap.size();
    }

    private synchronized void constructClassWeights() {
        HashMap<String, Double> classRanks = new HashMap<String, Double>();
        for (String className : this.classBBWeightMap.keySet()) {
            double bbWeight = this.classBBWeightMap.get(className).intValue();
            double depWeight = this.classDepWeightMap.get(className).intValue();
            classRanks.put(className, bbWeight + (depWeight += 1.0));
        }
        Iterator<String> iterator = classRanks.values().iterator();
        while (iterator.hasNext()) {
            double weight = (Double)((Object)iterator.next());
            this.packageWeight += weight;
        }
        this.classWeights = new HashMap<String, Double>();
        for (String className : classRanks.keySet()) {
            this.classWeights.put(className, (Double)classRanks.get(className) / this.packageWeight);
        }
    }

    public double getPackageWeight() {
        if (this.classWeights == null) {
            this.constructClassWeights();
        }
        return this.packageWeight;
    }

    public double getClassWeight(String className) {
        if (this.classWeights == null) {
            this.constructClassWeights();
        }
        return this.classWeights.get(className);
    }

    public Set<String> getClassList() {
        return this.classWeights.keySet();
    }

    public List<String> getWeightClassList() {
        if (this.classWeights == null) {
            this.constructClassWeights();
        }
        ArrayList<String> classNames = new ArrayList<String>(this.classWeights.keySet());
        Collections.sort(classNames, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (((Double)LibPackageProfile.this.classWeights.get(o1)).equals(LibPackageProfile.this.classWeights.get(o2))) {
                    return 0;
                }
                return (Double)LibPackageProfile.this.classWeights.get(o1) < (Double)LibPackageProfile.this.classWeights.get(o2) ? 1 : -1;
            }
        });
        return classNames;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.packageName);
        out.writeObject(this.classBBWeightMap);
        out.writeObject(this.classDepWeightMap);
        HashMap<String, SimpleClassProfile> cachedClassProfileMap = new HashMap<String, SimpleClassProfile>();
        for (String className : this.classProfileMap.keySet()) {
            if (this.classProfileMap.get(className) instanceof CachedClassProfile) {
                cachedClassProfileMap.put(className, this.classProfileMap.get(className));
                continue;
            }
            cachedClassProfileMap.put(className, CachedClassProfile.create((ClassProfile)this.classProfileMap.get(className)));
        }
        out.writeObject(cachedClassProfileMap);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.packageName = (String)in.readObject();
        this.classBBWeightMap = (Map)in.readObject();
        this.classDepWeightMap = (Map)in.readObject();
        this.classProfileMap = (Map)in.readObject();
    }
}

