/*
 * Decompiled with CFR 0.152.
 */
package cn.fudan.libpecker.model;

import cn.fudan.analysis.profile.ClassProfile;
import cn.fudan.analysis.profile.FieldProfile;
import cn.fudan.analysis.profile.MethodProfile;
import cn.fudan.libpecker.model.SimpleClassProfile;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class CachedClassProfile
implements Serializable,
SimpleClassProfile {
    static final long serialVersionUID = 197792367124872413L;
    private String className;
    private String classHash;
    private String classHashStrict;
    private String basicHash;
    private String basicHashStrict;
    private List<String> methodHashList;
    private List<String> fieldHashList;
    private List<String> methodHashStrictList;
    private List<String> fieldHashStrictList;

    private CachedClassProfile() {
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.className);
        out.writeObject(this.classHash);
        out.writeObject(this.classHashStrict);
        out.writeObject(this.basicHash);
        out.writeObject(this.basicHashStrict);
        out.writeObject(this.methodHashList);
        out.writeObject(this.fieldHashList);
        out.writeObject(this.methodHashStrictList);
        out.writeObject(this.fieldHashStrictList);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.className = (String)in.readObject();
        this.classHash = (String)in.readObject();
        this.classHashStrict = (String)in.readObject();
        this.basicHash = (String)in.readObject();
        this.basicHashStrict = (String)in.readObject();
        this.methodHashList = (List)in.readObject();
        this.fieldHashList = (List)in.readObject();
        this.methodHashStrictList = (List)in.readObject();
        this.fieldHashStrictList = (List)in.readObject();
    }

    public static CachedClassProfile create(ClassProfile classProfile) {
        CachedClassProfile cachedClassProfile = new CachedClassProfile();
        cachedClassProfile.className = classProfile.getClassName();
        cachedClassProfile.classHash = classProfile.getClassHash();
        cachedClassProfile.classHashStrict = classProfile.getClassHashStrict();
        cachedClassProfile.basicHash = classProfile.getBasicHash();
        cachedClassProfile.basicHashStrict = classProfile.getBasicHashStrict();
        cachedClassProfile.methodHashList = new ArrayList<String>();
        cachedClassProfile.methodHashStrictList = new ArrayList<String>();
        for (MethodProfile methodProfile : classProfile.staticMethodProfiles) {
            cachedClassProfile.methodHashList.add(ClassProfile.getMethodHash(methodProfile));
            cachedClassProfile.methodHashStrictList.add(ClassProfile.getMethodHashStrict(methodProfile));
        }
        for (MethodProfile methodProfile : classProfile.instanceMethodProfiles) {
            cachedClassProfile.methodHashList.add(ClassProfile.getMethodHash(methodProfile));
            cachedClassProfile.methodHashStrictList.add(ClassProfile.getMethodHashStrict(methodProfile));
        }
        cachedClassProfile.fieldHashList = new ArrayList<String>();
        cachedClassProfile.fieldHashStrictList = new ArrayList<String>();
        for (FieldProfile fieldProfile : classProfile.staticFieldProfiles) {
            if (fieldProfile.isFinal() && fieldProfile.field.getName().equals("serialVersionUID")) continue;
            cachedClassProfile.fieldHashList.add(ClassProfile.getFieldHash(fieldProfile));
            cachedClassProfile.fieldHashStrictList.add(ClassProfile.getFieldHashStrict(fieldProfile));
        }
        for (FieldProfile fieldProfile : classProfile.instanceFieldProfiles) {
            if (fieldProfile.isFinal() && fieldProfile.field.getName().equals("serialVersionUID")) continue;
            cachedClassProfile.fieldHashList.add(ClassProfile.getFieldHash(fieldProfile));
            cachedClassProfile.fieldHashStrictList.add(ClassProfile.getFieldHashStrict(fieldProfile));
        }
        return cachedClassProfile;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public String getClassHash() {
        return this.classHash;
    }

    @Override
    public String getClassHashStrict() {
        return this.classHashStrict;
    }

    @Override
    public String getBasicHash() {
        return this.basicHash;
    }

    @Override
    public String getBasicHashStrict() {
        return this.basicHashStrict;
    }

    @Override
    public List<String> getMethodHashList() {
        return this.methodHashList;
    }

    @Override
    public List<String> getMethodHashStrictList() {
        return this.methodHashStrictList;
    }

    @Override
    public List<String> getFieldHashList() {
        return this.fieldHashList;
    }

    @Override
    public List<String> getFieldHashStrictList() {
        return this.fieldHashStrictList;
    }
}

