/*
 * Decompiled with CFR 0.152.
 */
package cn.fudan.libpecker.model;

import cn.fudan.analysis.profile.ClassProfile;
import cn.fudan.analysis.profile.ProfileGenerator;
import cn.fudan.analysis.tree.PackageNode;
import cn.fudan.libpecker.model.CachedClassProfile;
import cn.fudan.libpecker.model.SimpleClassProfile;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ApkPackageProfile
implements Serializable {
    static final long serialVersionUID = 179792789887672412L;
    public String packageName;
    public Map<String, Integer> classBBWeightMap;
    public Map<String, Integer> classDepWeightMap;
    public Map<String, SimpleClassProfile> classProfileMap = new HashMap<String, SimpleClassProfile>();
    public int includeClassNum;
    public int subPackagesNum;

    protected void finalize() {
        this.packageName = null;
        this.classProfileMap.clear();
        this.classBBWeightMap.clear();
        this.classDepWeightMap.clear();
    }

    public ApkPackageProfile(PackageNode packageNode, Set<String> targetSdkClassNameSet) {
        this.packageName = packageNode.getPackageName();
        Set<ClassProfile> classProfiles = ProfileGenerator.generate(packageNode, targetSdkClassNameSet);
        for (ClassProfile classProfile : classProfiles) {
            this.classProfileMap.put(classProfile.getClassName(), classProfile);
        }
        this.subPackagesNum = packageNode.getSubPackagesNum();
        this.includeClassNum = this.classProfileMap.size();
    }

    public ApkPackageProfile(PackageNode packageNode, Map<String, Integer> classBBWeightMap, Map<String, Integer> classDepWeightMap, Set<String> targetSdkClassNameSet) {
        this.packageName = packageNode.getPackageName();
        this.subPackagesNum = packageNode.getSubPackagesNum();
        this.includeClassNum = packageNode.getIncludedClassNum();
        this.classBBWeightMap = new HashMap<String, Integer>();
        this.classDepWeightMap = new HashMap<String, Integer>();
        Set<ClassProfile> classProfiles = ProfileGenerator.generate(packageNode, targetSdkClassNameSet);
        for (ClassProfile classProfile : classProfiles) {
            this.classProfileMap.put(classProfile.getClassName(), classProfile);
            this.classBBWeightMap.put(classProfile.getClassName(), classBBWeightMap.get(classProfile.getClassName()));
            this.classDepWeightMap.put(classProfile.getClassName(), classDepWeightMap.get(classProfile.getClassName()));
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.packageName);
        HashMap<String, SimpleClassProfile> cachedClassProfileMap = new HashMap<String, SimpleClassProfile>();
        for (String className : this.classProfileMap.keySet()) {
            if (this.classProfileMap.get(className) instanceof CachedClassProfile) {
                cachedClassProfileMap.put(className, this.classProfileMap.get(className));
                continue;
            }
            cachedClassProfileMap.put(className, CachedClassProfile.create((ClassProfile)this.classProfileMap.get(className)));
        }
        out.writeObject(cachedClassProfileMap);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.packageName = (String)in.readObject();
        this.classProfileMap = (Map)in.readObject();
    }
}

