/*
 * Decompiled with CFR 0.152.
 */
package cn.fudan.libpecker.main;

import cn.fudan.common.Apk;
import cn.fudan.common.Lib;
import cn.fudan.common.LibPeckerConfig;
import cn.fudan.common.Sdk;
import cn.fudan.common.util.PackageNameUtil;
import cn.fudan.libpecker.core.LibApkMapper;
import cn.fudan.libpecker.core.PackageMapEnumerator;
import cn.fudan.libpecker.core.PackagePairCandidate;
import cn.fudan.libpecker.model.ApkPackageProfile;
import cn.fudan.libpecker.model.ApkProfile;
import cn.fudan.libpecker.model.LibPackageProfile;
import cn.fudan.libpecker.model.LibProfile;
import cn.fudan.libpecker.model.SimpleClassProfile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ProfileBasedLibPecker {
    Set<String> targetSdkClassNameSet;
    LibProfile libProfile;
    public Map<String, ApkPackageProfile> apkPackageProfileMap;
    public Map<String, LibPackageProfile> libPackageProfileMap;
    private LibApkMapper maxPartition = null;

    public ProfileBasedLibPecker(LibProfile libProfile, ApkProfile apkProfile, Set<String> targetSdkClassNameSet) {
        this.targetSdkClassNameSet = targetSdkClassNameSet;
        this.libProfile = libProfile;
        this.apkPackageProfileMap = apkProfile.packageProfileMap;
        this.libPackageProfileMap = this.libProfile.packageProfileMap;
    }

    public double calculateMaxProbability() {
        ArrayList<String> libClassBasicSigList = new ArrayList<String>();
        ArrayList<String> apkClassBasicSigList = new ArrayList<String>();
        for (ApkPackageProfile apkPackageProfile : this.apkPackageProfileMap.values()) {
            for (SimpleClassProfile simpleClassProfile : apkPackageProfile.classProfileMap.values()) {
                apkClassBasicSigList.add(simpleClassProfile.getBasicHashStrict());
            }
        }
        for (LibPackageProfile libPackageProfile : this.libPackageProfileMap.values()) {
            for (SimpleClassProfile simpleClassProfile : libPackageProfile.classProfileMap.values()) {
                libClassBasicSigList.add(simpleClassProfile.getBasicHashStrict());
            }
        }
        int matchLibClassBasicHashSize = 0;
        for (String basicClassHash : libClassBasicSigList) {
            if (!apkClassBasicSigList.contains(basicClassHash)) continue;
            ++matchLibClassBasicHashSize;
            apkClassBasicSigList.remove(basicClassHash);
        }
        double d = 1.0 * (double)matchLibClassBasicHashSize / (double)libClassBasicSigList.size();
        if (d < 0.5) {
            if (LibPeckerConfig.DEBUG_LIBPECKER) {
                System.out.println("classBasicHashRatio not exceed threshold: " + d);
            }
            return d;
        }
        HashMap<String, PackagePairCandidate> libPackagePairCandidateMap = new HashMap<String, PackagePairCandidate>();
        for (LibPackageProfile libPackageProfile : this.libPackageProfileMap.values()) {
            PackagePairCandidate candidatePackages = new PackagePairCandidate(libPackageProfile, this.apkPackageProfileMap.values());
            libPackagePairCandidateMap.put(libPackageProfile.packageName, candidatePackages);
            if (!LibPeckerConfig.DEBUG_LIBPECKER) continue;
            System.out.println(libPackageProfile.packageName + ", weight: " + libPackageProfile.getPackageWeight());
            for (ApkPackageProfile apkPackageProfile : candidatePackages.getCandiApkPackages()) {
                System.out.println("\t" + apkPackageProfile.packageName + ", " + candidatePackages.getApkPackageSimilarity(apkPackageProfile));
            }
        }
        LibApkMapper mapper = new LibApkMapper(this.libPackageProfileMap, this.apkPackageProfileMap, this.libProfile.rootPackageMap);
        for (PackagePairCandidate packageCandidate : new ArrayList(libPackagePairCandidateMap.values())) {
            ApkPackageProfile perfectMatch = packageCandidate.perfectMatch();
            if (perfectMatch == null) continue;
            boolean paired = mapper.makePair(packageCandidate, perfectMatch);
            if (!paired) {
                throw new RuntimeException("can not be true");
            }
            packageCandidate.justKeepPerfectMatch();
        }
        for (String libPackageName : mapper.getExistingPackageMap().keySet()) {
            if (libPackageName.equals(".")) continue;
            String parentPackageName = PackageNameUtil.getParentPackageName(libPackageName);
            String rootPackageName = this.libProfile.getRootPackage(libPackageName);
            while (parentPackageName.length() >= rootPackageName.length()) {
                for (PackagePairCandidate packageCandidate : libPackagePairCandidateMap.values()) {
                    packageCandidate.filterRootPackageName(parentPackageName);
                }
                parentPackageName = PackageNameUtil.getParentPackageName(parentPackageName);
            }
        }
        double d2 = mapper.similarityUpperBound(libPackagePairCandidateMap);
        if (d2 < 0.5) {
            if (LibPeckerConfig.DEBUG_LIBPECKER) {
                System.out.println("similarityUpperBound not exceed threshold: " + d2);
            }
            return d2;
        }
        PackageMapEnumerator packageMapEnumerator = new PackageMapEnumerator(libPackagePairCandidateMap, mapper);
        List<LibApkMapper> allPartitions = packageMapEnumerator.exhaustiveEnumerate();
        if (LibPeckerConfig.DEBUG_LIBPECKER) {
            System.out.println();
            System.out.println(packageMapEnumerator);
        }
        double maxSimilarity = 0.0;
        for (LibApkMapper partition : allPartitions) {
            double similarity = partition.similarity(libPackagePairCandidateMap);
            if (LibPeckerConfig.DEBUG_LIBPECKER) {
                System.out.println("similarity: " + similarity);
                System.out.println(partition);
            }
            if (!(maxSimilarity < similarity)) continue;
            maxSimilarity = similarity;
            this.maxPartition = partition;
        }
        if (LibPeckerConfig.DEBUG_LIBPECKER) {
            System.out.println(this.maxPartition);
        }
        return maxSimilarity;
    }

    public LibApkMapper getMaxPartition() {
        if (this.maxPartition == null) {
            this.calculateMaxProbability();
        }
        return this.maxPartition;
    }

    private static void fail(String message) {
        System.err.println(message);
        System.exit(0);
    }

    public static double singleMain(String apkPath, String libPath) {
        Sdk sdk;
        Lib lib;
        Apk apk = Apk.loadFromFile(apkPath);
        if (apk == null) {
            ProfileBasedLibPecker.fail("apk not parsed");
        }
        if ((lib = Lib.loadFromFile(libPath)) == null) {
            ProfileBasedLibPecker.fail("lib not parsed");
        }
        if ((sdk = Sdk.loadDefaultSdk()) == null) {
            ProfileBasedLibPecker.fail("default sdk not parsed");
        }
        Set<String> targetSdkClassNameSet = sdk.getTargetSdkClassNameSet();
        LibProfile libProfile = LibProfile.create(lib, targetSdkClassNameSet);
        ApkProfile apkProfile = ApkProfile.create(apk, targetSdkClassNameSet);
        ProfileBasedLibPecker pecker = new ProfileBasedLibPecker(libProfile, apkProfile, targetSdkClassNameSet);
        double similarity = pecker.calculateMaxProbability();
        return similarity;
    }

    public static void main(String[] args) {
        String apkPath = null;
        String libPath = null;
        if (args == null || args.length == 2) {
            apkPath = args[0];
            libPath = args[1];
        } else {
            ProfileBasedLibPecker.fail("Usage: java -cp LibPecker.jar cn.fudan.libpecker.mainProfileBasedLibPecker <apk_path> <lib_path>");
        }
        long current = System.currentTimeMillis();
        double similarity = ProfileBasedLibPecker.singleMain(apkPath, libPath);
        System.out.println("similarity: " + similarity);
        System.out.println("time: " + (System.currentTimeMillis() - current));
    }
}

