/*
 * Decompiled with CFR 0.152.
 */
package cn.fudan.libpecker.core;

import cn.fudan.common.LibPeckerConfig;
import cn.fudan.libpecker.model.ApkPackageProfile;
import cn.fudan.libpecker.model.LibPackageProfile;
import cn.fudan.libpecker.model.SimpleClassProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ProfileComparator {
    private static double getClassMatchSimilarityThreshold(SimpleClassProfile libClassProfile) {
        int memberCount = 1 + libClassProfile.getMethodHashList().size() + libClassProfile.getFieldHashList().size();
        if (memberCount <= 5) {
            return 1.0;
        }
        if (memberCount <= 10) {
            return 0.9;
        }
        if (memberCount <= 15) {
            return 0.8;
        }
        if (memberCount <= 20) {
            return 0.7;
        }
        if (memberCount <= 25) {
            return 0.6;
        }
        return 0.5;
    }

    public static double rawPackageSimilarity(LibPackageProfile libPackageProfile, ApkPackageProfile apkPackageProfile, Map<String, String> classNameMap, Map<String, Double> classRawSimilarity) {
        List<String> weightedClassList = libPackageProfile.getWeightClassList();
        for (String libClassName : weightedClassList) {
            SimpleClassProfile simpleLibClassProfile = libPackageProfile.classProfileMap.get(libClassName);
            double RAW_CLASS_SIMILARITY_THRESHOLD = ProfileComparator.getClassMatchSimilarityThreshold(simpleLibClassProfile);
            SimpleClassProfile bestMatchApkClassProfile = null;
            double maxSimilarity = 0.0;
            for (SimpleClassProfile apkClassProfile : apkPackageProfile.classProfileMap.values()) {
                double similarity;
                if (classNameMap.values().contains(apkClassProfile.getClassName()) || !((similarity = ProfileComparator.rawClassSimilarity(simpleLibClassProfile, apkClassProfile)) >= RAW_CLASS_SIMILARITY_THRESHOLD) || !(similarity > maxSimilarity)) continue;
                maxSimilarity = similarity;
                bestMatchApkClassProfile = apkClassProfile;
            }
            if (bestMatchApkClassProfile != null) {
                classNameMap.put(libClassName, bestMatchApkClassProfile.getClassName());
                classRawSimilarity.put(libClassName, maxSimilarity);
                continue;
            }
            classNameMap.put(libClassName, null);
            classRawSimilarity.put(libClassName, 0.0);
        }
        double weightedSimilarity = 0.0;
        for (String libClassName : weightedClassList) {
            if (LibPeckerConfig.DEBUG_LIBPECKER && libPackageProfile.packageName.equals(LibPeckerConfig.DEBUG_LIBPECKER_LIB_PKG_NAME) && apkPackageProfile.packageName.equals(LibPeckerConfig.DEBUG_LIBPECKER_APK_PKG_NAME)) {
                System.out.println("\t class name: " + libClassName);
                System.out.println("\t\t class weight: " + libPackageProfile.getClassWeight(libClassName));
                System.out.println("\t\t class similarity: " + classRawSimilarity.get(libClassName));
                System.out.println("\t\t class match: " + classNameMap.get(libClassName));
            }
            weightedSimilarity += classRawSimilarity.get(libClassName) * libPackageProfile.getClassWeight(libClassName);
        }
        return weightedSimilarity;
    }

    public static double rawClassSimilarity(SimpleClassProfile libClassProfile, SimpleClassProfile apkClassProfile) {
        int i;
        String apkClassHash = apkClassProfile.getClassHash();
        if (libClassProfile.getClassHash().equals(apkClassHash)) {
            return 1.0;
        }
        if (libClassProfile.getClassHashStrict().equals(apkClassProfile.getClassHashStrict())) {
            return 1.0;
        }
        if (!libClassProfile.getBasicHash().equals(apkClassProfile.getBasicHash()) && !libClassProfile.getBasicHashStrict().equals(apkClassProfile.getBasicHashStrict())) {
            return 0.0;
        }
        ArrayList<String> apkMethodHashList = new ArrayList<String>(apkClassProfile.getMethodHashList());
        ArrayList<String> apkFieldHashList = new ArrayList<String>(apkClassProfile.getFieldHashList());
        double rate = 1.0 * (double)(libClassProfile.getMethodHashList().size() + libClassProfile.getFieldHashList().size()) / (double)(apkMethodHashList.size() + apkFieldHashList.size());
        if (rate > 1.0) {
            rate = 1.0;
        }
        int sameCounter = 1;
        for (i = 0; i < libClassProfile.getMethodHashList().size(); ++i) {
            if (apkMethodHashList.contains(libClassProfile.getMethodHashList().get(i))) {
                ++sameCounter;
                apkMethodHashList.remove(libClassProfile.getMethodHashList().get(i));
                continue;
            }
            if (!apkMethodHashList.contains(libClassProfile.getMethodHashStrictList().get(i))) continue;
            ++sameCounter;
            apkMethodHashList.remove(libClassProfile.getMethodHashStrictList().get(i));
        }
        for (i = 0; i < libClassProfile.getFieldHashList().size(); ++i) {
            if (apkFieldHashList.contains(libClassProfile.getFieldHashList().get(i))) {
                ++sameCounter;
                apkFieldHashList.remove(libClassProfile.getFieldHashList().get(i));
                continue;
            }
            if (!apkFieldHashList.contains(libClassProfile.getFieldHashStrictList().get(i))) continue;
            ++sameCounter;
            apkFieldHashList.remove(libClassProfile.getFieldHashStrictList().get(i));
        }
        double similarity = rate * (double)sameCounter / (double)(1 + libClassProfile.getFieldHashList().size() + libClassProfile.getMethodHashList().size());
        return similarity;
    }
}

