/*
 * Decompiled with CFR 0.152.
 */
package cn.fudan.libpecker.core;

import cn.fudan.common.LibPeckerConfig;
import cn.fudan.common.util.PackageNameUtil;
import cn.fudan.libpecker.core.ProfileComparator;
import cn.fudan.libpecker.model.ApkPackageProfile;
import cn.fudan.libpecker.model.LibPackageProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PackagePairCandidate {
    public static final double PACKAGE_CANDIDATE_FILTER = 0.4;
    public String libPackageName;
    public LibPackageProfile libPackageProfile;
    private List<ApkPackageProfile> apkPackageProfiles;
    private List<Double> candiApkPackageSimilarity;
    private Map<ApkPackageProfile, Map<String, String>> apkPackageClassNameMap;

    public PackagePairCandidate(LibPackageProfile libPackage, Collection<ApkPackageProfile> apkPackages) {
        this.libPackageProfile = libPackage;
        this.libPackageName = libPackage.packageName;
        this.apkPackageProfiles = new ArrayList<ApkPackageProfile>();
        this.candiApkPackageSimilarity = new ArrayList<Double>();
        this.apkPackageClassNameMap = new HashMap<ApkPackageProfile, Map<String, String>>();
        for (ApkPackageProfile apkPackage : apkPackages) {
            this.matchClassHashPercent(apkPackage);
        }
    }

    private void matchClassHashPercent(ApkPackageProfile apkPackageProfile) {
        HashMap<String, String> classNameMap = new HashMap<String, String>();
        HashMap<String, Double> classRawSimilarity = new HashMap<String, Double>();
        double weightedSimilarity = ProfileComparator.rawPackageSimilarity(this.libPackageProfile, apkPackageProfile, classNameMap, classRawSimilarity);
        if (LibPeckerConfig.DEBUG_LIBPECKER) {
            System.out.println("[pkg-level] " + this.libPackageName + " : " + apkPackageProfile.packageName + " : " + weightedSimilarity);
        }
        if (weightedSimilarity >= 0.4) {
            this.apkPackageProfiles.add(apkPackageProfile);
            this.candiApkPackageSimilarity.add(weightedSimilarity);
            this.apkPackageClassNameMap.put(apkPackageProfile, classNameMap);
        }
        if (this.libPackageName.equals(apkPackageProfile.packageName)) {
            this.apkPackageProfiles.add(apkPackageProfile);
            this.candiApkPackageSimilarity.add(weightedSimilarity);
            this.apkPackageClassNameMap.put(apkPackageProfile, classNameMap);
        }
    }

    public List<ApkPackageProfile> getCandiApkPackages() {
        return this.apkPackageProfiles;
    }

    public double getApkPackageSimilarity(ApkPackageProfile apkPackageProfile) {
        if (this.apkPackageProfiles.contains(apkPackageProfile)) {
            return this.candiApkPackageSimilarity.get(this.apkPackageProfiles.indexOf(apkPackageProfile));
        }
        return 0.0;
    }

    public double getApkPackageSimilarity(String apkPackageName) {
        for (ApkPackageProfile apkPackageProfile : this.apkPackageProfiles) {
            if (!apkPackageProfile.packageName.equals(apkPackageName)) continue;
            return this.candiApkPackageSimilarity.get(this.apkPackageProfiles.indexOf(apkPackageProfile));
        }
        return 0.0;
    }

    public Map<String, String> getClassNameMap(ApkPackageProfile apkPackageProfile) {
        return this.apkPackageClassNameMap.get(apkPackageProfile);
    }

    public double getMaxSimilarity() {
        double maxSimilarity = 0.0;
        for (Double similarity : this.candiApkPackageSimilarity) {
            if (!(maxSimilarity < similarity)) continue;
            maxSimilarity = similarity;
        }
        return maxSimilarity;
    }

    public ApkPackageProfile getMaxSimilarityCandiPackage() {
        ApkPackageProfile maxSimilarityPackage = null;
        double maxSimilarity = 0.0;
        for (int i = 0; i < this.apkPackageProfiles.size(); ++i) {
            double similarity = this.candiApkPackageSimilarity.get(i);
            if (!(maxSimilarity < similarity)) continue;
            maxSimilarity = similarity;
            maxSimilarityPackage = this.apkPackageProfiles.get(i);
        }
        return maxSimilarityPackage;
    }

    public ApkPackageProfile perfectMatch() {
        if (this.libPackageName.equals(".")) {
            return null;
        }
        for (ApkPackageProfile profile : this.apkPackageProfiles) {
            if (!profile.packageName.equals(this.libPackageName)) continue;
            return profile;
        }
        return null;
    }

    public void justKeepPerfectMatch() {
        ApkPackageProfile perfectMatch = this.perfectMatch();
        this.apkPackageProfiles.clear();
        this.apkPackageProfiles.add(perfectMatch);
        this.candiApkPackageSimilarity.clear();
        this.matchClassHashPercent(perfectMatch);
    }

    public void filterRootPackageName(String rootPackage) {
        int libDistance = PackageNameUtil.isParentPackageName(rootPackage, this.libPackageName);
        if (libDistance > 0) {
            ArrayList<ApkPackageProfile> tempCandiApkPackages = new ArrayList<ApkPackageProfile>();
            ArrayList<Double> tempCandiApkPackageSimilarity = new ArrayList<Double>();
            for (ApkPackageProfile apkPackage : this.apkPackageProfiles) {
                if (PackageNameUtil.isParentPackageName(rootPackage, apkPackage.packageName) != libDistance) continue;
                tempCandiApkPackages.add(apkPackage);
                tempCandiApkPackageSimilarity.add(this.candiApkPackageSimilarity.get(this.apkPackageProfiles.indexOf(apkPackage)));
            }
            for (ApkPackageProfile apkPackage : this.apkPackageProfiles) {
                if (tempCandiApkPackages.contains(apkPackage)) continue;
                this.candiApkPackageSimilarity.remove(apkPackage);
            }
            this.apkPackageProfiles = tempCandiApkPackages;
            this.candiApkPackageSimilarity = tempCandiApkPackageSimilarity;
        }
    }
}

