/*
 * Decompiled with CFR 0.152.
 */
package cn.fudan.libpecker.core;

import cn.fudan.libpecker.core.LibApkMapper;
import cn.fudan.libpecker.core.PackagePairCandidate;
import cn.fudan.libpecker.model.ApkPackageProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PackageMapEnumerator {
    Map<String, PackagePairCandidate> libCandidatePackageProfileMap;
    LibApkMapper seedPartition;

    public PackageMapEnumerator(Map<String, PackagePairCandidate> libCandidatePackageProfileMap, LibApkMapper seedPartition) {
        this.libCandidatePackageProfileMap = libCandidatePackageProfileMap;
        this.seedPartition = seedPartition;
    }

    public String toString() {
        StringBuilder output = new StringBuilder();
        output.append("existing mapping: \n");
        for (String libPkgName : this.seedPartition.getExistingPackageMap().keySet()) {
            output.append("\t<" + libPkgName + "> : " + this.seedPartition.getExistingPackageMap().get(libPkgName) + "\n");
        }
        output.append("exhaustiveEnumerate space: \n");
        for (String libPkgName : this.libCandidatePackageProfileMap.keySet()) {
            output.append("\t<" + libPkgName + "> : " + this.libCandidatePackageProfileMap.get(libPkgName).getCandiApkPackages().size() + "\n");
        }
        return output.toString();
    }

    public List<LibApkMapper> exhaustiveEnumerate() {
        ArrayList<LibApkMapper> partitions = new ArrayList<LibApkMapper>();
        partitions.add(this.seedPartition);
        for (int maxEnumerateStep = this.seedPartition.getLibPackages().size(); maxEnumerateStep > 0; --maxEnumerateStep) {
            ArrayList<LibApkMapper> newPartitions = new ArrayList<LibApkMapper>();
            for (LibApkMapper partition : partitions) {
                if (partition.finishPairing()) {
                    newPartitions.add(partition);
                    continue;
                }
                List<LibApkMapper> pairNextList = this.enumerateAllPartitions(partition);
                if (pairNextList == null || pairNextList.size() <= 0) continue;
                for (LibApkMapper nextPartition : pairNextList) {
                    if (newPartitions.contains(nextPartition)) continue;
                    newPartitions.add(nextPartition);
                }
            }
            partitions = newPartitions;
        }
        return partitions;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<LibApkMapper> enumerateAllPartitions(LibApkMapper partition) {
        if (partition.finishPairing()) {
            return null;
        }
        ArrayList<LibApkMapper> nextLayerPartitions = new ArrayList<LibApkMapper>();
        String libPackageName = new ArrayList<String>(partition.getLibPackages()).get(0);
        PackagePairCandidate packageCandidate = this.libCandidatePackageProfileMap.get(libPackageName);
        if (packageCandidate.getCandiApkPackages().size() == 0) {
            boolean paired = partition.makePair(packageCandidate, null);
            if (!paired) throw new RuntimeException("can not be true");
            nextLayerPartitions.add(partition);
            return nextLayerPartitions;
        } else {
            for (ApkPackageProfile apkPackageCandidate : packageCandidate.getCandiApkPackages()) {
                LibApkMapper newPartition = partition.deepClone();
                boolean paired = newPartition.makePair(packageCandidate, apkPackageCandidate);
                if (paired) {
                    nextLayerPartitions.add(newPartition);
                    continue;
                }
                paired = newPartition.makePair(packageCandidate, null);
                if (!paired) throw new RuntimeException("can not be true");
                nextLayerPartitions.add(newPartition);
            }
        }
        return nextLayerPartitions;
    }
}

