/*
 * Decompiled with CFR 0.152.
 */
package cn.fudan.libpecker.core;

import cn.fudan.common.util.PackageNameUtil;
import cn.fudan.libpecker.core.PackagePairCandidate;
import cn.fudan.libpecker.model.ApkPackageProfile;
import cn.fudan.libpecker.model.LibPackageProfile;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LibApkMapper {
    private Set<String> libPackages;
    private Set<String> apkPackages;
    private Map<String, String> libPackageToApkPackageMap;
    private Map<String, String> libClassToApkClassMap;
    private Map<String, List<String>> libRootPackageMap;

    private LibApkMapper() {
    }

    public LibApkMapper(Map<String, LibPackageProfile> libPackageProfileMap, Map<String, ApkPackageProfile> apkPackageProfileMap, Map<String, List<String>> rootPackageMap) {
        this.libPackages = new HashSet<String>();
        this.apkPackages = new HashSet<String>();
        this.libPackageToApkPackageMap = new HashMap<String, String>();
        this.libClassToApkClassMap = new HashMap<String, String>();
        this.libPackages.addAll(libPackageProfileMap.keySet());
        this.apkPackages.addAll(apkPackageProfileMap.keySet());
        this.libRootPackageMap = rootPackageMap;
    }

    public Set<String> getLibPackages() {
        return this.libPackages;
    }

    public Map<String, String> getExistingPackageMap() {
        return this.libPackageToApkPackageMap;
    }

    public Map<String, String> getExistingClassMap() {
        return this.libClassToApkClassMap;
    }

    public boolean makePair(PackagePairCandidate libPackagePairCandidate, ApkPackageProfile apkPackageProfile) {
        String apkPackageName;
        String libPackageName = libPackagePairCandidate.libPackageProfile.packageName;
        String string = apkPackageName = apkPackageProfile == null ? null : apkPackageProfile.packageName;
        if (!this.libPackages.contains(libPackageName)) {
            return false;
        }
        if (apkPackageName == null) {
            this.libPackages.remove(libPackageName);
            this.libPackageToApkPackageMap.put(libPackageName, null);
            for (String libClassName : libPackagePairCandidate.libPackageProfile.getClassList()) {
                this.libClassToApkClassMap.put(libClassName, null);
            }
            return true;
        }
        if (!this.apkPackages.contains(apkPackageName)) {
            return false;
        }
        if (libPackageName.equals(apkPackageName)) {
            this.libPackages.remove(libPackageName);
            this.apkPackages.remove(apkPackageName);
            this.libPackageToApkPackageMap.put(libPackageName, apkPackageName);
            Map<String, String> classNameMap = libPackagePairCandidate.getClassNameMap(apkPackageProfile);
            for (String libClassName : classNameMap.keySet()) {
                this.libClassToApkClassMap.put(libClassName, classNameMap.get(libClassName));
            }
            for (String libClassName : libPackagePairCandidate.libPackageProfile.getClassList()) {
                if (this.libClassToApkClassMap.containsKey(libClassName)) continue;
                this.libClassToApkClassMap.put(libClassName, null);
            }
            return true;
        }
        for (String existingLibPackageName : this.libPackageToApkPackageMap.keySet()) {
            if (this.libPackageToApkPackageMap.get(existingLibPackageName) == null) continue;
            int distance = 0;
            if (PackageNameUtil.isSiblingPackageName(existingLibPackageName, libPackageName)) {
                if (PackageNameUtil.isSiblingPackageName(this.libPackageToApkPackageMap.get(existingLibPackageName), apkPackageName)) continue;
                return false;
            }
            distance = PackageNameUtil.isParentPackageName(existingLibPackageName, libPackageName);
            if (distance > 0) {
                if (distance == PackageNameUtil.isParentPackageName(this.libPackageToApkPackageMap.get(existingLibPackageName), apkPackageName)) continue;
                return false;
            }
            distance = PackageNameUtil.isChildPackageName(existingLibPackageName, libPackageName);
            if (distance > 0) {
                if (distance == PackageNameUtil.isChildPackageName(this.libPackageToApkPackageMap.get(existingLibPackageName), apkPackageName)) continue;
                return false;
            }
            if (!PackageNameUtil.inSameRootPackage(libPackageName, existingLibPackageName, this.libRootPackageMap)) continue;
            String maxCommonLibPackageName = PackageNameUtil.maxCommonPackageName(libPackageName, existingLibPackageName);
            String maxCommonApkPackageName = PackageNameUtil.maxCommonPackageName(apkPackageName, this.libPackageToApkPackageMap.get(existingLibPackageName));
            int libPackageNameDistance1 = PackageNameUtil.packageNameDistance(maxCommonLibPackageName, existingLibPackageName);
            int apkPackageNameDistance1 = PackageNameUtil.packageNameDistance(maxCommonApkPackageName, this.libPackageToApkPackageMap.get(existingLibPackageName));
            if (libPackageNameDistance1 < 0 || apkPackageNameDistance1 < 0 || libPackageNameDistance1 != apkPackageNameDistance1) {
                return false;
            }
            int libPackageNameDistance2 = PackageNameUtil.packageNameDistance(maxCommonLibPackageName, libPackageName);
            int apkPackageNameDistance2 = PackageNameUtil.packageNameDistance(maxCommonApkPackageName, apkPackageName);
            if (libPackageNameDistance2 >= 0 && apkPackageNameDistance2 >= 0 && libPackageNameDistance2 == apkPackageNameDistance2) continue;
            return false;
        }
        this.libPackages.remove(libPackageName);
        this.apkPackages.remove(apkPackageName);
        this.libPackageToApkPackageMap.put(libPackageName, apkPackageName);
        Map<String, String> classNameMap = libPackagePairCandidate.getClassNameMap(apkPackageProfile);
        for (String libClassName : classNameMap.keySet()) {
            this.libClassToApkClassMap.put(libClassName, (String)classNameMap.get(libClassName));
        }
        for (String libClassName : libPackagePairCandidate.libPackageProfile.getClassList()) {
            if (this.libClassToApkClassMap.containsKey(libClassName)) continue;
            this.libClassToApkClassMap.put(libClassName, null);
        }
        return true;
    }

    public boolean finishPairing() {
        return this.libPackages.isEmpty();
    }

    public double similarity(Map<String, PackagePairCandidate> libCandidatePackageProfileMap) {
        HashMap<String, Double> libPackageWeightMap = new HashMap<String, Double>();
        double totalWeight = 0.0;
        for (String libPackageName : libCandidatePackageProfileMap.keySet()) {
            libPackageWeightMap.put(libPackageName, libCandidatePackageProfileMap.get((Object)libPackageName).libPackageProfile.getPackageWeight());
            totalWeight += ((Double)libPackageWeightMap.get(libPackageName)).doubleValue();
        }
        double matchedWeight = 0.0;
        for (String libPackageName : this.libPackageToApkPackageMap.keySet()) {
            String apkPackageName = this.libPackageToApkPackageMap.get(libPackageName);
            if (apkPackageName == null) continue;
            matchedWeight += (Double)libPackageWeightMap.get(libPackageName) * libCandidatePackageProfileMap.get(libPackageName).getApkPackageSimilarity(apkPackageName);
        }
        return matchedWeight / totalWeight;
    }

    public double similarityUpperBound(Map<String, PackagePairCandidate> libCandidatePackageProfileMap) {
        HashMap<String, Double> libPackageWeightMap = new HashMap<String, Double>();
        double totalWeight = 0.0;
        for (String libPackageName : libCandidatePackageProfileMap.keySet()) {
            libPackageWeightMap.put(libPackageName, libCandidatePackageProfileMap.get((Object)libPackageName).libPackageProfile.getPackageWeight());
            totalWeight += ((Double)libPackageWeightMap.get(libPackageName)).doubleValue();
        }
        double matchedWeight = 0.0;
        for (PackagePairCandidate libPackagePairCandidate : libCandidatePackageProfileMap.values()) {
            matchedWeight += (Double)libPackageWeightMap.get(libPackagePairCandidate.libPackageName) * libPackagePairCandidate.getMaxSimilarity();
        }
        return matchedWeight / totalWeight;
    }

    public LibApkMapper deepClone() {
        LibApkMapper newPartition = new LibApkMapper();
        newPartition.libPackages = new HashSet<String>();
        newPartition.apkPackages = new HashSet<String>();
        newPartition.libPackageToApkPackageMap = new HashMap<String, String>();
        newPartition.libClassToApkClassMap = new HashMap<String, String>();
        newPartition.libRootPackageMap = this.libRootPackageMap;
        newPartition.libPackages.addAll(this.libPackages);
        newPartition.apkPackages.addAll(this.apkPackages);
        for (String libPackageName : this.libPackageToApkPackageMap.keySet()) {
            newPartition.libPackageToApkPackageMap.put(libPackageName, this.libPackageToApkPackageMap.get(libPackageName));
        }
        for (String libClassName : this.libClassToApkClassMap.keySet()) {
            newPartition.libClassToApkClassMap.put(libClassName, this.libClassToApkClassMap.get(libClassName));
        }
        return newPartition;
    }

    public String toString() {
        StringBuilder output = new StringBuilder();
        for (String libPkgName : this.libPackageToApkPackageMap.keySet()) {
            output.append("\t<" + libPkgName + "> :" + this.libPackageToApkPackageMap.get(libPkgName) + "\n");
        }
        for (String libPkgName : this.libPackages) {
            if (this.libPackageToApkPackageMap.containsKey(libPkgName)) continue;
            output.append("\t<" + libPkgName + "> : null\n");
        }
        return output.toString();
    }
}

