/*
 * Decompiled with CFR 0.152.
 */
package cn.fudan.libpecker.analysis;

import cn.fudan.analysis.name.NameAnalysis;
import cn.fudan.analysis.name.NameCollector;
import cn.fudan.common.CodeContainer;
import cn.fudan.common.util.PackageNameUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RootPackageAnalysis {
    /*
     * WARNING - void declaration
     */
    public static Map<String, List<String>> extractRootPackages(CodeContainer container) {
        NameCollector names = NameAnalysis.analyzeNames(container);
        Set<String> packageNames = names.allPackageNames();
        ArrayList<Object> rootNodes = new ArrayList<Object>();
        for (String string : packageNames) {
            boolean bl;
            if (string.equals(".")) {
                PackageTreeNode packageTreeNode = new PackageTreeNode();
                packageTreeNode.level = 1;
                packageTreeNode.nodeName = ".";
                packageTreeNode.subNodes = new ArrayList<PackageTreeNode>();
                packageTreeNode.subNodes.add(PackageTreeNode.CURRENT);
                rootNodes.add(packageTreeNode);
                continue;
            }
            boolean bl2 = false;
            for (PackageTreeNode packageTreeNode : rootNodes) {
                if (!packageTreeNode.belong(string)) continue;
                packageTreeNode.insert(string);
                bl = true;
            }
            if (bl) continue;
            PackageTreeNode newRootNode = new PackageTreeNode();
            newRootNode.level = 1;
            newRootNode.nodeName = PackageTreeNode.topNodeName(string);
            newRootNode.insert(string);
            rootNodes.add(newRootNode);
        }
        HashSet<String> rootPackageNames = new HashSet<String>();
        for (PackageTreeNode packageTreeNode : rootNodes) {
            if (packageTreeNode.subNodes == null) {
                rootPackageNames.add(packageTreeNode.nodeName);
                continue;
            }
            if (packageTreeNode.subNodes.contains(PackageTreeNode.CURRENT)) {
                rootPackageNames.add(packageTreeNode.nodeName);
                continue;
            }
            for (PackageTreeNode packageTreeNode2 : packageTreeNode.subNodes) {
                void var8_19;
                String currentRootPackageName = packageTreeNode.nodeName + "." + packageTreeNode2.nodeName;
                while (var8_19.subNodes != null && var8_19.subNodes.size() == 1 && !var8_19.subNodes.contains(PackageTreeNode.CURRENT)) {
                    PackageTreeNode packageTreeNode3 = var8_19.subNodes.get(0);
                    currentRootPackageName = currentRootPackageName + ".";
                    currentRootPackageName = currentRootPackageName + packageTreeNode3.nodeName;
                }
                rootPackageNames.add(currentRootPackageName);
            }
        }
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        for (String rootPackageName : rootPackageNames) {
            hashMap.put(rootPackageName, new ArrayList());
        }
        for (String packageName : packageNames) {
            boolean bl = false;
            for (String rootPackageName : rootPackageNames) {
                if (!rootPackageName.equals(packageName) && PackageNameUtil.isParentPackageName(rootPackageName, packageName) <= 0) continue;
                ((List)hashMap.get(rootPackageName)).add(packageName);
                bl = true;
                break;
            }
            if (bl) continue;
            throw new RuntimeException("can not happen");
        }
        return hashMap;
    }

    private static class PackageTreeNode {
        int level;
        String nodeName;
        List<PackageTreeNode> subNodes;
        public static final PackageTreeNode CURRENT = new PackageTreeNode();

        private PackageTreeNode() {
        }

        public int getSubNodesNum() {
            return this.subNodes.size();
        }

        public boolean belong(String packageName) {
            assert (packageName != null);
            if (packageName.equals(".")) {
                return this.nodeName.equals(".");
            }
            String rootName = PackageTreeNode.topNodeName(packageName);
            return rootName.equals(this.nodeName);
        }

        public static String topNodeName(String packageName) {
            if (!packageName.contains(".")) {
                return packageName;
            }
            return packageName.substring(0, packageName.indexOf(46));
        }

        public static String nextLevelName(String packageName) {
            if (!packageName.contains(".")) {
                return null;
            }
            return packageName.substring(packageName.indexOf(46) + 1);
        }

        public boolean insert(String packageName) {
            String newPackageName;
            if (!this.belong(packageName)) {
                return false;
            }
            if (this.subNodes == null) {
                this.subNodes = new ArrayList<PackageTreeNode>();
            }
            if ((newPackageName = PackageTreeNode.nextLevelName(packageName)) == null) {
                this.subNodes.add(CURRENT);
                return true;
            }
            String newNodeName = PackageTreeNode.topNodeName(newPackageName);
            for (PackageTreeNode node : this.subNodes) {
                if (node == CURRENT || !node.nodeName.equals(newNodeName)) continue;
                return node.insert(newPackageName);
            }
            PackageTreeNode newSubNode = new PackageTreeNode();
            newSubNode.level = this.level + 1;
            newSubNode.nodeName = newNodeName;
            this.subNodes.add(newSubNode);
            return newSubNode.insert(newPackageName);
        }
    }
}

