/*
 * Decompiled with CFR 0.152.
 */
package cn.fudan.common;

import cn.fudan.analysis.util.DexHelper;
import cn.fudan.common.CodeContainer;
import cn.fudan.common.util.HashHelper;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.jf.dexlib2.DexFileFactory;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.DexFile;

public class Sdk
extends CodeContainer {
    private String dexHash;
    private String dexPath;
    private DexFile dex;
    private Set<String> classNameSet = null;

    @Override
    public String codeHash() {
        return this.dexHash;
    }

    @Override
    public String codePath() {
        return this.dexPath;
    }

    @Override
    public Set<? extends ClassDef> getClasses() {
        return this.dex.getClasses();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getTargetSdkClassNameSet() {
        if (this.classNameSet != null) {
            return this.classNameSet;
        }
        Sdk sdk = this;
        synchronized (sdk) {
            this.classNameSet = new HashSet<String>();
            for (ClassDef classDef : this.dex.getClasses()) {
                String className = DexHelper.classType2Name(classDef.getType());
                this.classNameSet.add(className);
            }
            return this.classNameSet;
        }
    }

    public static Sdk loadDefaultSdk() {
        Sdk sdk = new Sdk();
        try {
            String sdkFilePath = "./sdk/android-20.dex";
            sdk.dex = DexFileFactory.loadDexFile(sdkFilePath, Opcodes.getDefault());
            sdk.dexHash = HashHelper.md5_32(new File(sdkFilePath));
            sdk.dexPath = sdkFilePath;
            return sdk;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

