/*
 * Decompiled with CFR 0.152.
 */
package cn.fudan.analysis.util;

import java.util.HashMap;
import org.jf.dexlib2.AccessFlags;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.Method;

public class DexHelper {
    private static HashMap<String, String> shortyMap = new HashMap();

    public static String classType2Name(String classType) {
        classType = classType.replace('/', '.');
        classType = classType.substring(1, classType.length() - 1);
        return classType;
    }

    public static String className2Type(String className) {
        className = className.replace('.', '/');
        return "L" + className + ";";
    }

    public static String getParentPackageName(String pkgName) {
        if (pkgName.indexOf(46) > 0) {
            return pkgName.substring(0, pkgName.lastIndexOf(46));
        }
        return ".";
    }

    public static String getPackageName(String className) {
        if (className.indexOf(46) > 0) {
            return className.substring(0, className.lastIndexOf(46));
        }
        return ".";
    }

    public static String getPackageName(ClassDef clazz) {
        String className = DexHelper.classType2Name(clazz.getType());
        return DexHelper.getPackageName(className);
    }

    public static boolean isCompilerGeneratedMethod(Method m) {
        int accessFlagValue = m.getAccessFlags();
        AccessFlags[] flags = AccessFlags.getAccessFlagsForMethod(accessFlagValue);
        for (int i = 0; i < flags.length; ++i) {
            if (flags[i].getValue() == AccessFlags.BRIDGE.getValue()) {
                return true;
            }
            if (flags[i].getValue() != AccessFlags.SYNTHETIC.getValue()) continue;
            return true;
        }
        return false;
    }

    public static boolean isPrimitiveClass(String classType) {
        return classType.length() == 1;
    }

    public static String getPrimitiveClassName(String primitiveType) {
        return shortyMap.get(primitiveType);
    }

    public static boolean isInnerClass(String className) {
        return className.indexOf(36) >= 0;
    }

    public static String getClassShortName(String className) {
        String shortName = className.indexOf(46) > 0 ? className.substring(className.lastIndexOf(46) + 1) : className;
        if (DexHelper.isInnerClass(shortName)) {
            return shortName.substring(0, shortName.indexOf("$"));
        }
        return shortName;
    }

    public static int getArrayDepth(String classType) {
        int arrayDepth = 0;
        while (classType.startsWith("[")) {
            classType = classType.substring(1);
            ++arrayDepth;
        }
        return arrayDepth;
    }

    public static String getBaseClassTypeOfArray(String classType) {
        while (classType.startsWith("[")) {
            classType = classType.substring(1);
        }
        return classType;
    }

    static {
        shortyMap.put("V", "void");
        shortyMap.put("Z", "boolean");
        shortyMap.put("B", "byte");
        shortyMap.put("S", "short");
        shortyMap.put("C", "char");
        shortyMap.put("I", "int");
        shortyMap.put("J", "long");
        shortyMap.put("F", "float");
        shortyMap.put("D", "double");
    }
}

