/*
 * Decompiled with CFR 0.152.
 */
package cn.fudan.analysis.tree;

import cn.fudan.analysis.tree.ClassNode;
import cn.fudan.analysis.tree.PackageNode;
import cn.fudan.analysis.util.DexHelper;
import cn.fudan.common.CodeContainer;
import java.util.HashSet;
import java.util.Set;
import org.jf.dexlib2.iface.ClassDef;

public class TreeAnalysis {
    public static void freeMem() {
        PackageNode.Factory.clear();
        ClassNode.Factory.clear();
    }

    public static void freeMem(CodeContainer container) {
        PackageNode.Factory.clear(container);
        ClassNode.Factory.clear(container);
    }

    private static Set<PackageNode> groupClassesIntoPackages(CodeContainer container, Set<? extends ClassDef> clazzes) {
        HashSet<PackageNode> pkgs = new HashSet<PackageNode>();
        for (ClassDef classDef : clazzes) {
            String pkgName = DexHelper.getPackageName(classDef);
            String clsName = DexHelper.classType2Name(classDef.getType());
            PackageNode node = PackageNode.Factory.createInstanceIfNotExist(container, pkgName);
            node.addClass(ClassNode.Factory.createInstanceIfNotExist(container, clsName, classDef));
            pkgs.add(node);
        }
        return pkgs;
    }

    public static Set<PackageNode> analyze(CodeContainer dexCode) {
        Set<PackageNode> packages = TreeAnalysis.groupClassesIntoPackages(dexCode, dexCode.getClasses());
        block0: for (PackageNode node : packages) {
            String pkgName = node.getPackageName();
            String parentPkgName = DexHelper.getParentPackageName(pkgName);
            while (!PackageNode.Factory.isDefaultPackage(parentPkgName)) {
                if (PackageNode.Factory.containsInstance(dexCode, parentPkgName)) {
                    PackageNode parentNode = PackageNode.Factory.getInstance(dexCode, parentPkgName);
                    parentNode.addSubPackage(node);
                    continue block0;
                }
                parentPkgName = DexHelper.getParentPackageName(parentPkgName);
            }
        }
        return packages;
    }
}

