/*
 * Decompiled with CFR 0.152.
 */
package cn.fudan.analysis.tree;

import cn.fudan.analysis.tree.ClassNode;
import cn.fudan.common.CodeContainer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class PackageNode {
    private CodeContainer container;
    private String packageName;
    private Set<ClassNode> includedClasss = new HashSet<ClassNode>();
    private Set<PackageNode> subPackages = new HashSet<PackageNode>();

    private PackageNode(CodeContainer container, String packageName) {
        this.container = container;
        this.packageName = packageName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public CodeContainer getContainer() {
        return this.container;
    }

    protected void finalize() {
        this.includedClasss.clear();
        this.subPackages.clear();
        this.packageName = null;
    }

    public void addClass(ClassNode clazz) {
        if (!this.includedClasss.contains(clazz)) {
            this.includedClasss.add(clazz);
        }
    }

    public void addSubPackage(PackageNode pkg) {
        if (!this.subPackages.contains(pkg)) {
            this.subPackages.add(pkg);
        }
    }

    public int getSubPackagesNum() {
        return this.subPackages.size();
    }

    public int getIncludedClassNum() {
        return this.includedClasss.size();
    }

    public Set<ClassNode> getIncludedClasss() {
        return this.includedClasss;
    }

    public Set<PackageNode> getSubPackages() {
        return this.subPackages;
    }

    public String toString() {
        String text = this.packageName;
        text = text + "\n";
        for (PackageNode pkg : this.subPackages) {
            text = text + "    [pkg]" + pkg.getPackageName() + "\n";
        }
        for (ClassNode clazz : this.includedClasss) {
            text = text + "    [clz]" + clazz.getClassName() + "\n";
        }
        return text;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PackageNode) {
            return this.getPackageName().equals(((PackageNode)obj).getPackageName());
        }
        return false;
    }

    public static class Factory {
        private static HashMap<CodeContainer, HashMap<String, PackageNode>> instances = new HashMap();
        public static final String DEFAULT_PACKAGE = ".";

        public static synchronized void clear() {
            instances.clear();
        }

        public static synchronized void clear(CodeContainer container) {
            if (instances.containsKey(container)) {
                instances.remove(container);
            }
        }

        public static boolean isDefaultPackage(String pkgName) {
            return pkgName == null || DEFAULT_PACKAGE.equals(pkgName);
        }

        public static synchronized PackageNode createInstanceIfNotExist(CodeContainer container, String pkgName) {
            if (!instances.containsKey(container)) {
                instances.put(container, new HashMap());
            }
            if (pkgName == null) {
                pkgName = DEFAULT_PACKAGE;
            }
            if (instances.get(container).containsKey(pkgName)) {
                return instances.get(container).get(pkgName);
            }
            instances.get(container).put(pkgName, new PackageNode(container, pkgName));
            return instances.get(container).get(pkgName);
        }

        public static synchronized boolean containsInstance(CodeContainer container, String pkgName) {
            if (!instances.containsKey(container)) {
                return false;
            }
            if (pkgName == null) {
                pkgName = DEFAULT_PACKAGE;
            }
            return instances.get(container).containsKey(pkgName);
        }

        public static synchronized PackageNode getInstance(CodeContainer container, String pkgName) {
            if (!instances.containsKey(container)) {
                return null;
            }
            if (pkgName == null) {
                pkgName = DEFAULT_PACKAGE;
            }
            return instances.get(container).get(pkgName);
        }
    }
}

