/*
 * Decompiled with CFR 0.152.
 */
package cn.fudan.analysis.tree;

import cn.fudan.analysis.util.DexHelper;
import cn.fudan.common.CodeContainer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.Field;
import org.jf.dexlib2.iface.Method;

public class ClassNode {
    private CodeContainer container;
    private ClassDef classDefInDex;
    private String className;

    public ClassDef getClassDefInDex() {
        return this.classDefInDex;
    }

    private ClassNode(CodeContainer container, String className, ClassDef clazz) {
        this.container = container;
        this.className = className;
        this.classDefInDex = clazz;
    }

    public String getClassName() {
        return this.className;
    }

    public Set<Method> getNormalizedMethods() {
        HashSet<Method> normalizedMethods = new HashSet<Method>();
        for (Method method : this.classDefInDex.getMethods()) {
            if (DexHelper.isCompilerGeneratedMethod(method)) continue;
            normalizedMethods.add(method);
        }
        return normalizedMethods;
    }

    public int getNormalizedMethodsNum() {
        return this.getNormalizedMethods().size();
    }

    public Iterable<? extends Method> getMethods() {
        return this.classDefInDex.getMethods();
    }

    public Iterable<? extends Field> getFields() {
        return this.classDefInDex.getFields();
    }

    public String toString() {
        return this.className;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ClassNode) {
            return this.getClassName().equals(((ClassNode)obj).getClassName());
        }
        return false;
    }

    public static class Factory {
        private static HashMap<CodeContainer, HashMap<String, ClassNode>> instances = new HashMap();

        public static synchronized void clear() {
            instances.clear();
        }

        public static synchronized void clear(CodeContainer container) {
            if (instances.containsKey(container)) {
                instances.remove(container);
            }
        }

        public static synchronized ClassNode createInstanceIfNotExist(CodeContainer container, String className, ClassDef clazz) {
            if (!instances.containsKey(container)) {
                instances.put(container, new HashMap());
            }
            if (instances.get(container).containsKey(className)) {
                return instances.get(container).get(className);
            }
            ClassNode classNode = new ClassNode(container, className, clazz);
            instances.get(container).put(className, classNode);
            return classNode;
        }

        public static synchronized boolean containsInstance(CodeContainer container, String className) {
            if (!instances.containsKey(container)) {
                return false;
            }
            return instances.get(container).containsKey(className);
        }

        public static synchronized ClassNode getInstance(CodeContainer container, String className) {
            if (!instances.containsKey(container)) {
                return null;
            }
            return instances.get(container).get(className);
        }
    }
}

