/*
 * Decompiled with CFR 0.152.
 */
package cn.fudan.analysis.profile;

import cn.fudan.analysis.profile.ClassProfile;
import cn.fudan.analysis.tree.ClassNode;
import cn.fudan.analysis.tree.PackageNode;
import cn.fudan.analysis.tree.TreeAnalysis;
import cn.fudan.common.CodeContainer;
import cn.fudan.common.Sdk;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ProfileGenerator {
    private static Map<PackageNode, Set<ClassProfile>> packageProfileMap = new HashMap<PackageNode, Set<ClassProfile>>();

    public static Set<ClassProfile> generate(CodeContainer codeContainer, Set<String> targetSdkClassNameSet) {
        Set<PackageNode> packageNodes = TreeAnalysis.analyze(codeContainer);
        HashSet<ClassProfile> allProfiles = new HashSet<ClassProfile>();
        for (PackageNode packageNode : packageNodes) {
            allProfiles.addAll(ProfileGenerator.generate(packageNode, targetSdkClassNameSet));
        }
        return allProfiles;
    }

    public static Set<ClassProfile> generate(CodeContainer codeContainer) {
        return ProfileGenerator.generate(codeContainer, Sdk.loadDefaultSdk().getTargetSdkClassNameSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<ClassProfile> generate(PackageNode packageNode, Set<String> targetSdkClassNameSet) {
        if (packageProfileMap.containsKey(packageNode)) {
            return packageProfileMap.get(packageNode);
        }
        Set<ClassNode> classNodes = packageNode.getIncludedClasss();
        HashSet<ClassProfile> classProfiles = new HashSet<ClassProfile>();
        for (ClassNode classNode : classNodes) {
            ClassProfile cp = new ClassProfile(classNode, targetSdkClassNameSet);
            classProfiles.add(cp);
        }
        if (packageProfileMap.containsKey(packageNode)) {
            return packageProfileMap.get(packageNode);
        }
        Class<ProfileGenerator> clazz = ProfileGenerator.class;
        synchronized (ProfileGenerator.class) {
            packageProfileMap.put(packageNode, classProfiles);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return classProfiles;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        Class<ProfileGenerator> clazz = ProfileGenerator.class;
        synchronized (ProfileGenerator.class) {
            packageProfileMap.clear();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

