/*
 * Decompiled with CFR 0.152.
 */
package cn.fudan.analysis.profile;

import cn.fudan.analysis.profile.ClassNameProfile;
import cn.fudan.analysis.profile.ClassProfile;
import cn.fudan.analysis.profile.ProfileSignature;
import cn.fudan.analysis.util.DexHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jf.dexlib2.AccessFlags;
import org.jf.dexlib2.dexbacked.DexBackedMethod;
import org.jf.dexlib2.dexbacked.value.DexBackedArrayEncodedValue;
import org.jf.dexlib2.dexbacked.value.DexBackedTypeEncodedValue;
import org.jf.dexlib2.iface.Annotation;
import org.jf.dexlib2.iface.AnnotationElement;
import org.jf.dexlib2.iface.MethodParameter;
import org.jf.dexlib2.iface.value.EncodedValue;

public class MethodProfile
implements ProfileSignature {
    public DexBackedMethod method;
    public int accessFlags;
    public HashSet<String> accessFlagSet;
    public ClassNameProfile returnTypeProfile;
    public ArrayList<ClassNameProfile> parameterTypeProfileList;
    public HashSet<ClassNameProfile> throwExceptionClassNameProfileSet;
    public String hash;
    public String hashStrict;

    /*
     * WARNING - void declaration
     */
    public MethodProfile(DexBackedMethod method, ClassProfile thisClassProfile, Set<String> targetSdkClassNameSet) {
        void var6_9;
        this.method = method;
        this.accessFlags = method.getAccessFlags();
        this.accessFlagSet = new HashSet();
        AccessFlags[] accessFlagsArray = AccessFlags.getAccessFlagsForField(method.getAccessFlags());
        int n = accessFlagsArray.length;
        boolean bl = false;
        while (var6_9 < n) {
            AccessFlags flags = accessFlagsArray[var6_9];
            this.accessFlagSet.add(flags.toString());
            ++var6_9;
        }
        this.returnTypeProfile = ClassNameProfile.createInstance(method.getReturnType(), thisClassProfile, targetSdkClassNameSet);
        this.parameterTypeProfileList = new ArrayList();
        for (MethodParameter methodParameter : method.getParameters()) {
            this.parameterTypeProfileList.add(ClassNameProfile.createInstance(methodParameter.getType(), thisClassProfile, targetSdkClassNameSet));
        }
        Set<? extends Annotation> annotations = this.method.getAnnotations();
        this.throwExceptionClassNameProfileSet = new HashSet();
        for (Annotation annotation : annotations) {
            if (!"dalvik.annotation.Throws".equals(DexHelper.classType2Name(annotation.getType()))) continue;
            for (AnnotationElement annotationElement : annotation.getElements()) {
                if (annotationElement.getValue() instanceof DexBackedArrayEncodedValue) {
                    List<? extends EncodedValue> values = ((DexBackedArrayEncodedValue)annotationElement.getValue()).getValue();
                    for (EncodedValue encodedValue : values) {
                        if (encodedValue instanceof DexBackedTypeEncodedValue) {
                            this.throwExceptionClassNameProfileSet.add(ClassNameProfile.createInstance(((DexBackedTypeEncodedValue)encodedValue).getValue(), thisClassProfile, targetSdkClassNameSet));
                            continue;
                        }
                        throw new RuntimeException("missing some cases in get thrown exception class info in method: " + method.getDefiningClass() + "," + method.getName());
                    }
                    continue;
                }
                throw new RuntimeException("missing some cases in get thrown exception class info in method: " + method.getDefiningClass() + "," + method.getName());
            }
        }
    }

    public boolean isStatic() {
        return this.accessFlagSet.contains(AccessFlags.STATIC.toString());
    }

    public boolean isFinal() {
        return this.accessFlagSet.contains(AccessFlags.FINAL.toString());
    }

    public String descriptor() {
        StringBuilder sb = new StringBuilder(this.method.getReturnType() + "-" + this.method.getName() + "-");
        for (MethodParameter methodParameter : this.method.getParameters()) {
            sb.append(methodParameter.getType() + ",");
        }
        return sb.toString();
    }

    @Override
    public String composeSignature() {
        StringBuilder sig = new StringBuilder();
        sig.append(ClassProfile.genSigForAccessFlags(this.accessFlags) + ";");
        sig.append(this.returnTypeProfile.composeSignature());
        sig.append(";" + this.parameterTypeProfileList.size());
        for (ClassNameProfile profile : this.parameterTypeProfileList) {
            sig.append(";" + profile.composeSignature());
        }
        sig.append(";" + this.throwExceptionClassNameProfileSet.size());
        ArrayList<ClassNameProfile> exceptionClassList = new ArrayList<ClassNameProfile>(this.throwExceptionClassNameProfileSet);
        Collections.sort(exceptionClassList, new Comparator<ClassNameProfile>(){

            @Override
            public int compare(ClassNameProfile o1, ClassNameProfile o2) {
                return o1.composeSignature().compareTo(o2.composeSignature());
            }
        });
        for (ClassNameProfile profile : exceptionClassList) {
            sig.append(";" + profile.composeSignature());
        }
        return sig.toString();
    }

    @Override
    public String composeSignatureStrict() {
        StringBuilder sig = new StringBuilder();
        sig.append(ClassProfile.genSigForAccessFlags(this.accessFlags) + ";");
        sig.append(this.returnTypeProfile.composeSignatureStrict());
        sig.append(";" + this.parameterTypeProfileList.size());
        for (ClassNameProfile profile : this.parameterTypeProfileList) {
            sig.append(";" + profile.composeSignatureStrict());
        }
        return sig.toString();
    }
}

