/*
 * Decompiled with CFR 0.152.
 */
package cn.fudan.analysis.profile;

import cn.fudan.analysis.profile.ClassNameProfile;
import cn.fudan.analysis.profile.ClassProfile;
import cn.fudan.analysis.profile.ProfileSignature;
import java.util.HashSet;
import java.util.Set;
import org.jf.dexlib2.AccessFlags;
import org.jf.dexlib2.base.value.BaseBooleanEncodedValue;
import org.jf.dexlib2.base.value.BaseByteEncodedValue;
import org.jf.dexlib2.base.value.BaseCharEncodedValue;
import org.jf.dexlib2.base.value.BaseDoubleEncodedValue;
import org.jf.dexlib2.base.value.BaseEnumEncodedValue;
import org.jf.dexlib2.base.value.BaseFloatEncodedValue;
import org.jf.dexlib2.base.value.BaseIntEncodedValue;
import org.jf.dexlib2.base.value.BaseLongEncodedValue;
import org.jf.dexlib2.base.value.BaseShortEncodedValue;
import org.jf.dexlib2.base.value.BaseStringEncodedValue;
import org.jf.dexlib2.dexbacked.DexBackedField;
import org.jf.dexlib2.iface.reference.FieldReference;
import org.jf.dexlib2.iface.value.EncodedValue;

public class FieldProfile
implements ProfileSignature {
    public DexBackedField field;
    public int accessFlags;
    public HashSet<String> accessFlagSet;
    public ClassNameProfile typeProfile;
    public EncodedValue initialValue;
    public String hash;
    public String hashStrict;

    public FieldProfile(DexBackedField field, ClassProfile thisClassProfile, Set<String> targetSdkClassNameSet) {
        this.field = field;
        this.accessFlags = field.getAccessFlags();
        this.accessFlagSet = new HashSet();
        for (AccessFlags flags : AccessFlags.getAccessFlagsForField(field.getAccessFlags())) {
            this.accessFlagSet.add(flags.toString());
        }
        this.typeProfile = ClassNameProfile.createInstance(field.getType(), thisClassProfile, targetSdkClassNameSet);
        this.initialValue = field.getInitialValue();
    }

    public boolean isStatic() {
        return this.accessFlagSet.contains(AccessFlags.STATIC.toString());
    }

    public boolean isFinal() {
        return this.accessFlagSet.contains(AccessFlags.FINAL.toString());
    }

    public String getInitialValueString() {
        if (this.initialValue != null) {
            return this.stringfyEncodedValue(this.initialValue);
        }
        return null;
    }

    private String stringfyEncodedValue(EncodedValue initialValue) {
        switch (initialValue.getValueType()) {
            case 0: {
                return "" + ((BaseByteEncodedValue)initialValue).getValue();
            }
            case 2: {
                return "" + ((BaseShortEncodedValue)initialValue).getValue();
            }
            case 3: {
                return "" + ((BaseCharEncodedValue)initialValue).getValue();
            }
            case 4: {
                return "" + ((BaseIntEncodedValue)initialValue).getValue();
            }
            case 6: {
                return "" + ((BaseLongEncodedValue)initialValue).getValue();
            }
            case 16: {
                return "" + ((BaseFloatEncodedValue)initialValue).getValue();
            }
            case 17: {
                return "" + ((BaseDoubleEncodedValue)initialValue).getValue();
            }
            case 23: {
                return "" + ((BaseStringEncodedValue)initialValue).getValue();
            }
            case 31: {
                return "" + ((BaseBooleanEncodedValue)initialValue).getValue();
            }
            case 27: {
                FieldReference enumFieldReference = ((BaseEnumEncodedValue)initialValue).getValue();
                return enumFieldReference.getDefiningClass() + enumFieldReference.getType() + enumFieldReference.getName();
            }
            case 28: {
                return "array";
            }
            case 30: {
                return "uninitialized";
            }
            case 29: {
                return "annotation";
            }
            case 24: {
                return "type";
            }
            case 25: {
                return "field";
            }
            case 26: {
                return "method";
            }
        }
        return "uninitialized";
    }

    public String descriptor() {
        return this.field.getType() + "-" + this.field.getName();
    }

    @Override
    public String composeSignatureStrict() {
        StringBuilder sig = new StringBuilder();
        sig.append(ClassProfile.genSigForAccessFlags(this.accessFlags) + ";");
        sig.append(this.typeProfile.composeSignatureStrict() + ";");
        return sig.toString();
    }

    @Override
    public String composeSignature() {
        StringBuilder sig = new StringBuilder();
        sig.append(ClassProfile.genSigForAccessFlags(this.accessFlags) + ";");
        sig.append(this.typeProfile.composeSignature() + ";");
        if (this.isFinal()) {
            if (this.initialValue == null) {
                sig.append("uninitialized");
            } else {
                sig.append(this.stringfyEncodedValue(this.initialValue));
            }
        }
        return sig.toString();
    }
}

