/*
 * Decompiled with CFR 0.152.
 */
package cn.fudan.analysis.profile;

import cn.fudan.analysis.profile.ClassNameProfile;
import cn.fudan.analysis.profile.FieldProfile;
import cn.fudan.analysis.profile.MethodProfile;
import cn.fudan.analysis.profile.ProfileSignature;
import cn.fudan.analysis.tree.ClassNode;
import cn.fudan.analysis.util.DexHelper;
import cn.fudan.common.util.HashHelper;
import cn.fudan.libpecker.model.SimpleClassProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jf.dexlib2.AccessFlags;
import org.jf.dexlib2.dexbacked.DexBackedField;
import org.jf.dexlib2.dexbacked.DexBackedMethod;
import org.jf.dexlib2.iface.Field;
import org.jf.dexlib2.iface.Method;

public class ClassProfile
implements ProfileSignature,
SimpleClassProfile {
    public ClassNode classNode;
    public int accessFlags;
    public HashSet<String> accessFlagSet;
    public ClassNameProfile superClassProfile;
    public HashSet<ClassNameProfile> interfaceProfileSet;
    public HashSet<FieldProfile> staticFieldProfiles;
    public HashSet<FieldProfile> instanceFieldProfiles;
    public HashSet<MethodProfile> staticMethodProfiles;
    public HashSet<MethodProfile> instanceMethodProfiles;
    private String hash;
    private String hashStrict;
    private String hashBasic;
    private String hashBasicStrict;
    private List<String> methodHashList = null;
    private List<String> methodHashStrictList = null;
    private List<String> fieldHashList = null;
    private List<String> fieldHashStrictList = null;

    public ClassProfile(ClassNode classNode, Set<String> targetSdkClassNameSet) {
        this.classNode = classNode;
        this.accessFlags = classNode.getClassDefInDex().getAccessFlags();
        this.accessFlagSet = new HashSet();
        for (AccessFlags flags : AccessFlags.getAccessFlagsForField(this.accessFlags)) {
            this.accessFlagSet.add(flags.toString());
        }
        this.superClassProfile = ClassNameProfile.createInstance(classNode.getClassDefInDex().getSuperclass(), this, targetSdkClassNameSet);
        this.interfaceProfileSet = new HashSet();
        for (String string : classNode.getClassDefInDex().getInterfaces()) {
            this.interfaceProfileSet.add(ClassNameProfile.createInstance(string, this, targetSdkClassNameSet));
        }
        this.staticFieldProfiles = new HashSet();
        this.instanceFieldProfiles = new HashSet();
        for (Field field : classNode.getFields()) {
            DexBackedField df = (DexBackedField)field;
            FieldProfile fieldProfile = new FieldProfile(df, this, targetSdkClassNameSet);
            if (fieldProfile.isStatic()) {
                this.staticFieldProfiles.add(fieldProfile);
                continue;
            }
            this.instanceFieldProfiles.add(fieldProfile);
        }
        this.staticMethodProfiles = new HashSet();
        this.instanceMethodProfiles = new HashSet();
        for (Method method : classNode.getNormalizedMethods()) {
            if (DexHelper.isCompilerGeneratedMethod(method)) continue;
            DexBackedMethod dm = (DexBackedMethod)method;
            MethodProfile mp = new MethodProfile(dm, this, targetSdkClassNameSet);
            if (mp.isStatic()) {
                this.staticMethodProfiles.add(mp);
                continue;
            }
            this.instanceMethodProfiles.add(mp);
        }
    }

    @Override
    public String getClassName() {
        return this.classNode.getClassName();
    }

    public static synchronized String getMethodHash(MethodProfile profile) {
        if (profile.hash == null) {
            profile.hash = HashHelper.hash(profile.composeSignature());
        }
        return profile.hash;
    }

    public static synchronized String getMethodHashStrict(MethodProfile profile) {
        if (profile.hashStrict == null) {
            profile.hashStrict = HashHelper.hash(profile.composeSignatureStrict());
        }
        return profile.hashStrict;
    }

    public static synchronized String getFieldHash(FieldProfile profile) {
        if (profile.hash == null) {
            profile.hash = HashHelper.hash(profile.composeSignature());
        }
        return profile.hash;
    }

    public static synchronized String getFieldHashStrict(FieldProfile profile) {
        if (profile.hashStrict == null) {
            profile.hashStrict = HashHelper.hash(profile.composeSignatureStrict());
        }
        return profile.hashStrict;
    }

    @Override
    public synchronized String getClassHash() {
        if (this.hash == null) {
            this.hash = HashHelper.hash(this.composeSignature());
        }
        return this.hash;
    }

    @Override
    public synchronized String getClassHashStrict() {
        if (this.hashStrict == null) {
            this.hashStrict = HashHelper.hash(this.composeSignatureStrict());
        }
        return this.hashStrict;
    }

    @Override
    public synchronized String getBasicHash() {
        if (this.hashBasic == null) {
            this.hashBasic = HashHelper.hash(this.composeClassSignatureBasic());
        }
        return this.hashBasic;
    }

    @Override
    public synchronized String getBasicHashStrict() {
        if (this.hashBasicStrict == null) {
            this.hashBasicStrict = HashHelper.hash(this.composeClassSignatureBasicStrict());
        }
        return this.hashBasicStrict;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getMethodHashList() {
        if (this.methodHashList != null) {
            return this.methodHashList;
        }
        ClassProfile classProfile = this;
        synchronized (classProfile) {
            this.methodHashList = new ArrayList<String>();
            for (MethodProfile methodProfile : this.staticMethodProfiles) {
                this.methodHashList.add(ClassProfile.getMethodHash(methodProfile));
            }
            for (MethodProfile methodProfile : this.instanceMethodProfiles) {
                this.methodHashList.add(ClassProfile.getMethodHash(methodProfile));
            }
            return this.methodHashList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getMethodHashStrictList() {
        if (this.methodHashStrictList != null) {
            return this.methodHashStrictList;
        }
        ClassProfile classProfile = this;
        synchronized (classProfile) {
            this.methodHashStrictList = new ArrayList<String>();
            for (MethodProfile methodProfile : this.staticMethodProfiles) {
                this.methodHashStrictList.add(ClassProfile.getMethodHashStrict(methodProfile));
            }
            for (MethodProfile methodProfile : this.instanceMethodProfiles) {
                this.methodHashStrictList.add(ClassProfile.getMethodHashStrict(methodProfile));
            }
            return this.methodHashStrictList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getFieldHashList() {
        if (this.fieldHashList != null) {
            return this.fieldHashList;
        }
        ClassProfile classProfile = this;
        synchronized (classProfile) {
            this.fieldHashList = new ArrayList<String>();
            for (FieldProfile fieldProfile : this.staticFieldProfiles) {
                if (fieldProfile.isFinal() && fieldProfile.field.getName().equals("serialVersionUID")) continue;
                this.fieldHashList.add(ClassProfile.getFieldHash(fieldProfile));
            }
            for (FieldProfile fieldProfile : this.instanceFieldProfiles) {
                if (fieldProfile.isFinal() && fieldProfile.field.getName().equals("serialVersionUID")) continue;
                this.fieldHashList.add(ClassProfile.getFieldHash(fieldProfile));
            }
            return this.fieldHashList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getFieldHashStrictList() {
        if (this.fieldHashStrictList != null) {
            return this.fieldHashStrictList;
        }
        ClassProfile classProfile = this;
        synchronized (classProfile) {
            this.fieldHashStrictList = new ArrayList<String>();
            for (FieldProfile fieldProfile : this.staticFieldProfiles) {
                if (fieldProfile.isFinal() && fieldProfile.field.getName().equals("serialVersionUID")) continue;
                this.fieldHashStrictList.add(ClassProfile.getFieldHashStrict(fieldProfile));
            }
            for (FieldProfile fieldProfile : this.instanceFieldProfiles) {
                if (fieldProfile.isFinal() && fieldProfile.field.getName().equals("serialVersionUID")) continue;
                this.fieldHashStrictList.add(ClassProfile.getFieldHashStrict(fieldProfile));
            }
            return this.fieldHashStrictList;
        }
    }

    private String composeHashStr(List<String> hashList) {
        StringBuilder sb = new StringBuilder();
        sb.append(hashList.size());
        for (String hash : hashList) {
            sb.append(",");
            sb.append(hash);
        }
        return sb.toString();
    }

    private String composeClassSignatureBasic() {
        StringBuilder basicSig = new StringBuilder();
        basicSig.append(ClassProfile.genSigForAccessFlags(this.accessFlags) + ";");
        basicSig.append(this.superClassProfile.composeSignature());
        basicSig.append(";" + this.interfaceProfileSet.size());
        ArrayList<String> interfaceList = new ArrayList<String>();
        for (ClassNameProfile classNameProfile : this.interfaceProfileSet) {
            interfaceList.add(classNameProfile.composeSignature());
        }
        Collections.sort(interfaceList);
        for (String string : interfaceList) {
            basicSig.append(";" + string);
        }
        return basicSig.toString();
    }

    private String composeClassSignatureBasicStrict() {
        StringBuilder basicSig = new StringBuilder();
        basicSig.append(ClassProfile.genSigForAccessFlags(this.accessFlags) + ";");
        basicSig.append(this.superClassProfile.composeSignature());
        return basicSig.toString();
    }

    public static int genSigForAccessFlags(int accessFlags) {
        int d = accessFlags & AccessFlags.STATIC.getValue();
        int e = accessFlags & AccessFlags.SYNCHRONIZED.getValue();
        int f = accessFlags & AccessFlags.NATIVE.getValue();
        int h = accessFlags & AccessFlags.INTERFACE.getValue();
        return d | e | f | h;
    }

    @Override
    public String composeSignatureStrict() {
        StringBuilder hashStr = new StringBuilder();
        hashStr.append(ClassProfile.genSigForAccessFlags(this.accessFlags) + ";");
        hashStr.append(this.superClassProfile.composeSignature());
        hashStr.append(";" + this.interfaceProfileSet.size());
        ArrayList<String> interfaceList = new ArrayList<String>();
        for (ClassNameProfile classNameProfile : this.interfaceProfileSet) {
            interfaceList.add(classNameProfile.composeSignature());
        }
        Collections.sort(interfaceList);
        for (String string : interfaceList) {
            hashStr.append(";" + string);
        }
        ArrayList<String> hashList = new ArrayList<String>();
        for (FieldProfile fieldProfile : this.staticFieldProfiles) {
            if (fieldProfile.isFinal() && fieldProfile.field.getName().equals("serialVersionUID")) continue;
            hashList.add(ClassProfile.getFieldHashStrict(fieldProfile));
        }
        Collections.sort(hashList);
        hashStr.append(";");
        hashStr.append(this.composeHashStr(hashList));
        hashList = new ArrayList();
        for (FieldProfile fieldProfile : this.instanceFieldProfiles) {
            hashList.add(ClassProfile.getFieldHashStrict(fieldProfile));
        }
        Collections.sort(hashList);
        hashStr.append(";");
        hashStr.append(this.composeHashStr(hashList));
        hashList = new ArrayList();
        for (MethodProfile methodProfile : this.staticMethodProfiles) {
            hashList.add(ClassProfile.getMethodHashStrict(methodProfile));
        }
        Collections.sort(hashList);
        hashStr.append(";");
        hashStr.append(this.composeHashStr(hashList));
        hashList = new ArrayList();
        for (MethodProfile methodProfile : this.instanceMethodProfiles) {
            hashList.add(ClassProfile.getMethodHashStrict(methodProfile));
        }
        Collections.sort(hashList);
        hashStr.append(";");
        hashStr.append(this.composeHashStr(hashList));
        return hashStr.toString();
    }

    @Override
    public String composeSignature() {
        StringBuilder hashStr = new StringBuilder();
        hashStr.append(ClassProfile.genSigForAccessFlags(this.accessFlags) + ";");
        hashStr.append(this.superClassProfile.composeSignature());
        hashStr.append(";" + this.interfaceProfileSet.size());
        ArrayList<String> interfaceList = new ArrayList<String>();
        for (ClassNameProfile classNameProfile : this.interfaceProfileSet) {
            interfaceList.add(classNameProfile.composeSignature());
        }
        Collections.sort(interfaceList);
        for (String string : interfaceList) {
            hashStr.append(";" + string);
        }
        ArrayList<String> hashList = new ArrayList<String>();
        for (FieldProfile fieldProfile : this.staticFieldProfiles) {
            if (fieldProfile.isFinal() && fieldProfile.field.getName().equals("serialVersionUID")) continue;
            hashList.add(ClassProfile.getFieldHash(fieldProfile));
        }
        Collections.sort(hashList);
        hashStr.append(";");
        hashStr.append(this.composeHashStr(hashList));
        hashList = new ArrayList();
        for (FieldProfile fieldProfile : this.instanceFieldProfiles) {
            hashList.add(ClassProfile.getFieldHash(fieldProfile));
        }
        Collections.sort(hashList);
        hashStr.append(";");
        hashStr.append(this.composeHashStr(hashList));
        hashList = new ArrayList();
        for (MethodProfile methodProfile : this.staticMethodProfiles) {
            hashList.add(ClassProfile.getMethodHash(methodProfile));
        }
        Collections.sort(hashList);
        hashStr.append(";");
        hashStr.append(this.composeHashStr(hashList));
        hashList = new ArrayList();
        for (MethodProfile methodProfile : this.instanceMethodProfiles) {
            hashList.add(ClassProfile.getMethodHash(methodProfile));
        }
        Collections.sort(hashList);
        hashStr.append(";");
        hashStr.append(this.composeHashStr(hashList));
        return hashStr.toString();
    }
}

