/*
 * Decompiled with CFR 0.152.
 */
package cn.fudan.analysis.profile;

import cn.fudan.analysis.profile.ClassProfile;
import cn.fudan.analysis.profile.ProfileSignature;
import cn.fudan.analysis.util.DexHelper;
import java.util.Set;

public class ClassNameProfile
implements ProfileSignature {
    public ClassType type;
    public String name;
    public int arrayDimension;

    private ClassNameProfile() {
    }

    public static ClassNameProfile createInstance(String thisClassType, ClassProfile profileReferer, Set<String> targetSdkClassNameSet) {
        ClassNameProfile nameProfile = new ClassNameProfile();
        nameProfile.arrayDimension = DexHelper.getArrayDepth(thisClassType);
        nameProfile.name = DexHelper.getBaseClassTypeOfArray(thisClassType);
        if (!DexHelper.isPrimitiveClass(nameProfile.name)) {
            nameProfile.name = DexHelper.classType2Name(nameProfile.name);
        }
        nameProfile.type = targetSdkClassNameSet.contains(nameProfile.name) || DexHelper.isPrimitiveClass(nameProfile.name) ? ClassType.SYS_LIB_CLASS : (DexHelper.getPackageName(nameProfile.name).equals(DexHelper.getPackageName(profileReferer.getClassName())) ? ClassType.SAME_PKG_CLASS : ClassType.OTHER_PKG_CLASS);
        return nameProfile;
    }

    @Override
    public String composeSignatureStrict() {
        return this.composeSignature();
    }

    @Override
    public String composeSignature() {
        StringBuilder sig = new StringBuilder();
        sig.append(this.type.ordinal() + ",");
        sig.append(this.arrayDimension + ",");
        switch (this.type) {
            case SYS_LIB_CLASS: {
                sig.append(this.name);
                break;
            }
            case SAME_PKG_CLASS: {
                sig.append("X");
                break;
            }
            case OTHER_PKG_CLASS: {
                sig.append("Y");
                break;
            }
            default: {
                sig.append("Y");
            }
        }
        return sig.toString();
    }

    public static enum ClassType {
        SYS_LIB_CLASS,
        SAME_PKG_CLASS,
        OTHER_PKG_CLASS;

    }
}

